/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXpathedMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public abstract class MWAbstractXmlDirectMapping
extends MWDirectMapping
implements MWXmlMapping,
MWXpathedMapping,
MWXpathContext {
    private MWXmlField xmlField;

    protected MWAbstractXmlDirectMapping() {
    }

    MWAbstractXmlDirectMapping(MWXmlDescriptor parent, MWClassAttribute attribute, String name) {
        super(parent, attribute, name);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.xmlField = new MWXmlField(this);
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.xmlField);
    }

    @Override
    protected MWTypeConversionConverter buildTypeConversionConverter() {
        return new MWXmlTypeConversionConverter(this);
    }

    @Override
    public MWXmlField getXmlField() {
        return this.xmlField;
    }

    @Override
    public MWSchemaContextComponent schemaContext() {
        return this.xmlDescriptor().getSchemaContext();
    }

    @Override
    public MWXmlField firstMappedXmlField() {
        if (this.getXmlField().isResolved()) {
            return this.getXmlField();
        }
        return null;
    }

    @Override
    public void addWrittenFieldsTo(Collection writtenXpaths) {
        if (!this.isReadOnly() && !this.getXmlField().getXpath().equals("")) {
            writtenXpaths.add(this.getXmlField());
        }
    }

    @Override
    public MWSchemaContextComponent schemaContext(MWXmlField xmlField) {
        return this.xmlDescriptor().getSchemaContext();
    }

    @Override
    public MWXpathSpec xpathSpec(MWXmlField xmlField) {
        return this.buildXpathSpec();
    }

    protected MWXpathSpec buildXpathSpec() {
        return new MWXpathSpec(){

            @Override
            public boolean mayUseCollectionData() {
                return false;
            }

            @Override
            public boolean mayUseComplexData() {
                return false;
            }

            @Override
            public boolean mayUseSimpleData() {
                return true;
            }
        };
    }

    private MWXmlDescriptor xmlDescriptor() {
        return (MWXmlDescriptor)this.getParent();
    }

    @Override
    protected void initializeFromMWXpathedMapping(MWXpathedMapping oldMapping) {
        super.initializeFromMWXpathedMapping(oldMapping);
        this.getXmlField().setXpath(oldMapping.getXmlField().getXpath());
        this.getXmlField().setTyped(oldMapping.getXmlField().isTyped());
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        this.addXpathNotSpecifiedProblemTo(newProblems);
        this.addXmlFieldNotDirectProblemTo(newProblems);
        this.addXmlFieldNotSingularProblemTo(newProblems);
        super.addProblemsTo(newProblems);
    }

    private void addXpathNotSpecifiedProblemTo(List<Problem> newProblems) {
        if (!this.getXmlField().isSpecified()) {
            newProblems.add(this.buildProblem("0810"));
        }
    }

    private void addXmlFieldNotDirectProblemTo(List<Problem> newProblems) {
        if (this.getXmlField().isValid() && !this.getXmlField().isDirect()) {
            newProblems.add(this.buildProblem("0814", this.getXmlField().getXpath()));
        }
    }

    private void addXmlFieldNotSingularProblemTo(List<Problem> newProblems) {
        if (this.getXmlField().isValid() && !this.getXmlField().isSingular()) {
            newProblems.add(this.buildProblem("0815", this.getXmlField().getXpath()));
        }
    }

    @Override
    public void resolveXpaths() {
        this.xmlField.resolveXpaths();
    }

    @Override
    public void schemaChanged(SchemaChange change) {
        this.xmlField.schemaChanged(change);
    }

    @Override
    public DatabaseMapping buildRuntimeMapping() {
        return this.xmlDescriptor().buildDefaultRuntimeDirectMapping();
    }

    @Override
    public DatabaseMapping runtimeMapping() {
        AbstractDirectMapping runtimeMapping = (AbstractDirectMapping)super.runtimeMapping();
        runtimeMapping.setField(this.getXmlField().runtimeField());
        return runtimeMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAbstractXmlDirectMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWDirectMapping.class);
        XMLCompositeObjectMapping xmlFieldMapping = new XMLCompositeObjectMapping();
        xmlFieldMapping.setReferenceClass(MWXmlField.class);
        xmlFieldMapping.setAttributeName("xmlField");
        xmlFieldMapping.setGetMethodName("getXmlFieldForTopLink");
        xmlFieldMapping.setSetMethodName("setXmlFieldForTopLink");
        xmlFieldMapping.setXPath("xml-field");
        descriptor.addMapping((DatabaseMapping)xmlFieldMapping);
        return descriptor;
    }

    private MWXmlField getXmlFieldForTopLink() {
        return this.xmlField.isSpecified() ? this.xmlField : null;
    }

    private void setXmlFieldForTopLink(MWXmlField xmlField) {
        this.xmlField = xmlField == null ? new MWXmlField(this) : xmlField;
    }
}

