/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.generation;

import java.text.Collator;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;

public class MWRelationshipHolder
implements Comparable {
    private volatile MWReference reference;
    private volatile boolean foreignKeyInTargetTable;
    private volatile String relationshipType;
    private static String ONE_TO_MANY = "oneToMany";
    private static String ONE_TO_ONE = "oneToOne";

    public MWRelationshipHolder(MWReference relationshipReference, boolean foreignKeyIsInTargetTable) {
        this.reference = relationshipReference;
        this.foreignKeyInTargetTable = foreignKeyIsInTargetTable;
    }

    public boolean canMapOneToMany() {
        return this.foreignKeyInTargetTable;
    }

    public boolean canMapOneToOne() {
        return true;
    }

    public int compareTo(Object otherObject) {
        MWRelationshipHolder otherHolder = (MWRelationshipHolder)otherObject;
        if (this.getReference().getName().equals(otherHolder.getReference().getName())) {
            return Collator.getInstance().compare(this.displayString(), otherHolder.displayString());
        }
        return Collator.getInstance().compare(this.getReference().getName(), otherHolder.getReference().getName());
    }

    public String displayString() {
        StringBuffer buffer = new StringBuffer();
        MWTable sourceTable = this.getRelationshipSourceTable();
        buffer.append(sourceTable.getShortName());
        if (this.reference.columnPairsSize() > 0) {
            buffer.append(" (");
            Iterator it = this.reference.columnPairs();
            while (it.hasNext()) {
                MWColumnPair association = (MWColumnPair)it.next();
                if (this.foreignKeyInTargetTable) {
                    if (association.getTargetColumn() != null) {
                        buffer.append(association.getTargetColumn().getName());
                    }
                } else if (association.getSourceColumn() != null) {
                    buffer.append(association.getSourceColumn().getName());
                }
                if (!it.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(")");
        }
        buffer.append(" -> ");
        MWTable targetTable = this.getRelationshipTargetTable();
        buffer.append(targetTable.getShortName());
        if (this.reference.columnPairsSize() > 0) {
            buffer.append(" (");
            Iterator it = this.reference.columnPairs();
            while (it.hasNext()) {
                MWColumnPair association = (MWColumnPair)it.next();
                if (this.foreignKeyInTargetTable) {
                    if (association.getSourceColumn() != null) {
                        buffer.append(association.getSourceColumn().getName());
                    }
                } else if (association.getTargetColumn() != null) {
                    buffer.append(association.getTargetColumn().getName());
                }
                if (!it.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected MWReference getReference() {
        return this.reference;
    }

    public MWTable getRelationshipSourceTable() {
        if (this.foreignKeyInTargetTable) {
            return this.reference.getTargetTable();
        }
        return this.reference.getSourceTable();
    }

    public MWTable getRelationshipTargetTable() {
        if (this.foreignKeyInTargetTable) {
            return this.reference.getSourceTable();
        }
        return this.reference.getTargetTable();
    }

    public boolean isForeignKeyInTargetTable() {
        return this.foreignKeyInTargetTable;
    }

    public boolean isOneToMany() {
        return this.relationshipType == ONE_TO_MANY;
    }

    public boolean isOneToOne() {
        return this.relationshipType == ONE_TO_ONE;
    }

    public void setNoRelationship() {
        this.relationshipType = null;
    }

    public void setOneToMany() {
        this.relationshipType = ONE_TO_MANY;
    }

    public void setOneToOne() {
        this.relationshipType = ONE_TO_ONE;
    }
}

