/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.uitools.cell.EditingNode;

public class NodeTreeCellEditor
extends AbstractCellEditor
implements TreeCellEditor,
CellEditorListener {
    private EditingNode currentNode;

    @Override
    public Object getCellEditorValue() {
        return this.currentNode.getEditor().getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        JTree tree = (JTree)e.getSource();
        TreePath path = null;
        if (e instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)e;
            path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        } else {
            path = tree.getSelectionPath();
        }
        if (path == null) {
            return false;
        }
        EditingNode node = (EditingNode)path.getLastPathComponent();
        return node.getEditor().isCellEditable(e);
    }

    @Override
    public boolean shouldSelectCell(EventObject e) {
        return this.currentNode.getEditor().shouldSelectCell(e);
    }

    @Override
    public boolean stopCellEditing() {
        return this.currentNode.getEditor().stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.currentNode.getEditor().cancelCellEditing();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (this.currentNode != null) {
            this.currentNode.getEditor().removeCellEditorListener(this);
        }
        this.currentNode = (EditingNode)value;
        this.currentNode.getEditor().addCellEditorListener(this);
        return this.currentNode.getEditor().getTreeCellEditorComponent(tree, this.currentNode.getCellValue(), isSelected, expanded, leaf, row);
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.fireEditingCanceled();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.fireEditingStopped();
    }
}

