/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.meta;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsProperties;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class SCSessionsPropertiesManager
extends AbstractModel {
    private final Preferences preferences;
    private Collection sessionsProperties;
    private Collection unsavedSessionsFileNames;
    public static final String UNTITLED_FILE_NAME = "sessions";

    public SCSessionsPropertiesManager(Preferences preferences) {
        this.preferences = preferences.node("classpath");
        this.read();
    }

    SCSessionsProperties addSessionsProperties(File path, String[] classpath, int index) {
        SCSessionsProperties properties = this.buildSessionsProperties(path, classpath, index);
        properties.manager = this;
        this.sessionsProperties.add(properties);
        return properties;
    }

    void addSessionsProperties(SCSessionsProperties properties) {
        if (!this.sessionsProperties.contains((Object)properties)) {
            this.sessionsProperties.add(properties);
        }
    }

    private SCSessionsProperties buildSessionsProperties(File path, String[] classpath, int index) {
        return new SCSessionsProperties(this, path, classpath, index);
    }

    public SCSessionsProperties getSessionsProperties(File path) {
        Iterator iter = this.sessionsProperties();
        while (iter.hasNext()) {
            SCSessionsProperties properties = (SCSessionsProperties)((Object)iter.next());
            if (!properties.getPath().equals(path)) continue;
            return properties;
        }
        if (path.getPath().startsWith(this.untitledFileName())) {
            this.unsavedSessionsFileNames.add(path);
        }
        return this.buildSessionsProperties(path, new String[0], -1);
    }

    protected void initialize() {
        super.initialize();
        this.sessionsProperties = new Vector();
        this.unsavedSessionsFileNames = new Vector();
    }

    public File nextUntitledSessionsFile() {
        String defaultUntitledFileName = this.untitledFileName();
        boolean firstUntitledUsed = false;
        int index = 0;
        Iterator iter = this.unsavedSessionsFileNames();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            String fileName = FileTools.stripExtension((String)file.getPath());
            if (!fileName.startsWith(defaultUntitledFileName)) continue;
            String remaining = fileName.substring(defaultUntitledFileName.length(), fileName.length());
            try {
                if (remaining.length() == 0) {
                    firstUntitledUsed = true;
                    ++index;
                    continue;
                }
                index = Math.max(new Integer(remaining), index);
            }
            catch (Exception exception) {}
        }
        StringBuffer sb = new StringBuffer(13);
        sb.append(defaultUntitledFileName);
        if (firstUntitledUsed) {
            sb.append(++index);
        }
        sb.append(".xml");
        return new File(sb.toString());
    }

    public void pathChanged(SCSessionsProperties properties) {
        SCSessionsProperties original = null;
        File path = properties.getPath();
        Iterator iter = this.sessionsProperties();
        while (iter.hasNext()) {
            SCSessionsProperties nextProperties = (SCSessionsProperties)((Object)iter.next());
            if (properties == nextProperties || !nextProperties.getPath().equals(path)) continue;
            original = nextProperties;
            break;
        }
        if (original != null) {
            this.sessionsProperties.add(properties);
            this.sessionsProperties.remove((Object)original);
        }
    }

    private void read() {
        try {
            String[] keys = this.preferences.keys();
            for (int index = 0; index < keys.length; ++index) {
                String key = keys[index];
                if (key.startsWith("location_")) {
                    int underscoreIndex = key.indexOf("_");
                    int entryIndex = Integer.valueOf(key.substring(underscoreIndex + 1));
                    String fileName = this.preferences.get(key, null);
                    String classpath = this.preferences.get("classpath_" + entryIndex, null);
                    if (fileName.length() <= 0 || StringTools.stringIsEmpty((String)classpath)) continue;
                    String[] classpathEntries = classpath.split(File.pathSeparator);
                    this.addSessionsProperties(new File(fileName), classpathEntries, entryIndex);
                    continue;
                }
                if (key.startsWith("classpath_")) continue;
                String classpath = this.preferences.get(key, null);
                if (key.length() <= 0 || StringTools.stringIsEmpty((String)classpath)) continue;
                String[] classpathEntries = classpath.split(File.pathSeparator);
                SCSessionsProperties properties = this.addSessionsProperties(new File(key), classpathEntries, -1);
                properties.save(this.preferences.parent());
                this.preferences.remove(key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Iterator sessionsProperties() {
        return this.sessionsProperties.iterator();
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        StringTools.buildSimpleToStringOn((Object)((Object)this), (StringBuffer)sb);
        sb.append(" (");
        this.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    public void toString(StringBuffer buffer) {
        buffer.append(", sessions=");
        buffer.append(this.sessionsProperties);
    }

    private Iterator unsavedSessionsFileNames() {
        return this.unsavedSessionsFileNames.iterator();
    }

    private String untitledFileName() {
        return this.preferences.parent().get("new name.sessions configuration", UNTITLED_FILE_NAME);
    }
}

