/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.ToggleFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;

public abstract class AbstractToggleFrameworkAction
extends AbstractEnablableFrameworkAction
implements ToggleFrameworkAction {
    private boolean selectionState;
    private PropertyChangeListener selectionStateListener;
    protected static final String[] DEFAULT_SELECTED_PROPERTY_NAMES = new String[0];

    protected AbstractToggleFrameworkAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.updateSelectionState();
    }

    protected void updateSelectionState() {
        ApplicationNode[] selectedNodes = this.selectedNodes();
        for (int i = 0; i < selectedNodes.length; ++i) {
            ApplicationNode selectedNode = selectedNodes[i];
            if (this.shouldBeSelected(selectedNode)) continue;
            this.setSelected(false);
            return;
        }
        this.setSelected(true);
    }

    protected abstract boolean shouldBeSelected(ApplicationNode var1);

    @Override
    public void setSelected(boolean selectionState) {
        boolean oldValue = this.selectionState;
        this.selectionState = selectionState;
        this.firePropertyChange("toggleStateProperty", oldValue, this.selectionState);
    }

    @Override
    public boolean isSelected() {
        return this.selectionState;
    }

    @Override
    protected void engageListeners(AbstractApplicationNode node) {
        super.engageListeners(node);
        this.engageValueSelected(node);
    }

    protected void engageValueSelected(AbstractApplicationNode node) {
        this.engageValue(node, this.selectedPropertyNames(), this.getSelectionStateListener());
    }

    @Override
    protected void disengageListeners(AbstractApplicationNode node) {
        super.disengageListeners(node);
        this.disengageValueSelected(node);
    }

    protected void disengageValueSelected(AbstractApplicationNode node) {
        this.disengageValue(node, this.selectedPropertyNames(), this.getSelectionStateListener());
    }

    protected PropertyChangeListener getSelectionStateListener() {
        if (this.selectionStateListener == null) {
            this.selectionStateListener = this.buildSelectionStateListener();
        }
        return this.selectionStateListener;
    }

    protected PropertyChangeListener buildSelectionStateListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractToggleFrameworkAction.this.updateSelectionState();
            }
        };
    }

    protected String[] selectedPropertyNames() {
        return DEFAULT_SELECTED_PROPERTY_NAMES;
    }
}

