/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Collection;
import java.util.Iterator;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xs.XSObject;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.iterators.ChainIterator;

public abstract class AbstractNamedSchemaComponent
extends AbstractSchemaComponent
implements MWNamedSchemaComponent {
    private volatile String name;
    private volatile String namespaceUrl;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(AbstractNamedSchemaComponent.class);
        descriptor.getInheritancePolicy().setParentClass(AbstractSchemaComponent.class);
        descriptor.addDirectMapping("name", "name/text()");
        ((XMLDirectMapping)descriptor.addDirectMapping("namespaceUrl", "namespace-url/text()")).setNullValue((Object)"");
        return descriptor;
    }

    protected AbstractNamedSchemaComponent() {
    }

    protected AbstractNamedSchemaComponent(MWModel parent, String name) {
        super(parent);
        this.name = name;
    }

    protected AbstractNamedSchemaComponent(MWModel parent, String name, String namespace) {
        this(parent, name);
        this.namespaceUrl = namespace;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.namespaceUrl = "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespaceUrl() {
        return this.namespaceUrl;
    }

    @Override
    public MWNamespace getTargetNamespace() {
        return this.getParentNamespace();
    }

    @Override
    public Iterator namedComponentChain() {
        return new ChainIterator(this){

            @Override
            protected Object nextLink(Object currentLink) {
                return ((MWNamedSchemaComponent)currentLink).parentNamedComponent();
            }
        };
    }

    @Override
    public boolean directlyOwns(MWNamedSchemaComponent nestedComponent) {
        return this.directlyOwnedComponents().contains(nestedComponent);
    }

    @Override
    public void addDirectlyOwnedComponentsTo(Collection directlyOwnedComponents) {
    }

    private Collection directlyOwnedComponents() {
        HashBag directlyOwnedComponents = new HashBag();
        this.addDirectlyOwnedComponentsTo(directlyOwnedComponents);
        return directlyOwnedComponents;
    }

    @Override
    public String qName() {
        String qName = this.getName();
        String prefix = this.getSchema().namespacePrefixForUrl(this.getNamespaceUrl());
        if (prefix != null && !prefix.equals("")) {
            qName = prefix + ":" + qName;
        }
        return qName;
    }

    @Override
    protected void reloadInternal(XSObject schemaObject) {
        super.reloadInternal(schemaObject);
        if (schemaObject instanceof XSParticleDecl) {
            XSParticleDecl xsParticle = (XSParticleDecl)schemaObject;
            this.reloadName(xsParticle.getTerm().getName(), xsParticle.getTerm().getNamespace());
        } else {
            this.reloadName(schemaObject.getName(), schemaObject.getNamespace());
        }
    }

    protected void reloadName(String name, String namespace) {
        this.name = name;
        this.namespaceUrl = namespace != null ? namespace : "";
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append("name = " + this.name);
    }
}

