/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsmodel;

import java.util.List;
import org.eclipse.persistence.tools.workbench.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.w3c.dom.Node;

public final class JDBCTypeToDatabaseTypeMapping
extends AbstractNodeModel {
    private JDBCType jdbcType;
    private DatabaseType databaseType;
    public static final String DATABASE_TYPE_PROPERTY = "databaseType";

    JDBCTypeToDatabaseTypeMapping(DatabasePlatform platform, Node node) throws CorruptXMLException {
        super(platform);
        this.read(node);
    }

    JDBCTypeToDatabaseTypeMapping(DatabasePlatform platform, JDBCType jdbcType) {
        super(platform);
        if (jdbcType == null) {
            throw new NullPointerException();
        }
        this.jdbcType = jdbcType;
    }

    private DatabasePlatform getPlatform() {
        return (DatabasePlatform)this.getParent();
    }

    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        DatabaseType old = this.databaseType;
        this.databaseType = databaseType;
        this.firePropertyChanged(DATABASE_TYPE_PROPERTY, old, databaseType);
    }

    boolean maps(JDBCType type) {
        return this.jdbcType == type;
    }

    boolean maps(int jdbcTypeCode) {
        return this.jdbcType.getCode() == jdbcTypeCode;
    }

    private JDBCType jdbcTypeNamed(String jdbcTypeName) {
        return this.getPlatform().jdbcTypeNamed(jdbcTypeName);
    }

    private DatabaseType databaseTypeNamed(String databaseTypeName) {
        return this.getPlatform().databaseTypeNamed(databaseTypeName);
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        if (this.databaseType == null) {
            currentProblems.add(this.buildProblem("002", this.getJDBCType().getName()));
        }
        super.addProblemsTo(currentProblems);
    }

    void cloneFrom(JDBCTypeToDatabaseTypeMapping originalMapping) {
        DatabaseType originalDatabaseType = originalMapping.getDatabaseType();
        if (originalDatabaseType != null) {
            this.databaseType = this.databaseTypeNamed(originalDatabaseType.getName());
        }
    }

    @Override
    public int compareTo(Object o) {
        JDBCTypeToDatabaseTypeMapping other = (JDBCTypeToDatabaseTypeMapping)o;
        return this.jdbcType.compareTo(other.jdbcType);
    }

    private void read(Node node) throws CorruptXMLException {
        try {
            this.jdbcType = this.jdbcTypeNamed(XMLTools.childTextContent(node, "jdbc-type", null));
        }
        catch (IllegalArgumentException ex) {
            throw new CorruptXMLException("platform: " + this.getPlatform().getName(), ex);
        }
        String databaseTypeName = XMLTools.childTextContent(node, "database-type", null);
        if (databaseTypeName != null) {
            try {
                this.databaseType = this.databaseTypeNamed(databaseTypeName);
            }
            catch (IllegalArgumentException ex) {
                throw new CorruptXMLException(ex);
            }
        }
    }

    void write(Node node) {
        XMLTools.addSimpleTextNode(node, "jdbc-type", this.jdbcType.getName());
        if (this.databaseType != null) {
            XMLTools.addSimpleTextNode(node, "database-type", this.databaseType.getName());
        }
    }

    private void displayStringOn(StringBuffer sb) {
        sb.append(this.jdbcType.getName());
        sb.append(" => ");
        sb.append(this.databaseType == null ? "null" : this.databaseType.getName());
    }

    @Override
    public String displayString() {
        StringBuffer sb = new StringBuffer();
        this.displayStringOn(sb);
        return sb.toString();
    }

    @Override
    public void toString(StringBuffer sb) {
        this.displayStringOn(sb);
    }
}

