/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOption;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisReadObjectQuery;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWAbstractQuery
extends MWModel
implements MWQuery {
    private volatile String name;
    private List parameters;
    private volatile boolean cacheQueryResults;
    private volatile boolean outerJoinAllSubclasses;
    private volatile int maximumRows;
    private volatile int firstResult;
    private volatile Integer queryTimeout;
    private volatile boolean exclusiveConnection;
    private volatile LockingModel lockMode;
    private static TopLinkOptionSet lockingOptions;
    private volatile DistinctStateModel distinctState;
    private static TopLinkOptionSet distinctStateOptions;

    public static synchronized TopLinkOptionSet lockingOptions() {
        if (lockingOptions == null) {
            ArrayList<LockingModel> list = new ArrayList<LockingModel>();
            list.add(new LockingModel("Use Descriptor Setting", "USE_DESCRIPTOR_SETTING_OPTION", -1));
            list.add(new LockingModel("Acquire Locks", "ACQUIRE_LOCKS_OPTION", 1));
            list.add(new LockingModel("Acquire Locks NO WAIT", "ACQUIRE_LOCKS_NO_WAIT_OPTION", 2));
            list.add(new LockingModel("Do Not Acquire Locks", "DONT_ACQUIRE_LOCKS_OPTION", 0));
            lockingOptions = new TopLinkOptionSet(list);
        }
        return lockingOptions;
    }

    public static synchronized TopLinkOptionSet distinctStateOptions() {
        if (distinctStateOptions == null) {
            ArrayList<DistinctStateModel> list = new ArrayList<DistinctStateModel>();
            list.add(new DistinctStateModel("Uncomputed Distinct", "UNCOMPUTED_DISTINCT_OPTION", 0));
            list.add(new DistinctStateModel("Use Distinct", "USE_DISTINCT_OPTION", 1));
            list.add(new DistinctStateModel("Do Not Use Distinct", "DO_NOT_USE_DISTINCT_OPTION", 2));
            distinctStateOptions = new TopLinkOptionSet(list);
        }
        return distinctStateOptions;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAbstractQuery.class);
        InheritancePolicy ip = descriptor.getInheritancePolicy();
        ip.setClassIndicatorFieldName("@type");
        ip.addClassIndicator(MWRelationalReadAllQuery.class, (Object)"relational-read-all");
        ip.addClassIndicator(MWRelationalReadObjectQuery.class, (Object)"relational-read-object");
        ip.addClassIndicator(MWEisReadAllQuery.class, (Object)"eis-read-all");
        ip.addClassIndicator(MWEisReadObjectQuery.class, (Object)"eis-read-object");
        ip.addClassIndicator(MWReportQuery.class, (Object)"report");
        descriptor.addDirectMapping("name", "name/text()");
        XMLCompositeCollectionMapping parameterListMapping = new XMLCompositeCollectionMapping();
        parameterListMapping.setAttributeName("parameters");
        parameterListMapping.setReferenceClass(MWQueryParameter.class);
        parameterListMapping.setXPath("parameter-list/query-parameter");
        descriptor.addMapping((DatabaseMapping)parameterListMapping);
        XMLDirectMapping cacheQueryResultsMapping = new XMLDirectMapping();
        cacheQueryResultsMapping.setAttributeName("cacheQueryResults");
        cacheQueryResultsMapping.setXPath("cache-query-results/text()");
        cacheQueryResultsMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addMapping((DatabaseMapping)cacheQueryResultsMapping);
        XMLDirectMapping outerJoinAllSubclassesMapping = new XMLDirectMapping();
        outerJoinAllSubclassesMapping.setAttributeName("outerJoinAllSubclasses");
        outerJoinAllSubclassesMapping.setXPath("outer-join-all-subclasses/text()");
        outerJoinAllSubclassesMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addMapping((DatabaseMapping)outerJoinAllSubclassesMapping);
        XMLDirectMapping exclusiveConnectionMapping = new XMLDirectMapping();
        exclusiveConnectionMapping.setAttributeName("exclusiveConnection");
        exclusiveConnectionMapping.setXPath("exclusive-connection/text()");
        exclusiveConnectionMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addMapping((DatabaseMapping)exclusiveConnectionMapping);
        XMLDirectMapping queryTimeoutMapping = new XMLDirectMapping();
        queryTimeoutMapping.setAttributeName("queryTimeout");
        queryTimeoutMapping.setXPath("query-timeout/text()");
        queryTimeoutMapping.setGetMethodName("getQueryTimeoutForTopLink");
        queryTimeoutMapping.setSetMethodName("setQueryTimeoutForTopLink");
        queryTimeoutMapping.setNullValue((Object)QUERY_TIMEOUT_UNDEFINED);
        descriptor.addMapping((DatabaseMapping)queryTimeoutMapping);
        XMLDirectMapping maximumRowsMapping = new XMLDirectMapping();
        maximumRowsMapping.setAttributeName("maximumRows");
        maximumRowsMapping.setXPath("maximum-rows/text()");
        maximumRowsMapping.setNullValue((Object)new Integer(0));
        descriptor.addMapping((DatabaseMapping)maximumRowsMapping);
        XMLDirectMapping firstResultMapping = new XMLDirectMapping();
        firstResultMapping.setAttributeName("firstResult");
        firstResultMapping.setXPath("first-result/text()");
        firstResultMapping.setNullValue((Object)new Integer(0));
        descriptor.addMapping((DatabaseMapping)firstResultMapping);
        XMLDirectMapping lockingMapping = new XMLDirectMapping();
        lockingMapping.setAttributeName("lockMode");
        lockingMapping.setXPath("lock-mode/text()");
        ObjectTypeConverter lockingConverter = new ObjectTypeConverter();
        MWAbstractQuery.lockingOptions().addConversionValuesForTopLinkTo(lockingConverter);
        lockingMapping.setConverter((Converter)lockingConverter);
        lockingMapping.setNullValue((Object)MWAbstractQuery.lockingOptions().topLinkOptionForMWModelOption("Use Descriptor Setting"));
        descriptor.addMapping((DatabaseMapping)lockingMapping);
        XMLDirectMapping distinctStateMapping = new XMLDirectMapping();
        distinctStateMapping.setAttributeName("distinctState");
        distinctStateMapping.setXPath("distinct-state/text()");
        ObjectTypeConverter distinctStateConverter = new ObjectTypeConverter();
        MWAbstractQuery.distinctStateOptions().addConversionValuesForTopLinkTo(distinctStateConverter);
        distinctStateMapping.setConverter((Converter)distinctStateConverter);
        distinctStateMapping.setNullValue((Object)MWAbstractQuery.distinctStateOptions().topLinkOptionForMWModelOption("Uncomputed Distinct"));
        descriptor.addMapping((DatabaseMapping)distinctStateMapping);
        return descriptor;
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor descriptor = MWModel.legacy60BuildStandardDescriptor();
        descriptor.setJavaClass(MWAbstractQuery.class);
        InheritancePolicy ip = descriptor.getInheritancePolicy();
        ip.setClassIndicatorFieldName("@type");
        ip.addClassIndicator(MWRelationalReadAllQuery.class, (Object)"relational-read-all");
        ip.addClassIndicator(MWRelationalReadObjectQuery.class, (Object)"relational-read-object");
        ip.addClassIndicator(MWEisReadAllQuery.class, (Object)"eis-read-all");
        ip.addClassIndicator(MWEisReadObjectQuery.class, (Object)"eis-read-object");
        ip.addClassIndicator(MWReportQuery.class, (Object)"report");
        descriptor.addDirectMapping("name", "name/text()");
        XMLCompositeCollectionMapping parameterListMapping = new XMLCompositeCollectionMapping();
        parameterListMapping.setAttributeName("parameters");
        parameterListMapping.setReferenceClass(MWQueryParameter.class);
        parameterListMapping.setXPath("parameter-list/query-parameter");
        descriptor.addMapping((DatabaseMapping)parameterListMapping);
        XMLDirectMapping cacheQueryResultsMapping = new XMLDirectMapping();
        cacheQueryResultsMapping.setAttributeName("cacheQueryResults");
        cacheQueryResultsMapping.setXPath("cache-query-results/text()");
        cacheQueryResultsMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addMapping((DatabaseMapping)cacheQueryResultsMapping);
        XMLDirectMapping exclusiveConnectionMapping = new XMLDirectMapping();
        exclusiveConnectionMapping.setAttributeName("exclusiveConnection");
        exclusiveConnectionMapping.setXPath("exclusive-connection/text()");
        exclusiveConnectionMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addMapping((DatabaseMapping)exclusiveConnectionMapping);
        XMLDirectMapping queryTimeoutMapping = new XMLDirectMapping();
        queryTimeoutMapping.setAttributeName("queryTimeout");
        queryTimeoutMapping.setXPath("query-timeout/text()");
        queryTimeoutMapping.setGetMethodName("getQueryTimeoutForTopLink");
        queryTimeoutMapping.setSetMethodName("setQueryTimeoutForTopLink");
        queryTimeoutMapping.setNullValue((Object)QUERY_TIMEOUT_UNDEFINED);
        descriptor.addMapping((DatabaseMapping)queryTimeoutMapping);
        XMLDirectMapping maximumRowsMapping = new XMLDirectMapping();
        maximumRowsMapping.setAttributeName("maximumRows");
        maximumRowsMapping.setXPath("maximum-rows/text()");
        maximumRowsMapping.setNullValue((Object)new Integer(0));
        descriptor.addMapping((DatabaseMapping)maximumRowsMapping);
        XMLDirectMapping lockingMapping = new XMLDirectMapping();
        lockingMapping.setAttributeName("lockMode");
        lockingMapping.setXPath("lock-mode/text()");
        ObjectTypeConverter lockingConverter = new ObjectTypeConverter();
        MWAbstractQuery.lockingOptions().addConversionValuesForTopLinkTo(lockingConverter);
        lockingMapping.setConverter((Converter)lockingConverter);
        lockingMapping.setNullValue((Object)MWAbstractQuery.lockingOptions().topLinkOptionForMWModelOption("Use Descriptor Setting"));
        descriptor.addMapping((DatabaseMapping)lockingMapping);
        XMLDirectMapping distinctStateMapping = new XMLDirectMapping();
        distinctStateMapping.setAttributeName("distinctState");
        distinctStateMapping.setXPath("distinct-state/text()");
        ObjectTypeConverter distinctStateConverter = new ObjectTypeConverter();
        MWAbstractQuery.distinctStateOptions().addConversionValuesForTopLinkTo(distinctStateConverter);
        distinctStateMapping.setConverter((Converter)distinctStateConverter);
        distinctStateMapping.setNullValue((Object)MWAbstractQuery.distinctStateOptions().topLinkOptionForMWModelOption("Uncomputed Distinct"));
        descriptor.addMapping((DatabaseMapping)distinctStateMapping);
        return descriptor;
    }

    protected MWAbstractQuery() {
    }

    protected MWAbstractQuery(MWQueryManager queryManager, String name) {
        super(queryManager);
        this.initialize(name);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.parameters = new Vector();
        this.cacheQueryResults = false;
        this.outerJoinAllSubclasses = false;
        this.maximumRows = 0;
        this.firstResult = 0;
        this.queryTimeout = QUERY_TIMEOUT_UNDEFINED;
        this.exclusiveConnection = false;
        this.lockMode = (LockingModel)MWAbstractQuery.lockingOptions().topLinkOptionForMWModelOption("Use Descriptor Setting");
        this.distinctState = (DistinctStateModel)MWAbstractQuery.distinctStateOptions().topLinkOptionForMWModelOption("Uncomputed Distinct");
    }

    protected void initialize(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        List list = this.parameters;
        synchronized (list) {
            children.addAll(this.parameters);
        }
    }

    @Override
    public MWMappingDescriptor getOwningDescriptor() {
        return ((MWQueryManager)this.getParent()).getOwningDescriptor();
    }

    @Override
    public String signature() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getName());
        sb.append('(');
        ListIterator stream = this.parameters();
        while (stream.hasNext()) {
            sb.append(((MWQueryParameter)stream.next()).getType().getName());
            if (!stream.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void signatureChanged() {
        this.getProject().nodeRenamed(this);
        this.firePropertyChanged("signature", this.signature());
    }

    @Override
    public Iterator queryTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("READ_ALL_QUERY");
        list.add("READ_OBJECT_QUERY");
        list.add("REPORT_QUERY");
        return list.iterator();
    }

    @Override
    public MWReadAllQuery asReadAllQuery() {
        this.getQueryManager().removeQuery(this);
        MWReadAllQuery newQuery = this.getQueryManager().addReadAllQuery(this.getName());
        ((MWAbstractQuery)((Object)newQuery)).initializeFrom(this);
        return newQuery;
    }

    @Override
    public MWReadObjectQuery asReadObjectQuery() {
        this.getQueryManager().removeQuery(this);
        MWReadObjectQuery newQuery = this.getQueryManager().addReadObjectQuery(this.getName());
        ((MWAbstractQuery)((Object)newQuery)).initializeFrom(this);
        return newQuery;
    }

    public void initializeFrom(MWQuery query) {
        this.setCacheQueryResults(query.isCacheQueryResults());
        this.setExclusiveConnection(query.isExclusiveConnection());
        this.setOuterJoinAllSubclasses(query.isOuterJoinAllSubclasses());
        this.setMaximumRows(query.getMaximumRows());
        this.setFirstResult(query.getFirstResult());
        this.setQueryTimeout(query.getQueryTimeout());
        ListIterator i = query.parameters();
        while (i.hasNext()) {
            MWQueryParameter parameter = (MWQueryParameter)i.next();
            if (this.getParameterNamed(parameter.getName()) != null) {
                this.removeParameter(this.getParameterNamed(parameter.getName()));
            }
            this.addParameter(parameter.getType(), parameter.getName());
        }
        this.setDistinctState(query.getDistinctState());
        this.setLocking(query.getLocking());
    }

    public void initializeFrom(MWReadQuery query) {
        this.initializeFrom((MWQuery)query);
    }

    public void initializeFrom(MWReadAllQuery query) {
        this.initializeFrom((MWReadQuery)query);
    }

    public void initializeFrom(MWRelationalQuery query) {
        this.initializeFrom((MWQuery)((Object)query));
    }

    public void initializeFrom(MWReportQuery query) {
        this.initializeFrom((MWRelationalQuery)query);
    }

    public MWQueryManager getQueryManager() {
        return (MWQueryManager)this.getParent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
        if (this.attributeValueHasChanged(old, name)) {
            this.getProject().nodeRenamed(this);
        }
    }

    @Override
    public MWQueryParameter addParameter(MWClass type) {
        return this.addParameter(type, NameTools.uniqueNameFor("arg", this.parameterNames()));
    }

    public MWQueryParameter addParameter(MWClass type, String name) {
        MWQueryParameter parameter = new MWQueryParameter(this, name, type);
        this.addParameter(parameter);
        this.signatureChanged();
        return parameter;
    }

    private void addParameter(MWQueryParameter parameter) {
        this.addParameter(this.parametersSize(), parameter);
    }

    private void addParameter(int index, MWQueryParameter parameter) {
        this.parameters.add(index, parameter);
        this.fireItemAdded("parameters", index, parameter);
    }

    @Override
    public void removeParameter(MWQueryParameter parameter) {
        this.removeNodeFromList(this.parameters.indexOf(parameter), this.parameters, "parameters");
        this.signatureChanged();
    }

    public void removeParameters(Iterator params) {
        while (params.hasNext()) {
            this.removeParameter((MWQueryParameter)params.next());
        }
    }

    public void removParameters(Collection params) {
        this.removeParameters(params.iterator());
    }

    @Override
    public ListIterator parameters() {
        return new CloneListIterator(this.parameters);
    }

    @Override
    public int parametersSize() {
        return this.parameters.size();
    }

    @Override
    public int getParameterIndex(MWQueryParameter parameter) {
        return this.parameters.indexOf(parameter);
    }

    @Override
    public MWQueryParameter getParameter(int index) {
        return (MWQueryParameter)this.parameters.get(index);
    }

    @Override
    public MWQueryParameter getParameterNamed(String name) {
        for (MWQueryParameter queryParameter : this.parameters) {
            if (!queryParameter.getName().equals(name)) continue;
            return queryParameter;
        }
        return null;
    }

    @Override
    public Iterator parameterNames() {
        return new TransformationListIterator(this.parameters()){

            @Override
            protected Object transform(Object next) {
                return ((MWQueryParameter)next).getName();
            }
        };
    }

    public void moveParameterUp(MWQueryParameter parameter) {
        int index = this.getParameterIndex(parameter);
        this.removeParameter(parameter);
        this.addParameter(index - 1, parameter);
    }

    public void moveParameterDown(MWQueryParameter parameter) {
        int index = this.getParameterIndex(parameter);
        this.removeParameter(parameter);
        this.addParameter(index + 1, parameter);
    }

    @Override
    public int getMaximumRows() {
        return this.maximumRows;
    }

    @Override
    public void setMaximumRows(int maximumRows) {
        int old = this.maximumRows;
        this.maximumRows = maximumRows;
        this.firePropertyChanged("maximumRows", old, this.maximumRows);
    }

    @Override
    public int getFirstResult() {
        return this.firstResult;
    }

    @Override
    public void setFirstResult(int firstResult) {
        int old = this.firstResult;
        this.firstResult = firstResult;
        this.firePropertyChanged("firstResult", old, this.firstResult);
    }

    @Override
    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(Integer queryTimeout) {
        Integer oldQueryTimeout = this.getQueryTimeout();
        this.queryTimeout = queryTimeout;
        this.firePropertyChanged("queryTimeout", oldQueryTimeout, queryTimeout);
    }

    @Override
    public boolean isExclusiveConnection() {
        return this.exclusiveConnection;
    }

    @Override
    public void setExclusiveConnection(boolean exclusiveConnection) {
        boolean old = this.exclusiveConnection;
        this.exclusiveConnection = exclusiveConnection;
        this.firePropertyChanged("exclusiveConnection", old, this.exclusiveConnection);
    }

    @Override
    public boolean isCacheQueryResults() {
        return this.cacheQueryResults;
    }

    @Override
    public void setCacheQueryResults(boolean cacheQueryResults) {
        boolean old = this.isCacheQueryResults();
        this.cacheQueryResults = cacheQueryResults;
        this.firePropertyChanged("cacheQueryResults", old, cacheQueryResults);
    }

    @Override
    public boolean isOuterJoinAllSubclasses() {
        return this.outerJoinAllSubclasses;
    }

    @Override
    public void setOuterJoinAllSubclasses(boolean outerJoinAllSubclasses) {
        boolean old = this.isOuterJoinAllSubclasses();
        this.outerJoinAllSubclasses = outerJoinAllSubclasses;
        this.firePropertyChanged("outerJoinAllSubclasses", old, outerJoinAllSubclasses);
    }

    @Override
    public DistinctStateModel getDistinctState() {
        return this.distinctState;
    }

    @Override
    public void setDistinctState(DistinctStateModel model) {
        DistinctStateModel old = this.distinctState;
        this.distinctState = model;
        this.firePropertyChanged("distinctState", old, this.distinctState);
    }

    public void setDistinctState(String distinctState) {
        this.setDistinctState((DistinctStateModel)distinctStateOptions.topLinkOptionForMWModelOption(distinctState));
    }

    private void setDistinctStateFrom(ObjectLevelReadQuery runtimeQuery) {
        this.setDistinctState(this.distinctStateModelFromTopLinkModelOption(runtimeQuery.getDistinctState()));
    }

    private DistinctStateModel distinctStateModelFromTopLinkModelOption(short topLinkDistinctState) {
        ListIterator i = MWAbstractQuery.distinctStateOptions().toplinkOptions();
        while (i.hasNext()) {
            DistinctStateModel model = (DistinctStateModel)i.next();
            if ((Short)model.getTopLinkModelOption() != topLinkDistinctState) continue;
            return model;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public LockingModel getLocking() {
        return this.lockMode;
    }

    @Override
    public void setLocking(LockingModel model) {
        LockingModel oldLocking = this.lockMode;
        this.lockMode = model;
        this.firePropertyChanged("lockMode", oldLocking, this.lockMode);
    }

    public void setLocking(String locking) {
        this.setLocking((LockingModel)MWAbstractQuery.lockingOptions().topLinkOptionForMWModelOption(locking));
    }

    private void setLockingFrom(ObjectLevelReadQuery runtimeQuery) {
        this.setLocking(this.lockingModelFromTopLinkModelOption(runtimeQuery.getLockMode()));
    }

    private LockingModel lockingModelFromTopLinkModelOption(short topLinkLocking) {
        ListIterator i = MWAbstractQuery.lockingOptions().toplinkOptions();
        while (i.hasNext()) {
            LockingModel model = (LockingModel)i.next();
            if ((Short)model.getTopLinkModelOption() != topLinkLocking) continue;
            return model;
        }
        throw new IllegalArgumentException();
    }

    public boolean isTopLinkReservedFinder() {
        return MWQueryManager.topLinkReservedFinderNames().contains(this.getName());
    }

    @Override
    public String displayString() {
        return this.signature();
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.signature());
    }

    @Override
    public DatabaseQuery runtimeQuery() {
        ObjectLevelReadQuery runtimeQuery = this.buildRuntimeQuery();
        runtimeQuery.setName(this.getName());
        ListIterator i = this.parameters();
        while (i.hasNext()) {
            ((MWQueryParameter)i.next()).convertToRuntime(runtimeQuery);
        }
        if (this.isCacheQueryResults()) {
            runtimeQuery.setQueryResultsCachePolicy(new QueryResultsCachePolicy());
        }
        runtimeQuery.setShouldOuterJoinSubclasses(this.isOuterJoinAllSubclasses());
        runtimeQuery.setShouldUseExclusiveConnection(this.isExclusiveConnection());
        if (this.getMaximumRows() > 0) {
            runtimeQuery.setMaxRows(this.getMaximumRows());
        }
        if (this.getFirstResult() > 0) {
            runtimeQuery.setFirstResult(this.getFirstResult());
        }
        if (this.getQueryTimeout() != MWQuery.QUERY_TIMEOUT_UNDEFINED) {
            runtimeQuery.setQueryTimeout(this.getQueryTimeout().intValue());
        }
        this.getLocking().setMWOptionOnTopLinkObject(runtimeQuery);
        this.getDistinctState().setMWOptionOnTopLinkObject(runtimeQuery);
        return runtimeQuery;
    }

    protected abstract ObjectLevelReadQuery buildRuntimeQuery();

    @Override
    public void adjustFromRuntime(ObjectLevelReadQuery runtimeQuery) {
        this.parameters = new Vector();
        Iterator argIt = runtimeQuery.getArguments().iterator();
        Iterator argTypeIt = runtimeQuery.getArgumentTypes().iterator();
        while (argIt.hasNext() && argTypeIt.hasNext()) {
            String paramName = (String)argIt.next();
            MWClass paramType = this.typeNamed(((Class)argTypeIt.next()).getName());
            this.addParameter(new MWQueryParameter(this, paramName, paramType));
        }
        this.setCacheQueryResults(runtimeQuery.shouldCacheQueryResults());
        this.setMaximumRows(runtimeQuery.getMaxRows());
        this.setFirstResult(runtimeQuery.getFirstResult());
        if (runtimeQuery.getQueryTimeout() == -1) {
            this.setQueryTimeout(QUERY_TIMEOUT_UNDEFINED);
        } else if (runtimeQuery.getQueryTimeout() == 0) {
            this.setQueryTimeout(QUERY_TIMEOUT_NO_TIMEOUT);
        } else {
            this.setQueryTimeout(new Integer(runtimeQuery.getQueryTimeout()));
        }
        this.setLockingFrom(runtimeQuery);
        this.setExclusiveConnection(runtimeQuery.shouldUseExclusiveConnection());
        this.setDistinctStateFrom(runtimeQuery);
    }

    private Integer getQueryTimeoutForTopLink() {
        return this.queryTimeout;
    }

    private void setQueryTimeoutForTopLink(Integer queryTimeout) {
        this.queryTimeout = queryTimeout.equals(QUERY_TIMEOUT_NO_TIMEOUT) ? QUERY_TIMEOUT_NO_TIMEOUT : (queryTimeout.equals(QUERY_TIMEOUT_UNDEFINED) ? QUERY_TIMEOUT_UNDEFINED : queryTimeout);
    }

    public static class DistinctStateModel
    extends TopLinkOption {
        public DistinctStateModel(String mwModelString, String externalString, short topLinkModelOption) {
            super(mwModelString, externalString, new Short(topLinkModelOption));
        }

        @Override
        public void setMWOptionOnTopLinkObject(Object query) {
            ((ObjectLevelReadQuery)query).setDistinctState(((Short)this.getTopLinkModelOption()).shortValue());
        }
    }

    public static class LockingModel
    extends TopLinkOption {
        public LockingModel(String mwModelString, String externalString, short topLinkModelOption) {
            super(mwModelString, externalString, new Short(topLinkModelOption));
        }

        @Override
        public void setMWOptionOnTopLinkObject(Object query) {
            ((ObjectLevelReadQuery)query).setLockMode(((Short)this.getTopLinkModelOption()).shortValue());
        }
    }
}

