/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchemaRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWXmlProject
extends MWProject
implements MWXmlNode {
    private MWXmlSchemaRepository schemaRepository;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWXmlProject.class);
        descriptor.getInheritancePolicy().setParentClass(MWProject.class);
        XMLCompositeObjectMapping schemaRepositoryMapping = new XMLCompositeObjectMapping();
        schemaRepositoryMapping.setAttributeName("schemaRepository");
        schemaRepositoryMapping.setReferenceClass(MWXmlSchemaRepository.class);
        schemaRepositoryMapping.setXPath("xml-schema-repository");
        descriptor.addMapping((DatabaseMapping)schemaRepositoryMapping);
        return descriptor;
    }

    protected MWXmlProject() {
    }

    protected MWXmlProject(String name, SPIManager spiManager) {
        super(name, spiManager);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.schemaRepository = new MWXmlSchemaRepository(this);
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.schemaRepository);
    }

    public MWXmlSchemaRepository getSchemaRepository() {
        return this.schemaRepository;
    }

    @Override
    public MWModel getMetaDataRepository() {
        return this.getSchemaRepository();
    }

    public MWXmlSchema schemaNamed(String schemaName) {
        return this.getSchemaRepository().getSchema(schemaName);
    }

    @Override
    public boolean canAutomapDescriptors() {
        return false;
    }

    @Override
    public void resolveXpaths() {
        Iterator stream = this.mappingDescriptors();
        while (stream.hasNext()) {
            ((MWXmlNode)stream.next()).resolveXpaths();
        }
    }

    @Override
    public void schemaChanged(SchemaChange change) {
        Iterator stream = this.mappingDescriptors();
        while (stream.hasNext()) {
            ((MWXmlNode)stream.next()).schemaChanged(change);
        }
    }

    @Override
    protected void resolveInternalReferences() {
        Iterator stream = this.schemaRepository.schemas();
        while (stream.hasNext()) {
            ((MWXmlSchema)stream.next()).resolveReferences();
        }
        super.resolveInternalReferences();
    }
}

