/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalPrimaryKeyPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

final class TableDescriptorPrimaryKeysPanel
extends AbstractPanel {
    private ValueModel relationalDescriptorHolder;

    TableDescriptorPrimaryKeysPanel(ValueModel relationalDescriptorHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.relationalDescriptorHolder = relationalDescriptorHolder;
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("PRIMARY_KEYS_PANEL.TITLE"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints constraints = new GridBagConstraints();
        AddRemoveListPanel pane = this.buildPrimaryKeysList();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)pane, constraints);
        this.addPaneForAlignment(pane);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private AddRemoveListPanel buildPrimaryKeysList() {
        AddRemoveListPanel listPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildPrimaryKeysAddRemoveAdapter(), this.buildSortedPrimaryKeysHolder(), 3, "PRIMARY_KEYS_PANEL.TITLE", RelationalMappingComponentFactory.buildColumnNodeSelector(this.getWorkbenchContextHolder())){

            @Override
            protected String addButtonKey() {
                return "PRIMARY_KEYS_PANEL_ADD_BUTTON";
            }

            @Override
            protected String removeButtonKey() {
                return "PRIMARY_KEYS_PANEL_REMOVE_BUTTON";
            }
        };
        listPanel.setBorder(SwingComponentFactory.buildStandardEmptyBorder());
        listPanel.setCellRenderer(this.buildPrimaryKeysListCellRenderer());
        return listPanel;
    }

    private AddRemovePanel.Adapter buildPrimaryKeysAddRemoveAdapter() {
        return new AddRemovePanel.Adapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                listSelectionModel.setSelectedValues(TableDescriptorPrimaryKeysPanel.this.addPrimaryKeys());
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                TableDescriptorPrimaryKeysPanel.this.removePrimaryKeys(listSelectionModel.getSelectedValues());
            }
        };
    }

    private Object[] addPrimaryKeys() {
        Object[] primaryKeys = new PrimaryKeyDialog(this.getWorkbenchContext()).promptForPrimaryKeys();
        for (int i = 0; i < primaryKeys.length; ++i) {
            this.relationalDescriptor().primaryKeyPolicy().addPrimaryKey((MWColumn)primaryKeys[i]);
        }
        return primaryKeys;
    }

    private void removePrimaryKeys(Object[] primaryKeys) {
        for (int i = 0; i < primaryKeys.length; ++i) {
            this.relationalDescriptor().primaryKeyPolicy().removePrimaryKey((MWColumn)primaryKeys[i]);
        }
    }

    private ListValueModel buildSortedPrimaryKeysHolder() {
        return new SortedListValueModelAdapter(this.buildNamedPrimaryKeysHolder());
    }

    private ListValueModel buildNamedPrimaryKeysHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildPrimaryKeysHolder(), "qualifiedName");
    }

    private CollectionValueModel buildPrimaryKeysHolder() {
        return new CollectionAspectAdapter(this.buildPrimaryKeyPolicyHolder(), "primaryKeys"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWRelationalPrimaryKeyPolicy)this.subject).primaryKeys();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWRelationalPrimaryKeyPolicy)this.subject).primaryKeysSize();
            }
        };
    }

    private ValueModel buildPrimaryKeyPolicyHolder() {
        return new PropertyAspectAdapter(this.relationalDescriptorHolder){

            @Override
            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).primaryKeyPolicy();
            }
        };
    }

    private ListCellRenderer buildPrimaryKeysListCellRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return ((MWColumn)value).displayString();
            }
        };
    }

    private MWTableDescriptor relationalDescriptor() {
        return (MWTableDescriptor)this.relationalDescriptorHolder.getValue();
    }

    public String helpTopicId() {
        return "descriptor.descriptorInfo.primaryKeys";
    }

    private class PrimaryKeyDialog
    extends AbstractDialog {
        private ListModel primaryKeysModel;
        private ObjectListSelectionModel primaryKeysSelectionModel;

        private PrimaryKeyDialog(WorkbenchContext context) {
            super(context);
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.primaryKeysModel = this.buildPrimaryKeyListAdapter();
            this.primaryKeysSelectionModel = this.buildPrimaryKeysSelectionModel();
            this.setTitle(TableDescriptorPrimaryKeysPanel.this.resourceRepository().getString("PRIMARY_KEYS_DIALOG.TITLE"));
            this.getOKAction().setEnabled(false);
        }

        private ListModel buildPrimaryKeyListAdapter() {
            return new ListModelAdapter(this.buildSortedPrimaryKeysHolder());
        }

        private ListValueModel buildSortedPrimaryKeysHolder() {
            return new SortedListValueModelAdapter(this.buildPrimaryKeysHolder());
        }

        private CollectionValueModel buildPrimaryKeysHolder() {
            return new CollectionAspectAdapter(TableDescriptorPrimaryKeysPanel.this.relationalDescriptorHolder){

                @Override
                protected Iterator getValueFromSubject() {
                    return ((MWTableDescriptor)this.subject).primaryKeyChoices();
                }
            };
        }

        private ObjectListSelectionModel buildPrimaryKeysSelectionModel() {
            ObjectListSelectionModel selectionModel = new ObjectListSelectionModel(this.primaryKeysModel);
            selectionModel.addListSelectionListener(this.buildSelectionListener());
            return selectionModel;
        }

        private ListSelectionListener buildSelectionListener() {
            return new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        PrimaryKeyDialog.this.selectionChanged();
                    }
                }
            };
        }

        private void selectionChanged() {
            this.getOKAction().setEnabled(!this.primaryKeysSelectionModel.isSelectionEmpty());
        }

        @Override
        protected Component buildMainPanel() {
            JList list = SwingComponentFactory.buildList(this.primaryKeysModel);
            list.setSelectionModel(this.primaryKeysSelectionModel);
            list.setSelectionMode(2);
            list.setCellRenderer(this.buildListCellRenderer());
            list.addMouseListener(this.buildListMouseListener());
            return new JScrollPane(list);
        }

        private ListCellRenderer buildListCellRenderer() {
            return new SimpleListCellRenderer(){

                @Override
                protected String buildText(Object value) {
                    return ((MWColumn)value).getName();
                }
            };
        }

        protected MouseListener buildListMouseListener() {
            return new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        PrimaryKeyDialog.this.clickOK();
                    }
                }
            };
        }

        @Override
        protected String helpTopicId() {
            return TableDescriptorPrimaryKeysPanel.this.helpTopicId();
        }

        private Object[] promptForPrimaryKeys() {
            this.show();
            if (this.wasConfirmed()) {
                return this.primaryKeysSelectionModel.getSelectedValues();
            }
            return new Object[0];
        }
    }
}

