/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.transactionisolation;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class TransactionIsolationBatchReadingTest
extends AutoVerifyTestCase {
    UnitOfWork unitOfWork;

    protected void setup() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
    }

    public void reset() throws Exception {
        if (this.unitOfWork != null) {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.unitOfWork.release();
            this.unitOfWork = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.addBatchReadAttribute("address");
        Expression maleExp = new ExpressionBuilder().get("gender").equal((Object)"Male");
        Expression femaleExp = new ExpressionBuilder().get("gender").equal((Object)"Female");
        query.setSelectionCriteria(maleExp);
        Vector males = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        Employee originalMale = (Employee)males.elementAt(0);
        Employee male = (Employee)this.unitOfWork.registerObject((Object)originalMale);
        this.unitOfWork.beginEarlyTransaction();
        query.setSelectionCriteria(femaleExp);
        Vector females = (Vector)this.unitOfWork.executeQuery((DatabaseQuery)query);
        Employee female = (Employee)females.elementAt(0);
        Address maleAddress = male.getAddress();
        Address femaleAddress = female.getAddress();
        this.strongAssert(maleAddress != null, "The batch read attribute [male.address] was null");
        this.strongAssert(femaleAddress != null, "The batch read attribute [female.address] was null");
        this.strongAssert(male.address.isInstantiated(), "The wrapped valueholder should be instantiated, because it was read on the session and is safe to trigger.");
        this.strongAssert(((UnitOfWorkImpl)this.unitOfWork).getBatchQueries() != null, "unitOfWork.getBatchReadObjects() must never return null");
        this.strongAssert(((UnitOfWorkImpl)this.unitOfWork).getBatchQueries().size() == 2, "unitOfWork batchReadObjects should only be storing the female addresses");
        if (!((UnitOfWorkImpl)this.unitOfWork).getBatchQueries().isEmpty()) {
            DatabaseQuery batchQuery = (DatabaseQuery)((UnitOfWorkImpl)this.unitOfWork).getBatchQueries().keySet().iterator().next();
            this.strongAssert(batchQuery.getBatchObjects() == null, "triggering batch query on UOW should not store batched objects on the query.");
        }
        this.strongAssert(originalMale.getAddress() != maleAddress, "Triggering a valueholder on session is returning a clone from the UnitOfWork batched objects.");
        Employee otherFemale = (Employee)females.elementAt(1);
        QueryCatcher queryCatcher = new QueryCatcher();
        this.unitOfWork.getEventManager().addListener((SessionEventListener)queryCatcher);
        try {
            otherFemale.getAddress();
        }
        finally {
            this.unitOfWork.getEventManager().removeListener((SessionEventListener)queryCatcher);
        }
    }

    public class QueryCatcher
    extends SessionEventAdapter {
        public void preExecuteQuery(SessionEvent event) {
            throw new TestErrorException("Triggering a second batch valueholder of the same batch query is going to the database.  Query: " + event.getQuery());
        }
    }
}

