/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableCacheSyncDistributedTest;

public class DeleteObjectNotSentTest
extends ConfigurableCacheSyncDistributedTest {
    protected Employee employee = null;
    protected Address address = null;
    protected Expression expression = null;

    public DeleteObjectNotSentTest() {
        this.cacheSyncConfigValues.put(Employee.class, new Integer(4));
    }

    @Override
    public void setup() {
        super.setup();
        this.employee = new Employee();
        this.employee.setFirstName("Dean");
        this.employee.setLastName("Keaton");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)this.employee);
        uow.commit();
        ExpressionBuilder employees = new ExpressionBuilder();
        this.expression = employees.get("firstName").equal((Object)"Dean");
        this.expression = this.expression.and(employees.get("lastName").equal((Object)"Keaton"));
        DistributedServer server = (DistributedServer)DistributedServersModel.getDistributedServers().get(0);
        Object result = server.getDistributedSession().readObject(Employee.class, this.expression);
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employeeClone = (Employee)uow.registerObject((Object)this.employee);
        uow.deleteObject((Object)employeeClone);
        uow.commit();
    }

    public void verify() {
        if (this.getObjectFromDistributedCache(this.employee) == null) {
            throw new TestErrorException("Employee was deleted from distributed cache even through descriptor was set to: DO_NOT_SEND_CHANGES");
        }
    }
}

