/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inheritance;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.DeleteAllQueryTestHelper;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.inheritance.Bus;
import org.eclipse.persistence.testing.models.jpa.inheritance.Company;
import org.eclipse.persistence.testing.models.jpa.inheritance.FueledVehicle;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceModelExamples;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.jpa.inheritance.NonFueledVehicle;
import org.eclipse.persistence.testing.models.jpa.inheritance.Vehicle;

public class DeleteAllQueryInheritanceJunitTest
extends JUnitTestCase {
    static Vector originalVehicleObjects;
    static Vector originalCompanyObjects;
    static ReportQuery reportQueryVehicles;
    static ReportQuery reportQueryCompanies;

    public DeleteAllQueryInheritanceJunitTest() {
        reportQueryVehicles = new ReportQuery(Vehicle.class, new ExpressionBuilder());
        reportQueryVehicles.setShouldRetrievePrimaryKeys(true);
        reportQueryCompanies = new ReportQuery(Company.class, new ExpressionBuilder());
        reportQueryCompanies.setShouldRetrievePrimaryKeys(true);
    }

    public DeleteAllQueryInheritanceJunitTest(String name) {
        super(name);
        reportQueryVehicles = new ReportQuery(Vehicle.class, new ExpressionBuilder());
        reportQueryVehicles.setShouldRetrievePrimaryKeys(true);
        reportQueryCompanies = new ReportQuery(Company.class, new ExpressionBuilder());
        reportQueryCompanies.setShouldRetrievePrimaryKeys(true);
    }

    public void setUp() {
        super.setUp();
        Vector currentVehicleObjects = (Vector)DeleteAllQueryInheritanceJunitTest.getDbSession().executeQuery((DatabaseQuery)reportQueryVehicles);
        Vector currentCompanyObjects = (Vector)DeleteAllQueryInheritanceJunitTest.getDbSession().executeQuery((DatabaseQuery)reportQueryCompanies);
        if (!currentVehicleObjects.equals(originalVehicleObjects) || !currentCompanyObjects.equals(originalCompanyObjects)) {
            if (!currentVehicleObjects.isEmpty() || !currentCompanyObjects.isEmpty()) {
                this.clearVehiclesCompanies();
            }
            DeleteAllQueryInheritanceJunitTest.populateVehiclesCompanies();
            originalVehicleObjects = (Vector)DeleteAllQueryInheritanceJunitTest.getDbSession().executeQuery((DatabaseQuery)reportQueryVehicles);
            originalCompanyObjects = (Vector)DeleteAllQueryInheritanceJunitTest.getDbSession().executeQuery((DatabaseQuery)reportQueryCompanies);
        }
        this.clearCache();
    }

    protected static DatabaseSession getDbSession() {
        return DeleteAllQueryInheritanceJunitTest.getServerSession();
    }

    protected static UnitOfWork acquireUnitOfWork() {
        return DeleteAllQueryInheritanceJunitTest.getDbSession().acquireUnitOfWork();
    }

    protected void clearVehiclesCompanies() {
        UnitOfWork uow = DeleteAllQueryInheritanceJunitTest.acquireUnitOfWork();
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Vehicle.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Company.class));
        uow.commit();
        this.clearCache();
    }

    protected static void populateVehiclesCompanies() {
        UnitOfWork uow = DeleteAllQueryInheritanceJunitTest.acquireUnitOfWork();
        uow.registerNewObject((Object)InheritanceModelExamples.companyExample1());
        uow.registerNewObject((Object)InheritanceModelExamples.companyExample2());
        uow.registerNewObject((Object)InheritanceModelExamples.companyExample3());
        uow.commit();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(DeleteAllQueryInheritanceJunitTest.class);
        return suite;
    }

    public void testSetup() {
        new InheritanceTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public static void test_null() {
        DeleteAllQueryInheritanceJunitTest.deleteAllQueryInternal_Deferred_Children(Vehicle.class, null);
    }

    public static void test_nullNonDeferred() {
        DeleteAllQueryInheritanceJunitTest.deleteAllQueryInternal_NonDeferred_Children(Vehicle.class, null);
    }

    public static void test_ownerTOP() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("owner").get("name").equal((Object)"TOP");
        DeleteAllQueryInheritanceJunitTest.deleteAllQueryInternal_Deferred_Children(Vehicle.class, exp);
    }

    public static void test_fuelTypePetrol() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("fuelType").equalsIgnoreCase("Petrol");
        DeleteAllQueryInheritanceJunitTest.deleteAllQueryInternal_Deferred_Children(FueledVehicle.class, exp);
    }

    public static void test_schoolBusNullDriver() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("description").equalsIgnoreCase("School bus").and(builder.get("busDriver").isNull());
        DeleteAllQueryInheritanceJunitTest.deleteAllQueryInternal_Deferred_Children(Bus.class, exp);
    }

    public static void test_ownerOwnsNonFueledVehicle() {
        ExpressionBuilder builder = new ExpressionBuilder();
        ExpressionBuilder subBuilder = new ExpressionBuilder();
        ReportQuery rq = new ReportQuery(NonFueledVehicle.class, subBuilder);
        rq.addAttribute("id");
        Expression subExpression = subBuilder.get("owner").equal(builder.get("owner"));
        rq.setSelectionCriteria(subExpression);
        Expression exp = builder.exists(rq);
        DeleteAllQueryInheritanceJunitTest.deleteAllQueryInternal_Deferred_Children(FueledVehicle.class, exp);
    }

    protected static void deleteAllQueryInternal_Deferred_Children(Class referenceClass, Expression selectionExpression) {
        DeleteAllQueryInheritanceJunitTest.deleteAllQueryInternal(referenceClass, selectionExpression, true, true);
    }

    protected static void deleteAllQueryInternal_NonDeferred_Children(Class referenceClass, Expression selectionExpression) {
        DeleteAllQueryInheritanceJunitTest.deleteAllQueryInternal(referenceClass, selectionExpression, false, true);
    }

    protected static void deleteAllQueryInternal_Deferred_NoChildren(Class referenceClass, Expression selectionExpression) {
        DeleteAllQueryInheritanceJunitTest.deleteAllQueryInternal(referenceClass, selectionExpression, true, false);
    }

    protected static void deleteAllQueryInternal_NonDeferred_NoChildren(Class referenceClass, Expression selectionExpression) {
        DeleteAllQueryInheritanceJunitTest.deleteAllQueryInternal(referenceClass, selectionExpression, false, false);
    }

    protected static void deleteAllQueryInternal(Class referenceClass, Expression selectionExpression, boolean shouldDeferExecutionInUOW, boolean handleChildren) {
        if (DeleteAllQueryInheritanceJunitTest.getServerSession().getDatasourcePlatform().isSymfoware()) {
            DeleteAllQueryInheritanceJunitTest.getServerSession().logMessage("DeleteAllQueryInheritanceJunitTest test skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String errorMsg = DeleteAllQueryTestHelper.execute((Session)DeleteAllQueryInheritanceJunitTest.getDbSession(), (Class)referenceClass, (Expression)selectionExpression, (boolean)shouldDeferExecutionInUOW, (boolean)handleChildren);
        if (errorMsg != null) {
            DeleteAllQueryInheritanceJunitTest.fail((String)errorMsg);
        }
    }
}

