/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.sessionbean;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.rmi.PortableRemoteObject;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.sessionbean.EmployeeService;

public class SessionBeanTestsRCM
extends JUnitTestCase {
    public final int SLEEP = 2000;
    protected List<String> serverURLs;
    protected int server;
    protected EmployeeService service;

    public SessionBeanTestsRCM() {
    }

    public SessionBeanTestsRCM(String name) {
        super(name);
    }

    public SessionBeanTestsRCM(String name, boolean shouldRunTestOnServer) {
        super(name);
        this.shouldRunTestOnServer = shouldRunTestOnServer;
        URL url = ((Object)((Object)this)).getClass().getResource("/weblogic.properties");
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
        this.serverURLs = new ArrayList<String>();
        this.serverURLs.add(properties.getProperty("rcm.wls.server1.url"));
        this.serverURLs.add(properties.getProperty("rcm.wls.server2.url"));
        this.serverURLs.add(properties.getProperty("rcm.wls.server3.url"));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SessionBeanTestsRCM");
        suite.addTest((Test)new SessionBeanTestsRCM("testSetup", true));
        suite.addTest((Test)new SessionBeanTestsRCM("testLag", false));
        suite.addTest((Test)new SessionBeanTestsRCM("testUpdates", false));
        suite.addTest((Test)new SessionBeanTestsRCM("testDelete", false));
        return suite;
    }

    public synchronized int nextServer() {
        ++this.server;
        if (this.server >= this.serverURLs.size()) {
            this.server = 0;
        }
        return this.server;
    }

    public EmployeeService getEmployeeService() {
        if (this.service == null) {
            this.service = this.nextEmployeeService();
        }
        return this.service;
    }

    public EmployeeService nextEmployeeService() {
        EmployeeService service = null;
        int server = this.nextServer();
        Properties properties = new Properties();
        String url = this.serverURLs.get(server);
        properties.put("java.naming.provider.url", url);
        System.out.println(server + ":" + url);
        try {
            InitialContext context = new InitialContext(properties);
            service = (EmployeeService)PortableRemoteObject.narrow((Object)context.lookup("EmployeeService#org.eclipse.persistence.testing.models.jpa.sessionbean.EmployeeService"), EmployeeService.class);
        }
        catch (Exception notFoundException) {
            throw new Error("Lookup failed.", notFoundException);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetup() throws Exception {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"sessionbean"));
        EntityManager em = SessionBeanTestsRCM.createEntityManager((String)"sessionbean");
        this.beginTransaction(em);
        try {
            Employee employee = new Employee();
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.closeEntityManagerAndTransaction(em);
            }
        }
    }

    public void testUpdates() {
        int index;
        EmployeeService service = this.nextEmployeeService();
        Employee employee = (Employee)service.findAll().get(0);
        for (index = 0; index < 5; ++index) {
            service = this.nextEmployeeService();
            employee = service.findById(employee.getId().intValue());
        }
        for (index = 0; index < 5; ++index) {
            service = this.nextEmployeeService();
            int random = (int)(Math.random() * 1000000.0);
            employee = service.findById(employee.getId().intValue());
            employee.setLastName(String.valueOf(random));
            service.update(employee);
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void testDelete() {
        EmployeeService service = this.nextEmployeeService();
        Employee employee = new Employee();
        employee.setId(Integer.valueOf(service.insert(employee)));
        for (int index = 0; index < 5; ++index) {
            service = this.nextEmployeeService();
            employee = service.findById(employee.getId().intValue());
        }
        service = this.nextEmployeeService();
        employee = service.findById(employee.getId().intValue());
        service.delete(employee);
        try {
            Thread.sleep(2000L);
        }
        catch (Exception index) {
            // empty catch block
        }
        for (int index = 0; index < 5; ++index) {
            service = this.nextEmployeeService();
            Employee result = service.findById(employee.getId().intValue());
            if (result == null) continue;
            SessionBeanTestsRCM.fail((String)("Employee should be removed:" + result));
        }
    }

    public void testLag() {
        EmployeeService service = this.nextEmployeeService();
        Employee employee = (Employee)service.findAll().get(0);
        for (int index = 0; index < 5; ++index) {
            service = this.nextEmployeeService();
            employee = service.findById(employee.getId().intValue());
        }
        try {
            Thread.sleep(20000L);
        }
        catch (Exception index) {
            // empty catch block
        }
        int[] sleeps = new int[]{1, 50, 100, 500, 1000, 2000, 3000, 4000, 5000, 10000};
        int sleep = 0;
        boolean success = false;
        boolean failed = false;
        while (!success && sleep < sleeps.length) {
            for (int index = 0; index < 10; ++index) {
                service = this.nextEmployeeService();
                int random = (int)(Math.random() * 1000000.0);
                employee = service.findById(employee.getId().intValue());
                employee.setLastName(String.valueOf(random));
                try {
                    service.update(employee);
                }
                catch (Exception lockError) {
                    System.out.println("Failed at sleep of:" + sleeps[sleep] + " on attmept:" + index);
                    ++sleep;
                    failed = true;
                    break;
                }
                try {
                    Thread.sleep(sleeps[sleep]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!failed) {
                success = true;
                System.out.println("Success at sleep of:" + sleeps[sleep]);
                break;
            }
            failed = false;
        }
    }
}

