/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalClassConverter;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * The external form of a converter.
 *
 * @see BasicMapMapping
 * @see ConvertibleMapping
 * @see ElementCollectionMapping
 * @see EmbeddableEntity
 * @see ORMConfiguration
 *
 * @version 2.6
 */
final class ClassConverter extends AbstractConverter
                           implements ExternalClassConverter {

	/**
	 * Creates a new <code>ClassConverter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned by the parent
	 */
	ClassConverter(AbstractExternalForm parent, int index) {
		super(parent, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(NAME);
		names.add(CLASS);
		names.add(AUTO_REPLY);
		return names;
	}

	@Override
	protected List<String> buildElementNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(DESCRIPTION);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getAutoReplyTextRange() {
		return getAttributeTextRange(AUTO_REPLY);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getClassName() {
		return getAttribute(CLASS);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getClassNameTextRange() {
		return getAttributeTextRange(CLASS);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDescription() {
		return getChildTextNode(DESCRIPTION);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getDescriptionTextRange() {
		return getChildTextNodeTextRange(DESCRIPTION);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return CONVERTER;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Boolean isAutoReply() {
		return getBooleanAttribute(AUTO_REPLY);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setAutoReply(Boolean autoReply) {
		setAttribute(AUTO_REPLY, autoReply);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setClassName(String classname) {
		setAttribute(CLASS, classname);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDescription(String description) {
		updateChildTextNode(DESCRIPTION, description);
	}
}