/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describe the configurable properties defined for a stored
 * procedure query in the EclipseLink 1.1 ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.Entity
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalNamedStoredProcedureQuery extends ExternalNamedQuery {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String NAMED_STORED_PROCEDURE_QUERY = "named-stored-procedure-query";

	/**
	 * The attribute name used to store and retrieve the procedure-name property.
	 */
	String PROCEDURE_NAME = "procedure-name";

	/**
	 * The attribute name used to store and retrieve the result-class property.
	 */
	String RESULT_CLASS = "result-class";

	/**
	 * The attribute name used to store and retrieve the result-set-mapping property.
	 */
	String RESULT_SET_MAPPING = "result-set-mapping";

	/**
	 * The attribute name used to store and retrieve the returns-result-set property.
	 */
	String RETURNS_RESULT_SET = "returns-result-set";

	/**
	 * Adds a query parameter to this stored procedure.
	 */
	ExternalStoredProcedureParameter addParameter();

	/**
	 * Adds a result class name to this stored procedure.
	 */
	void addResultClassName(String name);

	/**
	 * Adds a result class mapping to this stored procedure.
	 */
	void addResultSetMapping(String mapping);

	/**
	 * Returns whether this procedure returns a result set.
	 */
	Boolean doesReturnResultSet();

	/**
	 * Returns the parameter at the given index.
	 */
	ExternalStoredProcedureParameter getParameter(int index);

	/**
	 * Returns the name of this the stored procedure.
	 */
	String getProcedureName();

	/**
	 * Returns the {@link TextRange} for the procedure name value.
	 */
	TextRange getProcedureNameTextRange();

	/**
	 * Returns the result class name at the given index.
	 */
	String getResultClassName(int index);

	/**
	 * Returns the result set mapping at the given index.
	 */
	String getResultSetMapping(int index);

	/**
	 * Returns the result set mapping at the given index text range.
	 */
	TextRange getResultSetMappingTextRange(int index);

	/**
	 * Returns the {@link TextRange} for the return result set.
	 */
	TextRange getReturnResultSetTextRange();

	/**
	 * Returns all the parameters in this stored procedure.
	 */
	List<ExternalStoredProcedureParameter> parameters();

	/**
	 * Returns the number of parameters in this stored procedure.
	 */
	int parametersSize();

	/**
	 * Removes the parameter at the specified index from the stored procedure.
	 */
	void removeParameter(int index);

	/**
	 * Removes the result class name at the specified index from the stored procedure.
	 */
	void removeResultClassName(int index);

	/**
	 * Removes the result set mapping at the specified index from the stored procedure.
	 */
	void removeResultSetMapping(int index);

	/**
	 * Returns all the result class names in this stored procedure.
	 */
	List<String> resultClassNames();

	/**
	 * Returns the number of result class names in this stored procedure.
	 */
	int resultClassNameSize();

	/**
	 * Returns all the result set mappings in this stored procedure.
	 */
	List<String> resultSetMappings();

	/**
	 * Returns the number of result set mappings in this stored procedure.
	 */
	int resultSetMappingsSize();

	/**
	 * Sets whether this procedure returns a result set.
	 */
	void setDoesReturnResultSet(Boolean returnResultSet);

	/**
	 * Sets the name of the procedure.
	 */
	void setProcedureName(String name);
}