/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface defines all properties and behavior associated with named query configuration in
 * the ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.NamedQuery
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalNamedQuery extends ExternalForm {

	/**
	 * The element name of the child text node for the description.
	 */
	String DESCRIPTION = "description";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * The element name used to store and retrieve the query child text node.
	 */
	String QUERY = "query";

	/**
	 * Adds a hint with the given name.
	 */
	ExternalQueryHint addQueryHint(String name, String value);

	/**
	 * Returns the description of query.
	 */
	String getDescription();

	@Deprecated
	int getIndex();

	/**
	 * Returns the name of the query.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} for the name value.
	 */
	TextRange getNameTextRange();

	/**
	 * Returns the string representing the JPAQL (EJBQL) for the queries expression.
	 */
	String getQuery();

	/**
	 * Returns the query hint at the given position.
	 */
	ExternalQueryHint getQueryHint(int index);

	/**
	 * Returns the {@link TextRange} of the JPQL query.
	 */
	TextRange getQueryTextRange();

	/**
	 * Returns a list of vender specific query hints associated with this query.
	 */
	List<ExternalQueryHint> queryHints();

	/**
	 * Returns the count of vender specific query hints associated with this query.
	 */
	int queryHintsSize();

	/**
	 * Removes the query hint at the given position.
	 */
	void removeQueryHint(int index);

	/**
	 * Sets the description.
	 */
	void setDescription(String description);

	/**
	 * Sets the name of the query.
	 */
	void setName(String name);

	/**
	 * Sets the string representing the JPAQL for the queries expression.
	 */
	void setQuery(String query);
}