/*******************************************************************************
 * Copyright (c) 2011, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterator;

import java.util.ListIterator;
import java.util.NoSuchElementException;

/**
 * An <code>AbstractRepeatingElementListIterator</code> provides a {@link ListIterator}
 * that returns a single element a specific number of times.
 *
 * @param <E> the type of elements returned by the iterator
 *
 * @see org.eclipse.jpt.common.utility.internal.collection.AbstractRepeatingElementList
 */
public abstract class AbstractRepeatingElementListIterator<E>
	extends AbstractRepeatingElementIterator<E>
	implements ListIterator<E>
{
	protected AbstractRepeatingElementListIterator(int size) {
		super(size);
	}

	@Override
	public int nextIndex() {
		return this.cursor;
	}

	@Override
	public int previousIndex() {
		return this.cursor - 1;
	}

	@Override
	public boolean hasPrevious() {
		return this.cursor != 0;
	}

	@Override
	public E previous() {
		if (this.hasPrevious()) {
			this.cursor--;
			return this.getElement();
		}
		throw new NoSuchElementException();
	}

	@Override
	public void add(E e) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void set(E e) {
		throw new UnsupportedOperationException();
	}
}