/*******************************************************************************
 * Copyright (c) 2011, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * An <code>AbstractRepeatingElementIterator</code> provides an {@link Iterator}
 * that returns a single element a specific number of times.
 *
 * @param <E> the type of elements returned by the iterator
 *
 * @see org.eclipse.jpt.common.utility.internal.collection.AbstractRepeatingElementList
 */
@SuppressWarnings("nls")
public abstract class AbstractRepeatingElementIterator<E>
	implements Iterator<E>
{
	private final int size;
	/* private-protected */ int cursor;

	/**
	 * Construct an iterator for the specified number of elements.
	 */
	protected AbstractRepeatingElementIterator(int size) {
		super();
		if (size < 0) {
			throw new IllegalArgumentException("size: " + size);
		}
		this.size = size;
		this.cursor = 0;
	}

	@Override
	public boolean hasNext() {
		return this.cursor != this.size;
	}

	@Override
	public E next() {
		if (this.hasNext()) {
			this.cursor++;
			return this.getElement();
		}
		throw new NoSuchElementException();
	}

	protected abstract E getElement();

	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this, this.size);
	}
}