/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.command;

import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * Command wrapper that can have its wrapped command changed,
 * allowing a client to change a previously-supplied command's
 * behavior mid-stream.
 *
 * @parm <T> the type of the object passed to the command
 * @see #setCommand(ParameterizedCommand)
 */
public class ParameterizedCommandWrapper<T>
	implements ParameterizedCommand<T>
{
	protected volatile ParameterizedCommand<T> command;

	public ParameterizedCommandWrapper(ParameterizedCommand<T> command) {
		super();
		if (command == null) {
			throw new NullPointerException();
		}
		this.command = command;
	}

	@Override
	public void execute(T argument) {
		this.command.execute(argument);
	}

	public void setCommand(ParameterizedCommand<T> command) {
		if (command == null) {
			throw new NullPointerException();
		}
		this.command = command;
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this, this.command);
	}
}