/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.persistence.tools.db.driver;

import java.util.ArrayList;
import org.eclipse.persistence.tools.gen.db.Database;

/**
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
class Derby extends AbstractWorkbenchDriverAdapter {

	Derby(Database database) {
		super(database);
	}

	@Override
	CatalogStrategy buildCatalogStrategy() {
		return new FauxCatalogStrategy();
	}

	@Override
	FoldingStrategy buildFoldingStrategy() {
		return UpperCaseFoldingStrategy.instance();
	}

	@Override
	void addDefaultSchemaNamesTo(ArrayList<String> names) {
		names.add(this.getDefaultSchemaName());
	}

	/**
	 * The default user name on Derby is <code>"APP"</code> when the user
	 * connects without a user name.
	 */
	private String getDefaultSchemaName() {
		String userName = this.getUserName();
		return ((userName != null) && (userName.length() != 0)) ?
				userName :
				DEFAULT_USER_NAME;
	}
	private static final String DEFAULT_USER_NAME = "APP";


	// ********** factory **********

	static class Factory implements WorkbenchDriverAdapterFactory {
		private static final String[] VENDORS = {
			"Derby"
		};
		@Override
		public String[] getSupportedVendors() {
			return VENDORS;
		}
		@Override
		public WorkbenchDriverAdapter buildAdapter(Database database) {
			return new Derby(database);
		}
	}
}