/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.gen.nosql.mongo.meta;

/**
 * This class describes the metadata of MongoDB column that is a nested
 * value (non-nested).  A nested value is a column where the value metadata
 * can be described by a {@link CollectionDescriptor}.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *  
 * @author John Bracken
 * @version 2.6
 */
public final class NestedColumnDescriptor extends ColumnDescriptor{

	/** The column descriptor that describes this columns value. */
	private CollectionDescriptor columnDescriptor;
	
	/**
	 * Constructor.
	 * 
	 * @param columName name of the column.
	 */
	public NestedColumnDescriptor(String columName) {
		super(columName);
		this.columnDescriptor = new CollectionDescriptor(columName);
	}
	
	/**
	 * The column descriptor that describe the structure of
	 * this column's nested value. 
	 */
	public CollectionDescriptor getColumnDescriptor() {
		return this.columnDescriptor;
	}	
}
