/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value.swing;

import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimplePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class NumberSpinnerModelAdapterTests
extends TestCase {
    private ModifiablePropertyValueModel<Number> valueHolder;
    private SpinnerModel spinnerModelAdapter;
    boolean eventFired;

    public NumberSpinnerModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.valueHolder = new SimplePropertyValueModel((Object)new Integer(0));
        this.spinnerModelAdapter = new NumberSpinnerModelAdapter(this.valueHolder, -33, 33, 1){

            protected PropertyChangeListener buildNumberChangeListener() {
                return this.buildNumberChangeListener_();
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSetValueSpinnerModel() throws Exception {
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NumberSpinnerModelAdapterTests.this.eventFired = true;
            }
        });
        this.spinnerModelAdapter.setValue(new Integer(5));
        NumberSpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        NumberSpinnerModelAdapterTests.assertEquals((Object)new Integer(5), (Object)this.valueHolder.getValue());
    }

    public void testSetValueValueHolder() throws Exception {
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NumberSpinnerModelAdapterTests.this.eventFired = true;
            }
        });
        NumberSpinnerModelAdapterTests.assertEquals((Object)new Integer(0), (Object)this.spinnerModelAdapter.getValue());
        this.valueHolder.setValue((Object)new Integer(7));
        NumberSpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        NumberSpinnerModelAdapterTests.assertEquals((Object)new Integer(7), (Object)this.spinnerModelAdapter.getValue());
    }

    public void testDefaultValue() throws Exception {
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NumberSpinnerModelAdapterTests.this.eventFired = true;
            }
        });
        NumberSpinnerModelAdapterTests.assertEquals((Object)new Integer(0), (Object)this.spinnerModelAdapter.getValue());
        this.valueHolder.setValue(null);
        NumberSpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        NumberSpinnerModelAdapterTests.assertEquals((Object)new Integer(-33), (Object)this.spinnerModelAdapter.getValue());
    }

    public void testHasListeners() throws Exception {
        SimplePropertyValueModel localValueHolder = (SimplePropertyValueModel)this.valueHolder;
        NumberSpinnerModelAdapterTests.assertFalse((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.spinnerModelAdapter);
        TestChangeListener listener = new TestChangeListener();
        this.spinnerModelAdapter.addChangeListener(listener);
        NumberSpinnerModelAdapterTests.assertTrue((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners(this.spinnerModelAdapter);
        this.spinnerModelAdapter.removeChangeListener(listener);
        NumberSpinnerModelAdapterTests.assertFalse((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.spinnerModelAdapter);
    }

    private void verifyHasNoListeners(SpinnerModel adapter) throws Exception {
        NumberSpinnerModelAdapterTests.assertEquals((int)0, (int)((NumberSpinnerModelAdapter)adapter).getChangeListeners().length);
    }

    private void verifyHasListeners(Object adapter) throws Exception {
        NumberSpinnerModelAdapterTests.assertFalse((((NumberSpinnerModelAdapter)adapter).getChangeListeners().length == 0 ? 1 : 0) != 0);
    }

    public void testNullInitialValue() {
        this.valueHolder = new SimplePropertyValueModel();
        this.spinnerModelAdapter = new NumberSpinnerModelAdapter(this.valueHolder, new Integer(-33), new Integer(33), new Integer(1), new Integer(0)){

            protected PropertyChangeListener buildNumberChangeListener() {
                return this.buildNumberChangeListener_();
            }
        };
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NumberSpinnerModelAdapterTests.this.eventFired = true;
            }
        });
        NumberSpinnerModelAdapterTests.assertEquals((Object)new Integer(0), (Object)this.spinnerModelAdapter.getValue());
        this.valueHolder.setValue((Object)new Integer(7));
        NumberSpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        NumberSpinnerModelAdapterTests.assertEquals((Object)new Integer(7), (Object)this.spinnerModelAdapter.getValue());
    }

    private class TestChangeListener
    implements ChangeListener {
        TestChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            NumberSpinnerModelAdapterTests.fail((String)"unexpected event");
        }
    }
}

