/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ClassTools;
import org.eclipse.persistence.tools.utility.SystemTools;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.io.FileTools;

public class FileToolsTests
extends TestCase {
    private File tempDir;

    public FileToolsTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tempDir = this.buildTempDir();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.deleteDir(this.tempDir);
    }

    public void testFilesIn() {
        HashBag files = CollectionTools.collection((Iterator)FileTools.files((String)this.tempDir.getPath()));
        FileToolsTests.assertEquals((String)"invalid file count", (int)3, (int)files.size());
    }

    public void testDirectoriesIn() {
        HashBag files = CollectionTools.collection((Iterator)FileTools.directories((String)this.tempDir.getPath()));
        FileToolsTests.assertEquals((String)"invalid directory count", (int)2, (int)files.size());
    }

    public void testFilesInTree() {
        HashBag files = CollectionTools.collection((Iterator)FileTools.allFiles((String)this.tempDir.getPath()));
        FileToolsTests.assertEquals((String)"invalid file count", (int)9, (int)files.size());
    }

    public void testDirectoriesInTree() {
        HashBag files = CollectionTools.collection((Iterator)FileTools.allDirectories((String)this.tempDir.getPath()));
        FileToolsTests.assertEquals((String)"invalid directory count", (int)3, (int)files.size());
    }

    public void testDeleteDirectory() throws IOException {
        File dir = this.buildTempDir();
        FileToolsTests.assertTrue((String)"temporary directory not created", (boolean)dir.exists());
        FileTools.deleteDirectory((String)dir.getPath());
        FileToolsTests.assertFalse((String)"temporary directory not deleted", (boolean)dir.exists());
    }

    public void testDeleteDirectoryContents() throws IOException {
        File dir = this.buildTempDir();
        FileToolsTests.assertTrue((String)"temporary directory not created", (boolean)dir.exists());
        FileTools.deleteDirectoryContents((String)dir.getPath());
        FileToolsTests.assertTrue((String)"temporary directory should not have been deleted", (boolean)dir.exists());
        FileToolsTests.assertTrue((String)"temporary directory contents not deleted", (dir.listFiles().length == 0 ? 1 : 0) != 0);
        dir.delete();
    }

    public void testCopyToFile() throws IOException {
        File destFile = new File(this.tempDir, "destfile.txt");
        this.copyToFile(destFile, "testCopyToFile");
    }

    public void testCopyToPreExistingFile() throws IOException {
        File destFile = new File(this.tempDir, "destfile.txt");
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(destFile));
        writer.write("this text should be replaced...");
        ((Writer)writer).close();
        this.copyToFile(destFile, "testCopyToPreExistingFile");
    }

    private void copyToFile(File destFile, String writeString) throws IOException {
        File sourceFile = new File(this.tempDir, "sourcefile.txt");
        char[] readBuffer = new char[writeString.length()];
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(sourceFile));
        writer.write(writeString);
        ((Writer)writer).close();
        FileTools.copyToFile((File)sourceFile, (File)destFile);
        InputStreamReader reader = new InputStreamReader(new FileInputStream(destFile));
        reader.read(readBuffer);
        ((Reader)reader).close();
        String readString = new String(readBuffer);
        FileToolsTests.assertEquals((String)writeString, (String)readString);
    }

    public void testCopyToDirectory() throws IOException {
        File sourceFile = new File(this.tempDir, "sourcefile.txt");
        String writeString = "testCopyToDirectory";
        File destDir = new File(this.tempDir, "destdir");
        destDir.mkdir();
        File destFile = new File(destDir, "sourcefile.txt");
        char[] readBuffer = new char[writeString.length()];
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(sourceFile));
        writer.write(writeString);
        ((Writer)writer).close();
        FileTools.copyToDirectory((File)sourceFile, (File)destDir);
        InputStreamReader reader = new InputStreamReader(new FileInputStream(destFile));
        reader.read(readBuffer);
        ((Reader)reader).close();
        String readString = new String(readBuffer);
        FileToolsTests.assertEquals((String)writeString, (String)readString);
        FileTools.copyToDirectory((File)sourceFile, (File)destDir);
        reader = new InputStreamReader(new FileInputStream(destFile));
        reader.read(readBuffer);
        ((Reader)reader).close();
        readString = new String(readBuffer);
        FileToolsTests.assertEquals((String)writeString, (String)readString);
    }

    public void testFilter() throws IOException {
        String prefix = "XXXtestFileXXX";
        File testFile1 = new File(this.tempDir, String.valueOf(prefix) + "1");
        testFile1.createNewFile();
        File testFile2 = new File(this.tempDir, String.valueOf(prefix) + "2");
        testFile2.createNewFile();
        FileFilter filter = this.buildFileFilter(prefix);
        Iterator filteredFilesIterator = FileTools.filter((Iterator)FileTools.files((File)this.tempDir), (FileFilter)filter);
        HashBag filteredFiles = CollectionTools.collection((Iterator)filteredFilesIterator);
        FileToolsTests.assertEquals((int)2, (int)filteredFiles.size());
        FileToolsTests.assertTrue((boolean)filteredFiles.contains(testFile1));
        FileToolsTests.assertTrue((boolean)filteredFiles.contains(testFile2));
    }

    private FileFilter buildFileFilter(final String prefix) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(prefix);
            }
        };
    }

    public void testStripExtension() {
        FileToolsTests.assertEquals((String)"foo", (String)FileTools.stripExtension((String)"foo.xml"));
        FileToolsTests.assertEquals((String)"foo.bar", (String)FileTools.stripExtension((String)"foo.bar.xml"));
        FileToolsTests.assertEquals((String)"foo", (String)FileTools.stripExtension((String)"foo"));
        FileToolsTests.assertEquals((String)"foo", (String)FileTools.stripExtension((String)"foo."));
    }

    public void testExtension() {
        FileToolsTests.assertEquals((String)".xml", (String)FileTools.extension((String)"foo.xml"));
        FileToolsTests.assertEquals((String)".xml", (String)FileTools.extension((String)"foo.bar.xml"));
        FileToolsTests.assertEquals((String)"", (String)FileTools.extension((String)"foo"));
        FileToolsTests.assertEquals((String)"", (String)FileTools.extension((String)"foo,xml"));
        FileToolsTests.assertEquals((String)".", (String)FileTools.extension((String)"foo."));
    }

    public void testEmptyTemporaryDirectory() throws IOException {
        File tempDir1 = FileTools.temporaryDirectory();
        File testFile1 = new File(tempDir1, "junk");
        testFile1.createNewFile();
        File tempDir2 = FileTools.emptyTemporaryDirectory();
        FileToolsTests.assertEquals((Object)tempDir1, (Object)tempDir2);
        FileToolsTests.assertTrue((boolean)tempDir2.isDirectory());
        FileToolsTests.assertEquals((int)0, (int)tempDir2.listFiles().length);
        tempDir2.delete();
    }

    public void testCanonicalFileName() {
        File file1 = new File("foo");
        file1 = new File(file1, "bar");
        file1 = new File(file1, "baz");
        file1 = new File(file1, "..");
        file1 = new File(file1, "..");
        file1 = new File(file1, "bar");
        file1 = new File(file1, "baz");
        File file2 = new File(System.getProperty("user.dir"));
        file2 = new File(file2, "foo");
        file2 = new File(file2, "bar");
        file2 = new File(file2, "baz");
        File file3 = FileTools.canonicalFile((File)file1);
        FileToolsTests.assertEquals((Object)file2, (Object)file3);
    }

    public void testPathFiles() {
        Object[] actual;
        Object[] expected;
        if (SystemTools.osIsWindows()) {
            expected = new File[]{new File("C:/"), new File("C:/foo"), new File("C:/foo/bar"), new File("C:/foo/bar/baz.txt")};
            actual = this.pathFiles(new File("C:/foo/bar/baz.txt"));
            FileToolsTests.assertTrue((boolean)Arrays.equals(expected, actual));
        }
        expected = new File[]{new File("/"), new File("/foo"), new File("/foo/bar"), new File("/foo/bar/baz.txt")};
        actual = this.pathFiles(new File("/foo/bar/baz.txt"));
        FileToolsTests.assertTrue((boolean)Arrays.equals(expected, actual));
        expected = new File[]{new File("foo"), new File("foo/bar"), new File("foo/bar/baz.txt")};
        actual = this.pathFiles(new File("foo/bar/baz.txt"));
        FileToolsTests.assertTrue((boolean)Arrays.equals(expected, actual));
        expected = new File[]{new File(".."), new File("../foo"), new File("../foo/bar"), new File("../foo/bar/baz.txt")};
        actual = this.pathFiles(new File("../foo/bar/baz.txt"));
        FileToolsTests.assertTrue((boolean)Arrays.equals(expected, actual));
        expected = new File[]{new File("."), new File("./foo"), new File("./foo/bar"), new File("./foo/bar/baz.txt")};
        actual = this.pathFiles(new File("./foo/bar/baz.txt"));
        FileToolsTests.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    private File[] pathFiles(File file) {
        return (File[])ClassTools.execute(FileTools.class, (String)"pathFiles", File.class, (Object)file);
    }

    public void testRelativeParentFile() {
        boolean exCaught;
        block2: {
            FileToolsTests.assertEquals((Object)new File(".."), (Object)this.relativeParentFile(1));
            FileToolsTests.assertEquals((Object)new File("../.."), (Object)this.relativeParentFile(2));
            FileToolsTests.assertEquals((Object)new File("../../.."), (Object)this.relativeParentFile(3));
            exCaught = false;
            try {
                File file = this.relativeParentFile(0);
                FileToolsTests.fail((String)("invalid return: " + file));
            }
            catch (RuntimeException ex) {
                InvocationTargetException ite;
                if (!(ex.getCause() instanceof InvocationTargetException) || !((ite = (InvocationTargetException)ex.getCause()).getTargetException() instanceof IllegalArgumentException)) break block2;
                exCaught = true;
            }
        }
        FileToolsTests.assertTrue((boolean)exCaught);
    }

    private File relativeParentFile(int len) {
        return (File)ClassTools.execute(FileTools.class, (String)"relativeParentFile", Integer.TYPE, (Object)new Integer(len));
    }

    public void testConvertToRelativeFile() {
        String prefix;
        String string = prefix = SystemTools.osIsWindows() ? "C:" : "";
        if (SystemTools.osIsWindows()) {
            this.verifyUnchangedRelativeFile("/dir1/dir2/file.txt", "C:/dir1/dir2");
            this.verifyUnchangedRelativeFile("D:/dir1/dir2/file.txt", "C:/dir1/dir2");
        }
        this.verifyUnchangedRelativeFile("dir1/dir2/file.txt", String.valueOf(prefix) + "/dir1/dir2");
        this.verifyUnchangedRelativeFile("./dir1/dir2/file.txt", String.valueOf(prefix) + "/dir1/dir2");
        this.verifyUnchangedRelativeFile("../../dir1/dir2/file.txt", String.valueOf(prefix) + "/dir1/dir2");
        File file = new File(String.valueOf(prefix) + "/dir1/dir2");
        File dir = new File(String.valueOf(prefix) + "/dir1/dir2");
        File relativeFile = FileTools.convertToRelativeFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File("."), (Object)relativeFile);
        file = new File(String.valueOf(prefix) + "/dir1/dir2/file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2");
        relativeFile = FileTools.convertToRelativeFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File("file.txt"), (Object)relativeFile);
        file = new File(String.valueOf(prefix) + "/dir1/dir2/../dir2/file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2");
        relativeFile = FileTools.convertToRelativeFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File("file.txt"), (Object)relativeFile);
        file = new File(String.valueOf(prefix) + "/dir1/dir2/dir3/dir4/dir5/file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2");
        relativeFile = FileTools.convertToRelativeFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File("dir3/dir4/dir5/file.txt"), (Object)relativeFile);
        file = new File(String.valueOf(prefix) + "/dir1/dir2/file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2/dir3/dir4/dir5");
        relativeFile = FileTools.convertToRelativeFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File("../../../file.txt"), (Object)relativeFile);
        file = new File(String.valueOf(prefix) + "/dir1/dir2/file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2/dir3");
        relativeFile = FileTools.convertToRelativeFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File("../file.txt"), (Object)relativeFile);
        file = new File(String.valueOf(prefix) + "/dir1/dir2/dirA/dirB/dirC/file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2/dir3/dir4/dir5");
        relativeFile = FileTools.convertToRelativeFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File("../../../dirA/dirB/dirC/file.txt"), (Object)relativeFile);
        file = new File(String.valueOf(prefix) + "/dir1/dir2");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2/dir3/dir4/dir5");
        relativeFile = FileTools.convertToRelativeFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File("../../.."), (Object)relativeFile);
        file = new File(String.valueOf(prefix) + "/My Documents/My Workspace/Project 1/lib/toplink.jar");
        dir = new File(String.valueOf(prefix) + "/My Documents/My Workspace/Project 1");
        relativeFile = FileTools.convertToRelativeFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File("lib/toplink.jar"), (Object)relativeFile);
    }

    private void verifyUnchangedRelativeFile(String fileName, String dirName) {
        File file = new File(fileName);
        File dir = new File(dirName);
        File relativeFile = FileTools.convertToRelativeFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)file, (Object)relativeFile);
    }

    public void testConvertToAbsoluteFile() {
        String prefix;
        String string = prefix = SystemTools.osIsWindows() ? "C:" : "";
        if (SystemTools.osIsWindows()) {
            this.verifyUnchangedAbsoluteFile("C:/dir1/dir2/file.txt", "C:/dir1/dir2");
            this.verifyUnchangedAbsoluteFile("D:/dir1/dir2/file.txt", "C:/dir1/dir2");
        }
        this.verifyUnchangedAbsoluteFile(String.valueOf(prefix) + "/dir1/dir2/file.txt", String.valueOf(prefix) + "/dir1/dir2");
        this.verifyUnchangedAbsoluteFile(String.valueOf(prefix) + "/./dir1/dir2/file.txt", String.valueOf(prefix) + "/dir1/dir2");
        this.verifyUnchangedAbsoluteFile(String.valueOf(prefix) + "/dir1/dir2/../../dir1/dir2/file.txt", String.valueOf(prefix) + "/dir1/dir2");
        File file = new File(".");
        File dir = new File(String.valueOf(prefix) + "/dir1/dir2");
        File absoluteFile = FileTools.convertToAbsoluteFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File(String.valueOf(prefix) + "/dir1/dir2"), (Object)absoluteFile);
        file = new File("./file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2");
        absoluteFile = FileTools.convertToAbsoluteFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File(String.valueOf(prefix) + "/dir1/dir2/file.txt"), (Object)absoluteFile);
        file = new File("file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2");
        absoluteFile = FileTools.convertToAbsoluteFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File(String.valueOf(prefix) + "/dir1/dir2/file.txt"), (Object)absoluteFile);
        file = new File("../dir2/file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2");
        absoluteFile = FileTools.convertToAbsoluteFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File(String.valueOf(prefix) + "/dir1/dir2/file.txt"), (Object)absoluteFile);
        file = new File("dir3/dir4/dir5/file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2");
        absoluteFile = FileTools.convertToAbsoluteFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File(String.valueOf(prefix) + "/dir1/dir2/dir3/dir4/dir5/file.txt"), (Object)absoluteFile);
        file = new File("../../../file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2/dir3/dir4/dir5");
        absoluteFile = FileTools.convertToAbsoluteFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File(String.valueOf(prefix) + "/dir1/dir2/file.txt"), (Object)absoluteFile);
        file = new File("../../../../../../../../file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2");
        absoluteFile = FileTools.convertToAbsoluteFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File(String.valueOf(prefix) + "/file.txt"), (Object)absoluteFile);
        file = new File("../file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2/dir3");
        absoluteFile = FileTools.convertToAbsoluteFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File(String.valueOf(prefix) + "/dir1/dir2/file.txt"), (Object)absoluteFile);
        file = new File("../../../dirA/dirB/dirC/file.txt");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2/dir3/dir4/dir5");
        absoluteFile = FileTools.convertToAbsoluteFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File(String.valueOf(prefix) + "/dir1/dir2/dirA/dirB/dirC/file.txt"), (Object)absoluteFile);
        file = new File("../../..");
        dir = new File(String.valueOf(prefix) + "/dir1/dir2/dir3/dir4/dir5");
        absoluteFile = FileTools.convertToAbsoluteFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File(String.valueOf(prefix) + "/dir1/dir2"), (Object)absoluteFile);
        file = new File("lib/toplink.jar");
        dir = new File(String.valueOf(prefix) + "/My Documents/My Workspace/Project 1");
        absoluteFile = FileTools.convertToAbsoluteFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)new File(String.valueOf(prefix) + "/My Documents/My Workspace/Project 1/lib/toplink.jar"), (Object)absoluteFile);
    }

    public void testFileNameIsReserved() {
        boolean expected = SystemTools.osIsWindows();
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileNameIsReserved((String)"CON"));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileNameIsReserved((String)"con"));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileNameIsReserved((String)"cON"));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileNameIsReserved((String)"AUX"));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileNameIsReserved((String)"COM3"));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileNameIsReserved((String)"LPT3"));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileNameIsReserved((String)"nUL"));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileNameIsReserved((String)"Prn"));
    }

    public void testFileHasAnyReservedComponents() {
        boolean expected = SystemTools.osIsWindows();
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileHasAnyReservedComponents((File)new File("C:/CON")));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileHasAnyReservedComponents((File)new File("/con/foo")));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileHasAnyReservedComponents((File)new File("c:/temp/cON")));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileHasAnyReservedComponents((File)new File("bar//baz//AUX")));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileHasAnyReservedComponents((File)new File("COM3//ttt")));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileHasAnyReservedComponents((File)new File("d:/LPT3/xxx")));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileHasAnyReservedComponents((File)new File("c:/my docs and stuff/tuesday/nUL")));
        FileToolsTests.assertEquals((boolean)expected, (boolean)FileTools.fileHasAnyReservedComponents((File)new File("Prn")));
    }

    public void testShortenFileNameFile() {
        if (SystemTools.osIsWindows()) {
            this.verifyShortenFileNameFileWin();
        } else {
            this.verifyShortenFileNameFileNonWin();
        }
    }

    private void verifyShortenFileNameFileWin() {
        File file = new File("C:\\Documents and Settings\\Administrator\\Desktop\\Project\\Text.txt");
        String fileName = FileTools.shortenFileName((File)file);
        FileToolsTests.assertEquals((String)"C:\\Documents and Settings\\...\\Desktop\\Project\\Text.txt", (String)fileName);
        FileToolsTests.assertTrue((fileName.length() <= 60 ? 1 : 0) != 0);
        file = new File("C:/");
        fileName = FileTools.shortenFileName((File)file);
        FileToolsTests.assertEquals((String)"C:\\", (String)fileName);
        FileToolsTests.assertTrue((fileName.length() <= 60 ? 1 : 0) != 0);
    }

    private void verifyShortenFileNameFileNonWin() {
        File file = new File("/home/administrator/documents and settings/desktop/Project/Text.txt");
        String fileName = FileTools.shortenFileName((File)file);
        FileToolsTests.assertEquals((String)"/home/administrator/.../desktop/Project/Text.txt", (String)fileName);
        FileToolsTests.assertTrue((fileName.length() <= 60 ? 1 : 0) != 0);
        file = new File("/home");
        fileName = FileTools.shortenFileName((File)file);
        FileToolsTests.assertEquals((String)"/home", (String)fileName);
        FileToolsTests.assertTrue((fileName.length() <= 60 ? 1 : 0) != 0);
    }

    public void testShortenFileNameFileInt() {
        if (SystemTools.osIsWindows()) {
            this.verifyShortenFileNameFileIntWin();
        } else {
            this.verifyShortenFileNameFileIntNonWin();
        }
    }

    private void verifyShortenFileNameFileIntWin() {
        File file = new File("C:\\Documents and Settings\\Administrator\\Desktop\\Project\\Text.txt");
        String fileName = FileTools.shortenFileName((File)file, (int)31);
        FileToolsTests.assertEquals((String)"C:\\...\\Desktop\\Project\\Text.txt", (String)fileName);
        FileToolsTests.assertEquals((int)31, (int)fileName.length());
        file = new File("C:/This is the file name.txt");
        fileName = FileTools.shortenFileName((File)file, (int)10);
        FileToolsTests.assertEquals((String)"C:\\This is the file name.txt", (String)fileName);
        FileToolsTests.assertEquals((int)28, (int)fileName.length());
    }

    private void verifyShortenFileNameFileIntNonWin() {
        File file = new File("/home/administrator/documents and settings/desktop/Project/Text.txt");
        String fileName = FileTools.shortenFileName((File)file, (int)31);
        FileToolsTests.assertEquals((String)"/home/.../desktop/Project/Text.txt", (String)fileName);
        FileToolsTests.assertEquals((int)34, (int)fileName.length());
        file = new File("/This is the file name.txt");
        fileName = FileTools.shortenFileName((File)file, (int)10);
        FileToolsTests.assertEquals((String)"/This is the file name.txt", (String)fileName);
        FileToolsTests.assertEquals((int)26, (int)fileName.length());
    }

    public void testShortenFileNameURL() throws Exception {
        if (SystemTools.osIsWindows()) {
            this.verifyShortenFileNameURLWin();
        } else {
            this.verifyShortenFileNameURLNonWin();
        }
    }

    private void verifyShortenFileNameURLWin() throws Exception {
        URL url = new URL("file", "", "C:/Documents and Settings/Administrator/Desktop/Project/Text.txt");
        String fileName = FileTools.shortenFileName((URL)url);
        FileToolsTests.assertEquals((String)"C:\\Documents and Settings\\...\\Desktop\\Project\\Text.txt", (String)fileName);
        FileToolsTests.assertTrue((fileName.length() <= 60 ? 1 : 0) != 0);
    }

    private void verifyShortenFileNameURLNonWin() throws Exception {
        URL url = new URL("file", "", "/home/administrator/documents and settings/desktop/Project/Text.txt");
        String fileName = FileTools.shortenFileName((URL)url);
        FileToolsTests.assertEquals((String)"/home/administrator/.../desktop/Project/Text.txt", (String)fileName);
        FileToolsTests.assertTrue((fileName.length() <= 60 ? 1 : 0) != 0);
    }

    public void testShortenFileNameURLInt() throws Exception {
        if (SystemTools.osIsWindows()) {
            this.verifyShortenFileNameURLIntWin();
        } else {
            this.verifyShortenFileNameURLIntNonWin();
        }
    }

    private void verifyShortenFileNameURLIntWin() throws Exception {
        URL url = new URL("file", "", "/C:/Documents and Settings/Administrator/Desktop/Project/Text.txt");
        String fileName = FileTools.shortenFileName((URL)url, (int)31);
        FileToolsTests.assertEquals((String)"C:\\...\\Desktop\\Project\\Text.txt", (String)fileName);
        FileToolsTests.assertEquals((int)31, (int)fileName.length());
    }

    private void verifyShortenFileNameURLIntNonWin() throws Exception {
        URL url = new URL("file", "", "/home/administrator/documents and settings/desktop/Project/Text.txt");
        String fileName = FileTools.shortenFileName((URL)url, (int)31);
        FileToolsTests.assertEquals((String)"/home/.../desktop/Project/Text.txt", (String)fileName);
        FileToolsTests.assertEquals((int)34, (int)fileName.length());
    }

    private void verifyUnchangedAbsoluteFile(String fileName, String dirName) {
        File file = new File(fileName);
        File dir = new File(dirName);
        File absoluteFile = FileTools.convertToAbsoluteFile((File)file, (File)dir);
        FileToolsTests.assertEquals((Object)file, (Object)absoluteFile);
    }

    private File buildTempDir() throws IOException {
        File dir = FileTools.newTemporaryDirectory((String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "." + this.getName()));
        File file0a = new File(dir, "file0a");
        file0a.createNewFile();
        File file0b = new File(dir, "file0b");
        file0b.createNewFile();
        File file0c = new File(dir, "file0c");
        file0c.createNewFile();
        File subdir1 = new File(dir, "subdir1");
        subdir1.mkdir();
        File file1a = new File(subdir1, "file1a");
        file1a.createNewFile();
        File file1b = new File(subdir1, "file1b");
        file1b.createNewFile();
        File subdir2 = new File(dir, "subdir2");
        subdir2.mkdir();
        File file2a = new File(subdir2, "file2a");
        file2a.createNewFile();
        File file2b = new File(subdir2, "file2b");
        file2b.createNewFile();
        File subdir3 = new File(subdir2, "subdir3");
        subdir3.mkdir();
        File file3a = new File(subdir3, "file3a");
        file3a.createNewFile();
        File file3b = new File(subdir3, "file3b");
        file3b.createNewFile();
        return dir;
    }

    private void deleteDir(File dir) {
        FileTools.deleteDirectory((File)dir);
    }
}

