/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractColumn;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class EntityColumn
extends AbstractColumn
implements ExternalEntityColumn {
    private String elementName;
    private int index;

    EntityColumn(AbstractExternalForm parent, String elementName, int index) {
        super(parent);
        this.index = index;
        this.elementName = elementName;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("unique");
        names.add("nullable");
        names.add("insertable");
        names.add("updatable");
        names.add("column-definition");
        names.add("table");
        names.add("length");
        names.add("precision");
        names.add("scale");
        return names;
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public Element getElement() {
        if (this.index == -1) {
            return super.getElement();
        }
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return this.elementName;
    }

    @Override
    public Integer getLength() {
        return this.getIntegerAttribute("length");
    }

    @Override
    public TextRange getLengthTextRange() {
        return this.getAttributeTextRange("length");
    }

    @Override
    public Integer getPrecision() {
        return this.getIntegerAttribute("precision");
    }

    @Override
    public TextRange getPrecisionTextRange() {
        return this.getAttributeTextRange("precision");
    }

    @Override
    public Integer getScale() {
        return this.getIntegerAttribute("scale");
    }

    @Override
    public TextRange getScaleTextRange() {
        return this.getAttributeTextRange("scale");
    }

    @Override
    public void removeSelf() {
        if (this.index == -1) {
            super.removeSelf();
        } else {
            this.removeChild(this.getParent(), this.getElementName(), this.index);
        }
    }

    @Override
    public void setLength(Integer length) {
        this.setAttribute("length", length);
        if (this.shouldRemoveSelf()) {
            this.removeSelf();
        }
    }

    @Override
    public void setPrecision(Integer precision) {
        this.setAttribute("precision", precision);
        if (this.shouldRemoveSelf()) {
            this.removeSelf();
        }
    }

    @Override
    public void setScale(Integer scale) {
        this.setAttribute("scale", scale);
        if (this.shouldRemoveSelf()) {
            this.removeSelf();
        }
    }

    @Override
    boolean shouldRemoveEmptyElement() {
        return true;
    }

    private boolean shouldRemoveSelf() {
        return this.shouldRemoveEmptyElement() && !this.hasAnything();
    }
}

