/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.mapping.orm.AccessType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalClassConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddable;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappedSuperClass;
import org.eclipse.persistence.tools.mapping.orm.ExternalNamedStoredProcedureQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalNativeQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalPersistenceUnit;
import org.eclipse.persistence.tools.mapping.orm.ExternalSQLResultSetMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalSequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalTableGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalTenantDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ORMDocumentType;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMRepository;
import org.eclipse.persistence.tools.mapping.tests.AbstractExternalFormTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.AccessTypeTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.ConverterTests;
import org.w3c.dom.Node;

public final class ORMConfigurationTests
extends AbstractExternalFormTests<ExternalORMConfiguration> {
    public static ORMConfiguration buildExternalForm() throws IOException {
        ORMRepository repository = new ORMRepository();
        return repository.buildORMConfiguration(null, ORMConfigurationTests.defaultVersion());
    }

    public static ORMDocumentType defaultVersion() {
        return ORMDocumentType.ECLIPELINK_2_6;
    }

    private String buildAccessMethodsTester() {
        return "access-methods";
    }

    private AbstractExternalFormTests.TextNodeTester<ExternalORMConfiguration, AccessType> buildAccessTester() {
        return AccessTypeTests.buildAccessTextNodeTester();
    }

    private AbstractExternalFormTests.TextNodeTester<ExternalORMConfiguration, String> buildCatalogTester() {
        return new AbstractExternalFormTests.TextNodeTester<ExternalORMConfiguration, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getDefaultValue() {
                return "CATALOG_DEFAULT";
            }

            @Override
            public String getNodeName() {
                return "catalog";
            }

            @Override
            public String getValue(ExternalORMConfiguration form) {
                return form.getCatalogName();
            }

            @Override
            public String getValue1() {
                return "CATALOG_VALUE_1";
            }

            @Override
            public String getValue2() {
                return "CATALOG_VALUE_2";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalORMConfiguration form, String value) {
                form.setCatalogName(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalClassConverter, String> buildConverterTester() {
        return ConverterTests.buildConverterTester();
    }

    private AbstractExternalFormTests.TextNodeTester<ExternalORMConfiguration, String> buildDescriptionTester() {
        return new AbstractExternalFormTests.TextNodeTester<ExternalORMConfiguration, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getDefaultValue() {
                return "default description";
            }

            @Override
            public String getNodeName() {
                return "description";
            }

            @Override
            public String getValue(ExternalORMConfiguration form) {
                return form.getDescription();
            }

            @Override
            public String getValue1() {
                return "testing ORM configuration";
            }

            @Override
            public String getValue2() {
                return "something";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalORMConfiguration form, String value) {
                form.setDescription(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalEmbeddable, String> buildEmbeddableTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalEmbeddable, String>(){

            @Override
            public ExternalEmbeddable addChild(ExternalORMConfiguration form, String value) {
                return form.addEmbeddable(value);
            }

            @Override
            public ExternalEmbeddable getChild(ExternalORMConfiguration form, int index) {
                return form.getEmbeddable(index);
            }

            @Override
            public ExternalEmbeddable getChildForm(List<ExternalEmbeddable> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalEmbeddable> getChildren(ExternalORMConfiguration form) {
                return form.embeddables();
            }

            @Override
            public int getChildrenSize(ExternalORMConfiguration form) {
                return form.embeddablesSize();
            }

            @Override
            public String getChildValue(ExternalEmbeddable childForm) {
                return childForm.getClassName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "org.eclipse.persistence.tools.mappings.Embeddable_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "embeddable";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(ExternalORMConfiguration form, int index) {
                form.removeEmbeddable(index);
            }
        };
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalEntity, String> buildEntityTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalEntity, String>(){

            @Override
            public ExternalEntity addChild(ExternalORMConfiguration form, String value) {
                return form.addEntity(value);
            }

            @Override
            public ExternalEntity getChild(ExternalORMConfiguration form, int index) {
                return form.getEntity(index);
            }

            @Override
            public ExternalEntity getChildForm(List<ExternalEntity> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalEntity> getChildren(ExternalORMConfiguration form) {
                return form.entities();
            }

            @Override
            public int getChildrenSize(ExternalORMConfiguration form) {
                return form.entitiesSize();
            }

            @Override
            public String getChildValue(ExternalEntity childForm) {
                return childForm.getClassName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "org.eclipse.persistence.tools.mappings.Entity_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "entity";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(ExternalORMConfiguration form, int index) {
                form.removeEntity(index);
            }
        };
    }

    private String buildHashPartitioningTester() {
        return "hash-partitioning";
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalMappedSuperClass, String> buildMappedSuperclassTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalMappedSuperClass, String>(){

            @Override
            public ExternalMappedSuperClass addChild(ExternalORMConfiguration form, String value) {
                return form.addMappedSuperClass(value);
            }

            @Override
            public ExternalMappedSuperClass getChild(ExternalORMConfiguration form, int index) {
                return form.getMappedSuperClass(index);
            }

            @Override
            public ExternalMappedSuperClass getChildForm(List<ExternalMappedSuperClass> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalMappedSuperClass> getChildren(ExternalORMConfiguration form) {
                return form.mappedSuperClasses();
            }

            @Override
            public int getChildrenSize(ExternalORMConfiguration form) {
                return form.mappedSuperClassesSize();
            }

            @Override
            public String getChildValue(ExternalMappedSuperClass childForm) {
                return childForm.getClassName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "org.eclipse.persistence.tools.mappings.MappedSuperclass_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "mapped-superclass";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(ExternalORMConfiguration form, int index) {
                form.removeMappedSuperClass(index);
            }
        };
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalNativeQuery, String> buildNamedNativeQueryTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalNativeQuery, String>(){

            @Override
            public ExternalNativeQuery addChild(ExternalORMConfiguration form, String value) {
                return form.addNamedNativeQuery(value);
            }

            @Override
            public ExternalNativeQuery getChild(ExternalORMConfiguration form, int index) {
                return form.getNamedNativeQuery(index);
            }

            @Override
            public ExternalNativeQuery getChildForm(List<ExternalNativeQuery> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalNativeQuery> getChildren(ExternalORMConfiguration form) {
                return form.namedNativeQueries();
            }

            @Override
            public int getChildrenSize(ExternalORMConfiguration form) {
                return form.namedNativeQueriesSize();
            }

            @Override
            public String getChildValue(ExternalNativeQuery childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "NAMED_NATIVE_QUERY_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "named-native-query";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(ExternalORMConfiguration form, int index) {
                form.removeNativeQuery(index);
            }
        };
    }

    private String buildNamedPlsqlStoredFunctionQueryTester() {
        return "named-plsql-stored-function-query";
    }

    private String buildNamedPlsqlStoredProcedureQueryTester() {
        return "named-plsql-stored-procedure-query";
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalBasicNamedQuery, String> buildNamedQueryTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalBasicNamedQuery, String>(){

            @Override
            public ExternalBasicNamedQuery addChild(ExternalORMConfiguration form, String value) {
                return form.addNamedQuery(value);
            }

            @Override
            public ExternalBasicNamedQuery getChild(ExternalORMConfiguration form, int index) {
                return form.getNamedQuery(index);
            }

            @Override
            public ExternalBasicNamedQuery getChildForm(List<ExternalBasicNamedQuery> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalBasicNamedQuery> getChildren(ExternalORMConfiguration form) {
                return form.namedQueries();
            }

            @Override
            public int getChildrenSize(ExternalORMConfiguration form) {
                return form.namedQueriesSize();
            }

            @Override
            public String getChildValue(ExternalBasicNamedQuery childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "NAMED_QUERY_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "named-query";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(ExternalORMConfiguration form, int index) {
                form.removeNamedQuery(index);
            }
        };
    }

    private String buildNamedStoredFunctionQueryTester() {
        return "named-stored-function-query";
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalNamedStoredProcedureQuery, String> buildNamedStoredProcedureQueryTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalNamedStoredProcedureQuery, String>(){

            @Override
            public ExternalNamedStoredProcedureQuery addChild(ExternalORMConfiguration form, String value) {
                return form.addNamedStoredProcedureQuery(value);
            }

            @Override
            public ExternalNamedStoredProcedureQuery getChild(ExternalORMConfiguration form, int index) {
                return form.getNamedStoredProcedureQuery(index);
            }

            @Override
            public ExternalNamedStoredProcedureQuery getChildForm(List<ExternalNamedStoredProcedureQuery> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalNamedStoredProcedureQuery> getChildren(ExternalORMConfiguration form) {
                return form.storedProcedureQueries();
            }

            @Override
            public int getChildrenSize(ExternalORMConfiguration form) {
                return form.storedProcedureQueriesSize();
            }

            @Override
            public String getChildValue(ExternalNamedStoredProcedureQuery childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "NAMED_STORED_PROCEDURE_QUERY_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "named-stored-procedure-query";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(ExternalORMConfiguration form, int index) {
                form.removeStoredProcedureQuery(index);
            }
        };
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalObjectTypeConverter, String> buildObjectTypeConverterTester() {
        return ConverterTests.buildObjectTypeConverterTester();
    }

    private String buildOracleArrayTester() {
        return "oracle-array";
    }

    private String buildOracleObjectTester() {
        return "oracle-object";
    }

    private AbstractExternalFormTests.ExternalFormBuilder<ORMConfiguration> buildORMConfigurationBuilder() {
        return new AbstractExternalFormTests.ExternalFormBuilder<ORMConfiguration>(){

            @Override
            public ORMConfiguration buildExternalForm() throws IOException {
                return ORMConfigurationTests.buildExternalForm();
            }

            @Override
            public ORMConfiguration buildExternalForm(ExternalForm parentForm) {
                return null;
            }

            @Override
            public int getDefaultAttributeCount() {
                return 4;
            }

            @Override
            public Node getNode(ORMConfiguration form) {
                return form.getElement();
            }

            @Override
            public String getNodeName() {
                return "entity-mappings";
            }

            @Override
            public List<String> getTreeNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }
        };
    }

    private AbstractExternalFormTests.TextNodeTester<ExternalORMConfiguration, String> buildPackageTester() {
        return new AbstractExternalFormTests.TextNodeTester<ExternalORMConfiguration, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getDefaultValue() {
                return "org.eclipse.persistence";
            }

            @Override
            public String getNodeName() {
                return "package";
            }

            @Override
            public String getValue(ExternalORMConfiguration form) {
                return form.getPackageName();
            }

            @Override
            public String getValue1() {
                return "org.test";
            }

            @Override
            public String getValue2() {
                return "java.io";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalORMConfiguration form, String value) {
                form.setPackageName(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    private String buildPartitioningTester() {
        return "partitioning";
    }

    private AbstractExternalFormTests.ChildNodeTester<ExternalORMConfiguration, ExternalPersistenceUnit> buildPersistenceUnitMetadataTester() {
        return new AbstractExternalFormTests.ChildNodeTester<ExternalORMConfiguration, ExternalPersistenceUnit>(){

            @Override
            public ExternalPersistenceUnit addChild(ExternalORMConfiguration form) {
                return form.addPersistenceUnitMetaData();
            }

            @Override
            public ExternalPersistenceUnit getChild(ExternalORMConfiguration form) {
                return form.getPersistenceUnitMetaData();
            }

            @Override
            public String getNodeName() {
                return "persistence-unit-metadata";
            }

            @Override
            public boolean hasChild(ExternalORMConfiguration form) {
                return form.hasPersistenceUnitMetaData();
            }

            @Override
            public void removeChild(ExternalORMConfiguration form) {
                form.removePersistenceUnitMetaData();
            }
        };
    }

    private String buildPinnedPartitioningTester() {
        return "pinned-partitioning";
    }

    private String buildPlsqlRecordTester() {
        return "plsql-record";
    }

    private String buildPlsqlTableTester() {
        return "plsql-table";
    }

    private String buildRangePartitioningTester() {
        return "range-partitioning";
    }

    private String buildReplicationPartitioningTester() {
        return "replication-partitioning";
    }

    private String buildRoundRobinPartitioningTester() {
        return "round-robin-partitioning";
    }

    private AbstractExternalFormTests.TextNodeTester<ExternalORMConfiguration, String> buildSchemaTester() {
        return new AbstractExternalFormTests.TextNodeTester<ExternalORMConfiguration, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getDefaultValue() {
                return "SCHEMA_DEFAULT";
            }

            @Override
            public String getNodeName() {
                return "schema";
            }

            @Override
            public String getValue(ExternalORMConfiguration form) {
                return form.getSchemaName();
            }

            @Override
            public String getValue1() {
                return "HR";
            }

            @Override
            public String getValue2() {
                return "eclipselink";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalORMConfiguration form, String value) {
                form.setSchemaName(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalSequenceGenerator, String> buildSequenceGeneratorTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalSequenceGenerator, String>(){

            @Override
            public ExternalSequenceGenerator addChild(ExternalORMConfiguration form, String value) {
                return form.addSequenceGenerator(value);
            }

            @Override
            public ExternalSequenceGenerator getChild(ExternalORMConfiguration form, int index) {
                return form.getSequenceGenerator(index);
            }

            @Override
            public ExternalSequenceGenerator getChildForm(List<ExternalSequenceGenerator> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalSequenceGenerator> getChildren(ExternalORMConfiguration form) {
                return form.sequenceGenerators();
            }

            @Override
            public int getChildrenSize(ExternalORMConfiguration form) {
                return form.sequenceGeneratorsSize();
            }

            @Override
            public String getChildValue(ExternalSequenceGenerator childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "SEQUENCE_GENERATOR_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "sequence-generator";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(ExternalORMConfiguration form, int index) {
                form.removeSequenceGenerator(index);
            }
        };
    }

    private String buildSerializedConverterTester() {
        return "serialized-converter";
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalSQLResultSetMapping, String> buildSqlResultSetMappingTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalSQLResultSetMapping, String>(){

            @Override
            public ExternalSQLResultSetMapping addChild(ExternalORMConfiguration form, String value) {
                return form.addSqlResultSetMapping(value);
            }

            @Override
            public ExternalSQLResultSetMapping getChild(ExternalORMConfiguration form, int index) {
                return form.getSqlResultSetMapping(index);
            }

            @Override
            public ExternalSQLResultSetMapping getChildForm(List<ExternalSQLResultSetMapping> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalSQLResultSetMapping> getChildren(ExternalORMConfiguration form) {
                return form.sqlResultSetMappings();
            }

            @Override
            public int getChildrenSize(ExternalORMConfiguration form) {
                return form.sqlResultSetMappingsSize();
            }

            @Override
            public String getChildValue(ExternalSQLResultSetMapping childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "SQL_RESULT_SET_MAPPING_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "sql-result-set-mapping";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(ExternalORMConfiguration form, int index) {
                form.removeSqlResultSetMapping(index);
            }
        };
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalStructConverter, String> buildStructConverterTester() {
        return ConverterTests.buildStructConverterTester();
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalTableGenerator, String> buildTableGeneratorTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalTableGenerator, String>(){

            @Override
            public ExternalTableGenerator addChild(ExternalORMConfiguration form, String value) {
                return form.addTableGenerator(value);
            }

            @Override
            public ExternalTableGenerator getChild(ExternalORMConfiguration form, int index) {
                return form.getTableGenerator(index);
            }

            @Override
            public ExternalTableGenerator getChildForm(List<ExternalTableGenerator> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalTableGenerator> getChildren(ExternalORMConfiguration form) {
                return form.tableGenerators();
            }

            @Override
            public int getChildrenSize(ExternalORMConfiguration form) {
                return form.tableGeneratorsSize();
            }

            @Override
            public String getChildValue(ExternalTableGenerator childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "TABLE_GENERATOR_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "table-generator";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(ExternalORMConfiguration form, int index) {
                form.removeTableGenerator(index);
            }
        };
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalTenantDiscriminatorColumn, String> buildTenantDiscriminatorColumnTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalTenantDiscriminatorColumn, String>(){

            @Override
            public ExternalTenantDiscriminatorColumn addChild(ExternalORMConfiguration form, String value) {
                ExternalTenantDiscriminatorColumn column = form.addDiscriminatorColumn();
                column.setName(value);
                return column;
            }

            @Override
            public ExternalTenantDiscriminatorColumn getChild(ExternalORMConfiguration form, int index) {
                return form.getDiscriminatorColumn(index);
            }

            @Override
            public ExternalTenantDiscriminatorColumn getChildForm(List<ExternalTenantDiscriminatorColumn> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalTenantDiscriminatorColumn> getChildren(ExternalORMConfiguration form) {
                return form.discriminatorColumns();
            }

            @Override
            public int getChildrenSize(ExternalORMConfiguration form) {
                return form.discriminatorColumnSize();
            }

            @Override
            public String getChildValue(ExternalTenantDiscriminatorColumn childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return Integer.toString(index);
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "tenant-discriminator-column";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(ExternalORMConfiguration form, int index) {
                form.removeDiscriminatorColumn(index);
            }
        };
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalORMConfiguration, ExternalTypeConverter, String> buildTypeConverterTester() {
        return ConverterTests.buildTypeConverterTester();
    }

    private String buildUnionPartitioningTester() {
        return "union-partitioning";
    }

    private String buildUuidGeneratorTester() {
        return "uuid-generator";
    }

    private String buildValuePartitioningTester() {
        return "value-partitioning";
    }

    private AbstractExternalFormTests.AttributeNodeTester<ExternalORMConfiguration, ORMDocumentType> buildVersionTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<ExternalORMConfiguration, ORMDocumentType>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return true;
            }

            @Override
            public ORMDocumentType getDefaultValue() {
                return ORMConfigurationTests.defaultVersion();
            }

            @Override
            public String getNodeName() {
                return "version";
            }

            @Override
            public ORMDocumentType getValue(ExternalORMConfiguration form) {
                return form.getDocumentType();
            }

            @Override
            public ORMDocumentType getValue1() {
                return ORMDocumentType.ECLIPELINK_2_2;
            }

            @Override
            public ORMDocumentType getValue2() {
                return ORMDocumentType.JPA_1_0;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return false;
            }

            @Override
            public void setValue(ExternalORMConfiguration form, ORMDocumentType value) {
                form.setDocumentType(value);
            }

            @Override
            public String toString(ORMDocumentType value) {
                return value.getVersion();
            }
        };
    }

    @Override
    protected void populate(AbstractExternalFormTests.RootNodeTester tester) {
        tester.setBuilder(this.buildORMConfigurationBuilder());
        tester.addAttribute(this.buildVersionTester());
        tester.addTextNode(this.buildDescriptionTester());
        tester.addNode(this.buildPersistenceUnitMetadataTester());
        tester.addTextNode(this.buildPackageTester());
        tester.addTextNode(this.buildSchemaTester());
        tester.addTextNode(this.buildCatalogTester());
        tester.addTextNode(this.buildAccessTester());
        tester.addUnsupportedNode(this.buildAccessMethodsTester());
        tester.addListNodes(this.buildTenantDiscriminatorColumnTester());
        tester.addListNodes(this.buildConverterTester());
        tester.addListNodes(this.buildTypeConverterTester());
        tester.addListNodes(this.buildObjectTypeConverterTester());
        tester.addUnsupportedNode(this.buildSerializedConverterTester());
        tester.addListNodes(this.buildStructConverterTester());
        tester.addListNodes(this.buildSequenceGeneratorTester());
        tester.addListNodes(this.buildTableGeneratorTester());
        tester.addUnsupportedNode(this.buildUuidGeneratorTester());
        tester.addUnsupportedNode(this.buildPartitioningTester());
        tester.addUnsupportedNode(this.buildReplicationPartitioningTester());
        tester.addUnsupportedNode(this.buildRoundRobinPartitioningTester());
        tester.addUnsupportedNode(this.buildPinnedPartitioningTester());
        tester.addUnsupportedNode(this.buildRangePartitioningTester());
        tester.addUnsupportedNode(this.buildValuePartitioningTester());
        tester.addUnsupportedNode(this.buildHashPartitioningTester());
        tester.addUnsupportedNode(this.buildUnionPartitioningTester());
        tester.addListNodes(this.buildNamedQueryTester());
        tester.addListNodes(this.buildNamedNativeQueryTester());
        tester.addListNodes(this.buildNamedStoredProcedureQueryTester());
        tester.addUnsupportedNode(this.buildNamedStoredFunctionQueryTester());
        tester.addUnsupportedNode(this.buildNamedPlsqlStoredProcedureQueryTester());
        tester.addUnsupportedNode(this.buildNamedPlsqlStoredFunctionQueryTester());
        tester.addUnsupportedNode(this.buildOracleObjectTester());
        tester.addUnsupportedNode(this.buildOracleArrayTester());
        tester.addUnsupportedNode(this.buildPlsqlRecordTester());
        tester.addUnsupportedNode(this.buildPlsqlTableTester());
        tester.addListNodes(this.buildSqlResultSetMappingTester());
        tester.addListNodes(this.buildMappedSuperclassTester());
        tester.addListNodes(this.buildEntityTester());
        tester.addListNodes(this.buildEmbeddableTester());
    }
}

