/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.command;

import java.util.concurrent.ThreadFactory;
import org.eclipse.persistence.tools.utility.ConsumerThreadCoordinator;
import org.eclipse.persistence.tools.utility.ExceptionHandler;
import org.eclipse.persistence.tools.utility.ListenerList;
import org.eclipse.persistence.tools.utility.command.AsynchronousRepeatingCommandWrapper;
import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.command.NotifyingRepeatingCommand;

public class AsynchronousNotifyingRepeatingCommandWrapper
extends AsynchronousRepeatingCommandWrapper
implements NotifyingRepeatingCommand {
    private final ListenerList<NotifyingRepeatingCommand.Listener> listenerList = new ListenerList<NotifyingRepeatingCommand.Listener>(NotifyingRepeatingCommand.Listener.class);
    private final ExceptionHandler exceptionHandler;

    public AsynchronousNotifyingRepeatingCommandWrapper(Command command, ExceptionHandler exceptionHandler) {
        super(command, exceptionHandler);
        this.exceptionHandler = exceptionHandler;
    }

    public AsynchronousNotifyingRepeatingCommandWrapper(Command command, String threadName, ExceptionHandler exceptionHandler) {
        super(command, threadName, exceptionHandler);
        this.exceptionHandler = exceptionHandler;
    }

    public AsynchronousNotifyingRepeatingCommandWrapper(AsynchronousRepeatingCommandWrapper.Config config) {
        super(config);
        this.exceptionHandler = config.getExceptionHandler();
    }

    public AsynchronousNotifyingRepeatingCommandWrapper(Command command, ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
        super(command, threadFactory, threadName, exceptionHandler);
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    ConsumerThreadCoordinator.Consumer buildConsumer(Command command) {
        return new NotifyingConsumer(command);
    }

    @Override
    public void addListener(NotifyingRepeatingCommand.Listener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeListener(NotifyingRepeatingCommand.Listener listener) {
        this.listenerList.remove(listener);
    }

    void executionQuiesced() {
        for (NotifyingRepeatingCommand.Listener listener : this.listenerList.getListeners()) {
            try {
                listener.executionQuiesced(this);
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleException(ex);
            }
        }
    }

    class NotifyingConsumer
    extends AsynchronousRepeatingCommandWrapper.Consumer {
        NotifyingConsumer(Command command) {
            super(command);
        }

        @Override
        public void consume() {
            super.consume();
            if (AsynchronousNotifyingRepeatingCommandWrapper.this.executeFlag.isFalse()) {
                AsynchronousNotifyingRepeatingCommandWrapper.this.executionQuiesced();
            }
        }
    }
}

