/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class Scenario5_2c
extends ReportQueryTestCase {
    CursoredStream stream;

    public Scenario5_2c() {
        this.setDescription("Cursored Stream using SQL but less fields selected then items provided");
    }

    @Override
    protected void buildExpectedResults() {
        Vector employees = this.getSession().readAllObjects(Employee.class);
        Enumeration e = employees.elements();
        while (e.hasMoreElements()) {
            Employee emp = (Employee)e.nextElement();
            Object[] result = new Object[]{emp.getFirstName(), emp.getLastName()};
            this.addResult(result, null);
        }
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.reportQuery = new ReportQuery(new ExpressionBuilder());
        this.reportQuery.setReferenceClass(Employee.class);
        this.reportQuery.addAttribute("firstName");
        this.reportQuery.addAttribute("lastName");
        this.reportQuery.setSQLString("SELECT F_NAME FROM EMPLOYEE");
        this.reportQuery.useCursoredStream(1, 1, new ValueReadQuery("SELECT COUNT(*) FROM EMPLOYEE"));
    }

    @Override
    public void test() {
        try {
            this.stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)this.reportQuery);
        }
        catch (QueryException qe) {
            this.results = new Vector();
            this.results.addElement(qe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verify() {
        try {
            if (this.results == null || this.results.size() != 1 || !(this.results.firstElement() instanceof QueryException)) {
                throw new TestErrorException("Should have caught query exception: 6050");
            }
            QueryException qe = (QueryException)((Object)this.results.firstElement());
            if (qe.getErrorCode() != 6050) {
                throw new TestErrorException("Should have caught query exception: 6050, instead caught:" + (Object)((Object)qe));
            }
        }
        finally {
            if (this.stream != null && !this.stream.isClosed()) {
                this.stream.close();
            }
        }
    }
}

