/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.mapping.Employee;

public class BatchReadingStackOverflowTest
extends TestCase {
    String firstName = "StackOverflowTest";
    Employee emp_1;
    ForeignReferenceMapping mappingToDisableBatchReadInReset;
    BatchFetchType batchType;

    public BatchReadingStackOverflowTest(BatchFetchType batchType) {
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
    }

    protected void setup() throws Throwable {
        if (this.batchType == BatchFetchType.IN && !this.getSession().getPlatform().isOracle()) {
            this.throwWarning("Nested arrays not supported on this database");
        }
        this.mappingToDisableBatchReadInReset = (ForeignReferenceMapping)this.getSession().getDescriptor(Employee.class).getMappingForAttributeName("managedEmployees");
        if (this.mappingToDisableBatchReadInReset.shouldUseBatchReading()) {
            this.mappingToDisableBatchReadInReset = null;
        } else {
            this.mappingToDisableBatchReadInReset.setUsesBatchReading(true);
            this.mappingToDisableBatchReadInReset.setBatchFetchType(this.batchType);
            this.mappingToDisableBatchReadInReset.getSelectionQuery().setIsPrepared(false);
            ((ReadAllQuery)this.mappingToDisableBatchReadInReset.getSelectionQuery()).setBatchFetchPolicy(null);
            this.mappingToDisableBatchReadInReset.getDescriptor().getObjectBuilder().initializeBatchFetchedAttributes();
        }
        this.emp_1 = new Employee();
        this.emp_1.firstName = this.firstName;
        this.emp_1.lastName = "1";
        this.emp_1.sex = "male";
        this.emp_1.managedEmployees = new Vector(2);
        Employee emp_1_1 = new Employee();
        emp_1_1.firstName = this.firstName;
        emp_1_1.lastName = "1_1";
        emp_1_1.sex = "male";
        emp_1_1.managedEmployees = new Vector(1);
        this.emp_1.managedEmployees.add(emp_1_1);
        emp_1_1.manager = this.emp_1;
        Employee emp_1_2 = new Employee();
        emp_1_2.firstName = this.firstName;
        emp_1_2.lastName = "1_2";
        emp_1_2.sex = "male";
        emp_1_2.managedEmployees = new Vector(1);
        this.emp_1.managedEmployees.add(emp_1_2);
        emp_1_2.manager = this.emp_1;
        Employee emp_1_1_1 = new Employee();
        emp_1_1_1.firstName = this.firstName;
        emp_1_1_1.lastName = "1_1_1";
        emp_1_1_1.sex = "male";
        emp_1_1.managedEmployees.add(emp_1_1_1);
        emp_1_1_1.manager = emp_1_1;
        Employee emp_1_2_1 = new Employee();
        emp_1_2_1.firstName = this.firstName;
        emp_1_2_1.lastName = "1_2_1";
        emp_1_2_1.sex = "male";
        emp_1_2.managedEmployees.add(emp_1_2_1);
        emp_1_2_1.manager = emp_1_2;
        ((AbstractSession)this.getSession()).beginTransaction();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)this.emp_1);
        uow.commit();
        this.getSession().getIdentityMapAccessor().invalidateObject((Object)this.emp_1);
        this.getSession().getIdentityMapAccessor().invalidateObject((Object)emp_1_1);
        this.getSession().getIdentityMapAccessor().invalidateObject((Object)emp_1_2);
        this.getSession().getIdentityMapAccessor().invalidateObject((Object)emp_1_1_1);
        this.getSession().getIdentityMapAccessor().invalidateObject((Object)emp_1_2_1);
    }

    protected void test() throws Throwable {
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        ExpressionBuilder builder = query.getExpressionBuilder();
        Expression exp = builder.get("firstName").equal((Object)this.firstName).and(builder.get("lastName").equal((Object)"1"));
        query.setSelectionCriteria(exp);
        Employee empRead = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        empRead.getManagedEmployees().size();
        query = null;
    }

    public void reset() throws Throwable {
        if (((AbstractSession)this.getSession()).isInTransaction()) {
            ((AbstractSession)this.getSession()).rollbackTransaction();
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        if (this.mappingToDisableBatchReadInReset != null) {
            this.mappingToDisableBatchReadInReset.setUsesBatchReading(false);
            this.mappingToDisableBatchReadInReset.getSelectionQuery().setIsPrepared(false);
            ((ReadAllQuery)this.mappingToDisableBatchReadInReset.getSelectionQuery()).setBatchFetchPolicy(null);
            this.mappingToDisableBatchReadInReset.getDescriptor().getObjectBuilder().initializeBatchFetchedAttributes();
            this.mappingToDisableBatchReadInReset = null;
        }
    }
}

