/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CascadeNoBindingOnQuery
extends AutoVerifyTestCase {
    public boolean shouldBindParameters;
    public boolean usesBatchReading;

    public CascadeNoBindingOnQuery() {
        this.setDescription("This tests verifies that setting binding off on a query will cascade through indirection");
    }

    public void setup() {
        this.shouldBindParameters = this.getSession().getLogin().shouldBindAllParameters();
        OneToManyMapping mapping = (OneToManyMapping)this.getSession().getDescriptor(Employee.class).getMappingForAttributeName("phoneNumbers");
        this.usesBatchReading = mapping.shouldUseBatchReading();
        mapping.useBatchReading();
        this.getSession().getLogin().setShouldBindAllParameters(true);
    }

    public void reset() {
        this.getSession().getLogin().setShouldBindAllParameters(this.shouldBindParameters);
        OneToManyMapping mapping = (OneToManyMapping)this.getSession().getDescriptor(Employee.class).getMappingForAttributeName("phoneNumbers");
        mapping.setUsesBatchReading(this.usesBatchReading);
    }

    public void test() {
        Vector phoneNumbers;
        Vector emps = this.getSession().readAllObjects(Employee.class, new ExpressionBuilder().get("firstName").like("%o%"));
        Vector<BigDecimal> pks = new Vector<BigDecimal>();
        for (int index = 0; index < emps.size(); ++index) {
            pks.add(((Employee)emps.get(index)).getId());
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.setShouldPrepare(false);
        query.cascadeAllParts();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("id").in(builder.getParameter("inList"));
        query.setSelectionCriteria(expression);
        query.addArgument("inList", Vector.class);
        Vector<Vector<BigDecimal>> arguments = new Vector<Vector<BigDecimal>>();
        arguments.add(pks);
        emps = (Vector)this.getSession().executeQuery((DatabaseQuery)query, arguments);
        try {
            phoneNumbers = ((Employee)emps.get(0)).getPhoneNumbers();
        }
        catch (Exception ex) {
            throw new TestErrorException("Failed to cascade no prepare on query. : " + ex);
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        query = new ReadAllQuery(Employee.class);
        query.setShouldBindAllParameters(false);
        query.cascadeAllParts();
        query.setSelectionCriteria(expression);
        query.addArgument("inList", Vector.class);
        emps = (Vector)this.getSession().executeQuery((DatabaseQuery)query, arguments);
        try {
            phoneNumbers = ((Employee)emps.get(0)).getPhoneNumbers();
        }
        catch (Exception ex) {
            throw new TestErrorException("Failed to cascade no binding on query. : " + ex);
        }
    }

    protected void verify() {
    }
}

