/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.java;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public class ListTest
extends PerformanceComparisonTestCase {
    protected int size;

    public ListTest(int size) {
        this.size = size;
        this.setName("Vector vs Lists size " + size + " PerformanceComparisonTest");
        this.setDescription("Compares the performance between ArrayList and Vector.");
        this.addArrayListTest();
        this.addLinkedListTest();
    }

    public void test() throws Exception {
        int index;
        Vector<Integer> vector = new Vector<Integer>(10);
        for (index = 0; index < this.size; ++index) {
            vector.add(new Integer(index));
        }
        for (index = 0; index < this.size; ++index) {
            Object e = vector.get(index);
        }
    }

    public void addArrayListTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                int index;
                ArrayList<Integer> list = new ArrayList<Integer>(10);
                for (index = 0; index < ListTest.this.size; ++index) {
                    list.add(new Integer(index));
                }
                for (index = 0; index < ListTest.this.size; ++index) {
                    Object e = list.get(index);
                }
            }
        };
        test.setName("ArrayListTest");
        test.setAllowableDecrease(-10.0);
        this.addTest((TestCase)test);
    }

    public void addLinkedListTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                int index;
                LinkedList<Integer> list = new LinkedList<Integer>();
                for (index = 0; index < ListTest.this.size; ++index) {
                    list.add(new Integer(index));
                }
                for (index = 0; index < ListTest.this.size; ++index) {
                    Object e = list.get(index);
                }
            }
        };
        test.setName("LinkedListTest");
        test.setAllowableDecrease(-150.0);
        this.addTest((TestCase)test);
    }
}

