/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.AggregateEntityU1MMapHolder;
import org.eclipse.persistence.testing.models.collections.map.AggregateMapKey;
import org.eclipse.persistence.testing.models.collections.map.EntityMapValue;
import org.eclipse.persistence.testing.tests.collections.map.TestReadAggregateEntityU1MMapMapping;

public class TestUpdateAggregateEntityU1MMapMapping
extends TestReadAggregateEntityU1MMapMapping {
    protected OneToManyMapping mapping = null;
    private boolean usePrivateOwned = false;
    private boolean oldPrivateOwnedValue = false;
    protected AggregateEntityU1MMapHolder changedHolder = null;

    public TestUpdateAggregateEntityU1MMapMapping() {
    }

    public TestUpdateAggregateEntityU1MMapMapping(boolean usePrivateOwned) {
        this();
        this.usePrivateOwned = usePrivateOwned;
        this.setName("TestUpdateDirectEntity1MMapMapping privateOwned=" + usePrivateOwned);
    }

    @Override
    public void setup() {
        this.mapping = (OneToManyMapping)this.getSession().getProject().getDescriptor(AggregateEntityU1MMapHolder.class).getMappingForAttributeName("aggregateToEntityMap");
        this.oldPrivateOwnedValue = this.mapping.isPrivateOwned();
        this.mapping.setIsPrivateOwned(this.usePrivateOwned);
        super.setup();
    }

    @Override
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holders = uow.readAllObjects(AggregateEntityU1MMapHolder.class, this.holderExp);
        this.changedHolder = (AggregateEntityU1MMapHolder)this.holders.get(0);
        AggregateMapKey key = new AggregateMapKey();
        key.setKey(11);
        this.changedHolder.removeAggregateToEntityMapItem(key);
        EntityMapValue mapValue = new EntityMapValue();
        mapValue.setId(3);
        mapValue = (EntityMapValue)uow.registerObject((Object)mapValue);
        key = new AggregateMapKey();
        key.setKey(33);
        this.changedHolder.addAggregateToEntityMapItem(key, mapValue);
        uow.commit();
        Object holderForComparison = uow.readObject((Object)this.changedHolder);
        if (!this.compareObjects(this.changedHolder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
    }

    @Override
    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.holders = this.getSession().readAllObjects(AggregateEntityU1MMapHolder.class, this.holderExp);
        AggregateEntityU1MMapHolder holder = (AggregateEntityU1MMapHolder)this.holders.get(0);
        if (!this.compareObjects(holder, this.changedHolder)) {
            throw new TestErrorException("Objects do not match reinitialize");
        }
        AggregateMapKey key = new AggregateMapKey();
        key.setKey(11);
        if (holder.getAggregateToEntityMap().containsKey(key)) {
            throw new TestErrorException("Item that was removed is still present in map.");
        }
        key = new AggregateMapKey();
        key.setKey(33);
        EntityMapValue value = (EntityMapValue)holder.getAggregateToEntityMap().get(key);
        if (value.getId() != 3) {
            throw new TestErrorException("Item was not correctly added to map");
        }
        if (this.mapping.isPrivateOwned()) {
            ReadObjectQuery query = new ReadObjectQuery(EntityMapValue.class);
            ExpressionBuilder values = new ExpressionBuilder();
            Expression criteria = values.get("id").equal(1);
            query.setSelectionCriteria(criteria);
            value = (EntityMapValue)this.getSession().executeQuery((DatabaseQuery)query);
            if (value != null) {
                throw new TestErrorException("PrivateOwned EntityMapValue was not deleted.");
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mapping.setIsPrivateOwned(this.oldPrivateOwnedValue);
    }
}

