/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.ddlgeneration;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.Address;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.AggregateMapKey;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.AggregateMapValue;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.CKeyEntityA;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.CKeyEntityAPK;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.CKeyEntityB;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.CKeyEntityB2;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.CKeyEntityBPK;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.CKeyEntityC;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.CKeyEntityCPK;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.City;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.Comment;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.Country;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.Course;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.Employee;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.EntityMapKey;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.EntityMapValue;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.EntityMapValueWithBackPointer;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.Inventor;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.Lobtest;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.LobtestPK;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.MMEntityMapValue;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.MachineState;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.MapHolder;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.MapHolderEmbeddable;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.Money;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.Patent;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.PatentCollection;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.PatentInvestigation;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.PatentInvestigator;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.PropertyInfo;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.PropertyRecord;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.Purchase;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.State;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.ThreadInfo;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.UniqueConstraintsEntity1;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.UniqueConstraintsEntity2;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.Zip;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.ZipArea;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.Zipcode;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.Boss;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.Candidate;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.Capo;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.Contract;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.MafiaFamily;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.Mafioso;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.Mason;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.Party;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.Riding;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.Soldier;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.Supporter;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.Trowel;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.multitenant.Underboss;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.tableperclass.Car;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.tableperclass.CodeExample;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.tableperclass.Customer;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.tableperclass.DesignPattern;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.tableperclass.GoldBenefit;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.tableperclass.GoldCustomer;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.tableperclass.LuxuryCar;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.tableperclass.PlatinumBenefit;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.tableperclass.PlatinumCustomer;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.tableperclass.ProgrammingLanguage;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.weaving.Equipment;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.weaving.Port;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.weaving.impl.EquipmentDAO;
import org.eclipse.persistence.testing.models.jpa.ddlgeneration.weaving.impl.PortDAO;
import org.eclipse.persistence.testing.tests.jpa.ddlgeneration.DDLGenerationExtendTablesJUnitTestSuite;

public class DDLGenerationJUnitTestSuite
extends JUnitTestCase {
    protected static String DDL_PU = "ddlGeneration";
    private static final String DDL_TPT_PU = "ddlTablePerTenantGeneration";
    private static final String DDL_TPC_PU = "ddlTablePerClass";
    private static final String DDL_TABLE_CREATION_SUFFIX_PU = "ddlTableSuffix";
    private static final String DDL_TABLE_CREATION_SUFFIX_DDL_FILENAME = "createDDL_ddlTableSuffix.jdbc";
    public static int family707;
    public static int family007;
    public static List<Integer> family707Mafiosos;
    public static List<Integer> family707Contracts;
    public static List<Integer> family007Mafiosos;
    public static List<Integer> family007Contracts;

    public DDLGenerationJUnitTestSuite() {
    }

    public DDLGenerationJUnitTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("DDLGenerationExtendTablesJUnitTestSuite");
        suite.addTest((Test)new DDLGenerationExtendTablesJUnitTestSuite("testSetup"));
        ArrayList<String> tests = new ArrayList<String>();
        tests.add("testDDLTableCreationWithSuffix");
        tests.add("testDDLTablePerClassModel");
        tests.add("testDDLTablePerClassModelQuery");
        tests.add("testDDLPkConstraintErrorIncludingRelationTableColumnName");
        tests.add("testOptionalPrimaryKeyJoinColumnRelationship");
        tests.add("testPrimaryKeyJoinColumns");
        tests.add("testDDLEmbeddableMapKey");
        tests.add("testDDLAttributeOverrides");
        tests.add("testDDLAttributeOverridesOnElementCollection");
        tests.add("testDDLUniqueKeysAsJoinColumns");
        tests.add("testCreateMafiaFamily707");
        tests.add("testCreateMafiaFamily007");
        tests.add("testValidateMafiaFamily707");
        tests.add("testValidateMafiaFamily007");
        tests.add("testLazyBlob");
        tests.add("testSimpleSelectFoo");
        tests.add("testElementMapOnEmbedded");
        tests.add("testTablePerTenant");
        tests.add("testDDLUniqueConstraintsByAnnotations");
        tests.add("testDDLUniqueConstraintsByXML");
        tests.add("testDDLSubclassEmbeddedIdPkColumnsInJoinedStrategy");
        tests.add("testBug241308");
        tests.add("testDDLUnidirectionalOneToMany");
        tests.add("testCascadeMergeOnManagedEntityWithOrderedList");
        tests.add("testDirectCollectionMapping");
        tests.add("testAggregateCollectionMapping");
        tests.add("testOneToManyMapping");
        tests.add("testUnidirectionalOneToManyMapping");
        tests.add("testManyToManyMapping");
        tests.add("testManyToManyWithMultipleJoinColumns");
        tests.add("testEmbeddedManyToMany");
        tests.add("testEmbeddedOneToOne");
        tests.add("testAssociationOverrideToEmbeddedManyToMany");
        tests.add("testDeleteObjectWithEmbeddedManyToMany");
        tests.add("testTPCMappedKeyMapQuery");
        tests.add("testLAZYLOBWithEmbeddedId");
        tests.add("testBug386939");
        for (String test : tests) {
            suite.addTest((Test)new DDLGenerationExtendTablesJUnitTestSuite(test));
        }
        return suite;
    }

    public void testSetup() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.closeEntityManager(em);
        DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
        EntityManager emDDLTPC = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_TPC_PU);
        this.closeEntityManager(emDDLTPC);
        DDLGenerationJUnitTestSuite.clearCache((String)DDL_TPC_PU);
        EntityManager emDDLTPT = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_TPT_PU);
        this.closeEntityManager(emDDLTPT);
        DDLGenerationJUnitTestSuite.clearCache((String)DDL_TPT_PU);
    }

    public void testDDLTableCreationWithSuffix() {
        if (isOnServer.booleanValue()) {
            return;
        }
        String property_suffix = " propertyCreationSuffix";
        String xml_suffix = "creationSuffixString";
        String CREATE_TABLE = "CREATE TABLE ";
        ArrayList<String> statements = new ArrayList<String>();
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        boolean has_property_suffix = true;
        String property_statement = "";
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_TABLE_CREATION_SUFFIX_PU);
        List<String> strings = this.getDDLFile(DDL_TABLE_CREATION_SUFFIX_DDL_FILENAME);
        for (String statement : strings) {
            if (!statement.startsWith("CREATE TABLE ")) continue;
            if (!statement.endsWith(property_suffix)) {
                has_property_suffix = false;
                property_statement = statement;
            }
            if (statement.startsWith("CREATE TABLE DDL_SALARY")) {
                statements.add(statement);
                results.add(statement.contains(xml_suffix + "1"));
                continue;
            }
            if (statement.startsWith("CREATE TABLE DDL_RESPONS")) {
                statements.add(statement);
                results.add(statement.contains(xml_suffix + "2"));
                continue;
            }
            if (statement.startsWith("CREATE TABLE DDL_COMMENT")) {
                statements.add(statement);
                results.add(statement.contains(xml_suffix + "3"));
                continue;
            }
            if (!statement.startsWith("CREATE TABLE DDL_MANY_MANY")) continue;
            statements.add(statement);
            results.add(statement.contains(xml_suffix + "4"));
        }
        DDLGenerationJUnitTestSuite.assertTrue((String)("missing creation suffix from properties on statement: " + property_statement), (boolean)has_property_suffix);
        int size = statements.size();
        DDLGenerationJUnitTestSuite.assertTrue((String)("Missing some create Table statements, only got " + size + " of the 4 expected"), (size == 4 ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            DDLGenerationJUnitTestSuite.assertTrue((String)("missing creation suffix " + i + " from eclipselink-orm.xml on statement: " + (String)statements.get(i)), (boolean)((Boolean)results.get(i)));
        }
    }

    public void testDDLTablePerClassModel() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_TPC_PU);
        this.beginTransaction(em);
        GoldCustomer goldCustomer = new GoldCustomer();
        PlatinumCustomer platinumCustomer = new PlatinumCustomer();
        try {
            goldCustomer.setFullName("GoldCustomer");
            goldCustomer.setAge(Integer.valueOf(21));
            goldCustomer.setGender("Male");
            goldCustomer.setNationality("Canadian");
            em.persist((Object)goldCustomer);
            platinumCustomer.setFullName("PlatinumCustomer");
            platinumCustomer.setAge(Integer.valueOf(22));
            platinumCustomer.setGender("Female");
            platinumCustomer.setNationality("American");
            em.persist((Object)platinumCustomer);
            LuxuryCar luxuryCar1 = new LuxuryCar();
            em.persist((Object)luxuryCar1);
            GoldBenefit goldBenefit1 = new GoldBenefit();
            goldBenefit1.setBenefitDescription("Gold benefit 1");
            goldBenefit1.setLuxuryCar(luxuryCar1);
            goldBenefit1.setCustomer((Customer)goldCustomer);
            em.persist((Object)goldBenefit1);
            LuxuryCar luxuryCar2 = new LuxuryCar();
            em.persist((Object)luxuryCar2);
            GoldBenefit goldBenefit2 = new GoldBenefit();
            goldBenefit2.setBenefitDescription("Gold benefit 2");
            goldBenefit2.setLuxuryCar(luxuryCar2);
            em.persist((Object)goldBenefit2);
            LuxuryCar luxuryCar3 = new LuxuryCar();
            em.persist((Object)luxuryCar3);
            PlatinumBenefit platinumBenefit1 = new PlatinumBenefit();
            platinumBenefit1.setBenefitDescription("Platinum benefit 1");
            platinumBenefit1.setCar((Car)luxuryCar3);
            em.persist((Object)platinumBenefit1);
            ArrayList goldBenefits1 = new ArrayList();
            ArrayList goldBenefits2 = new ArrayList();
            ArrayList platinumBenefits1 = new ArrayList();
            goldCustomer.setGoldBenefitList(goldBenefits1);
            platinumCustomer.setGoldBenefitList(goldBenefits2);
            platinumCustomer.setPlatinumBenefitList(platinumBenefits1);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
        DDLGenerationJUnitTestSuite.clearCache((String)DDL_TPC_PU);
        em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_TPC_PU);
        DDLGenerationJUnitTestSuite.assertTrue((String)"ReadAll did not find subclasses.", (!em.createQuery("Select c from Customer c").getResultList().isEmpty() ? 1 : 0) != 0);
        GoldCustomer refreshedGoldCustomer = (GoldCustomer)em.find(GoldCustomer.class, (Object)goldCustomer.getCustomerId());
        DDLGenerationJUnitTestSuite.assertTrue((String)"The gold customer read back did not match the original", (boolean)DDLGenerationJUnitTestSuite.getServerSession((String)DDL_TPC_PU).compareObjects((Object)goldCustomer, (Object)refreshedGoldCustomer));
        PlatinumCustomer refreshedPlatinumCustomer = (PlatinumCustomer)em.find(PlatinumCustomer.class, (Object)platinumCustomer.getCustomerId());
        DDLGenerationJUnitTestSuite.assertTrue((String)"The platinum customer read back did not match the original", (boolean)DDLGenerationJUnitTestSuite.getServerSession((String)DDL_TPC_PU).compareObjects((Object)platinumCustomer, (Object)refreshedPlatinumCustomer));
    }

    public void testDDLTablePerClassModelQuery() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_TPC_PU);
        List goldCustomers = em.createNamedQuery("GoldCustomer.findAll").getResultList();
        List platinumCustomers = em.createNamedQuery("PlatinumCustomer.findAll").getResultList();
        DDLGenerationJUnitTestSuite.assertFalse((String)"No gold customers returned", (boolean)goldCustomers.isEmpty());
        DDLGenerationJUnitTestSuite.assertFalse((String)"No platinum customers returned", (boolean)platinumCustomers.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDDLPkConstraintErrorIncludingRelationTableColumnName() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            CKeyEntityC c = new CKeyEntityC(new CKeyEntityCPK("Manager"));
            em.persist((Object)c);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            DDLGenerationJUnitTestSuite.fail((String)("DDL generation may generate wrong Primary Key constraint, thrown:" + e));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptionalPrimaryKeyJoinColumnRelationship() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            em.persist((Object)new Course());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            DDLGenerationJUnitTestSuite.fail((String)("Error persisting new course without material failed : " + e));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrimaryKeyJoinColumns() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            Country country = new Country();
            country.setName("USA");
            country.setIsoCode("840");
            State state = new State();
            state.setCountry(country);
            state.setIsoCode("36");
            state.setName("New York");
            HashSet<State> states = new HashSet<State>();
            states.add(state);
            country.setStates(states);
            City city = new City();
            city.setName("Rochester");
            city.setState(state);
            HashSet<City> cities = new HashSet<City>();
            cities.add(city);
            state.setCities(cities);
            ZipArea zipArea = new ZipArea();
            zipArea.setCity(city);
            HashSet<ZipArea> zipAreas = new HashSet<ZipArea>();
            zipAreas.add(zipArea);
            city.setZipAreas(zipAreas);
            Zip zip = new Zip();
            zip.setCode("14621");
            zip.setCountry(country);
            zip.setZipAreas(zipAreas);
            zipArea.setZip(zip);
            HashSet zips = new HashSet();
            country.setZips(zips);
            em.persist((Object)country);
            em.persist((Object)state);
            em.persist((Object)city);
            em.persist((Object)zipArea);
            em.persist((Object)zip);
            em.flush();
        }
        catch (RuntimeException e) {
            DDLGenerationJUnitTestSuite.fail((String)("Error persisting new country with city, states and zips : " + e));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDDLEmbeddableMapKey() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            PropertyRecord propertyRecord = new PropertyRecord();
            Zipcode zipCode = new Zipcode();
            zipCode.plusFour = "1234";
            zipCode.zip = "78627";
            Address address = new Address();
            address.city = "Ottawa";
            address.state = "Ontario";
            address.street = "Main";
            address.zipcode = zipCode;
            PropertyInfo propertyInfo = new PropertyInfo();
            propertyInfo.parcelNumber = 1;
            propertyInfo.size = 2;
            propertyInfo.tax = new BigDecimal(10);
            propertyRecord.propertyInfos.put(address, propertyInfo);
            em.persist((Object)propertyRecord);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            DDLGenerationJUnitTestSuite.fail((String)("Error persisting the PropertyRecord : " + e));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDDLAttributeOverrides() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        RuntimeException expectedException = null;
        try {
            Purchase purchase = new Purchase();
            purchase.setFee(new Money());
            em.persist((Object)purchase);
            em.flush();
        }
        catch (RuntimeException e) {
            expectedException = e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        DDLGenerationJUnitTestSuite.assertNotNull((String)"Expected an exception persisting null into a field with nullable=false set on an override", (Object)expectedException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDDLAttributeOverridesOnElementCollection() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        RuntimeException expectedException = null;
        try {
            PropertyRecord propertyRecord = new PropertyRecord();
            Zipcode zipCode = new Zipcode();
            zipCode.plusFour = "1234";
            zipCode.zip = "78627";
            Address address = new Address();
            address.city = "Ottawa";
            address.state = "Ontario";
            address.street = "Main";
            address.zipcode = zipCode;
            PropertyInfo propertyInfo = new PropertyInfo();
            propertyInfo.size = 2;
            propertyInfo.tax = new BigDecimal(10);
            propertyRecord.propertyInfos.put(address, propertyInfo);
            em.persist((Object)propertyRecord);
            em.flush();
        }
        catch (RuntimeException e) {
            expectedException = e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        DDLGenerationJUnitTestSuite.assertNotNull((String)"Expected an exception persisting null into a field with nullable=false set on an override", (Object)expectedException);
    }

    public void testDDLUniqueKeysAsJoinColumns() {
        CKeyEntityBPK bKey;
        CKeyEntityAPK aKey;
        CKeyEntityA a;
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            a = new CKeyEntityA("Wonseok", "Kim");
            int seq = (int)System.currentTimeMillis();
            CKeyEntityB b = new CKeyEntityB(new CKeyEntityBPK((long)seq, "B1209"));
            b.setUnq1("u0001");
            b.setUnq2("u0002");
            a.setUniqueB(b);
            b.setUniqueA(a);
            em.persist((Object)a);
            em.persist((Object)b);
            this.commitTransaction(em);
            aKey = a.getKey();
            bKey = b.getKey();
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
        em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            a = (CKeyEntityA)em.find(CKeyEntityA.class, (Object)aKey);
            DDLGenerationJUnitTestSuite.assertNotNull((Object)a);
            CKeyEntityB b = a.getUniqueB();
            DDLGenerationJUnitTestSuite.assertNotNull((Object)b);
            DDLGenerationJUnitTestSuite.assertEquals((String)b.getUnq1(), (String)"u0001");
            DDLGenerationJUnitTestSuite.assertEquals((String)b.getUnq2(), (String)"u0002");
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
        em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            CKeyEntityB b = (CKeyEntityB)em.find(CKeyEntityB.class, (Object)bKey);
            DDLGenerationJUnitTestSuite.assertNotNull((Object)b);
            CKeyEntityA a2 = b.getUniqueA();
            DDLGenerationJUnitTestSuite.assertNotNull((Object)a2);
            DDLGenerationJUnitTestSuite.assertEquals((Object)a2.getKey(), (Object)aKey);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDDLUniqueConstraintsByAnnotations() {
        UniqueConstraintsEntity1 ucEntity;
        if (!DDLGenerationJUnitTestSuite.getServerSession((String)DDL_PU).getPlatform().supportsUniqueKeyConstraints() || DDLGenerationJUnitTestSuite.getServerSession((String)DDL_PU).getPlatform().isSybase()) {
            return;
        }
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            ucEntity = (UniqueConstraintsEntity1)em.find(UniqueConstraintsEntity1.class, (Object)1);
            if (ucEntity == null) {
                ucEntity = new UniqueConstraintsEntity1(Integer.valueOf(1));
                ucEntity.setColumns(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1));
                em.persist((Object)ucEntity);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.beginTransaction(em);
        try {
            ucEntity = new UniqueConstraintsEntity1(Integer.valueOf(2));
            ucEntity.setColumns(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(2));
            em.persist((Object)ucEntity);
            em.flush();
            DDLGenerationJUnitTestSuite.fail((String)"Unique constraint violation is expected");
        }
        catch (PersistenceException e) {
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            ucEntity = new UniqueConstraintsEntity1(Integer.valueOf(2));
            ucEntity.setColumns(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(2));
            em.persist((Object)ucEntity);
            em.flush();
            DDLGenerationJUnitTestSuite.fail((String)"Unique constraint violation is expected");
        }
        catch (PersistenceException e) {
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            ucEntity = new UniqueConstraintsEntity1(Integer.valueOf(2));
            ucEntity.setColumns(Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
            em.persist((Object)ucEntity);
            em.flush();
            DDLGenerationJUnitTestSuite.fail((String)"Unique constraint violation is expected");
        }
        catch (PersistenceException e) {
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            ucEntity = new UniqueConstraintsEntity1(Integer.valueOf(2));
            ucEntity.setColumns(Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(2));
            em.persist((Object)ucEntity);
            em.flush();
        }
        catch (PersistenceException e) {
            DDLGenerationJUnitTestSuite.fail((String)("Unique constraint violation is not expected, thrown:" + (Object)((Object)e)));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDDLUniqueConstraintsByXML() {
        UniqueConstraintsEntity2 ucEntity;
        if (!DDLGenerationJUnitTestSuite.getServerSession((String)DDL_PU).getPlatform().supportsUniqueKeyConstraints() || DDLGenerationJUnitTestSuite.getServerSession((String)DDL_PU).getPlatform().isSybase()) {
            return;
        }
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            ucEntity = (UniqueConstraintsEntity2)em.find(UniqueConstraintsEntity2.class, (Object)1);
            if (ucEntity == null) {
                ucEntity = new UniqueConstraintsEntity2(Integer.valueOf(1));
                ucEntity.setColumns(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1));
                em.persist((Object)ucEntity);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.beginTransaction(em);
        try {
            ucEntity = new UniqueConstraintsEntity2(Integer.valueOf(2));
            ucEntity.setColumns(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(2));
            em.persist((Object)ucEntity);
            em.flush();
            DDLGenerationJUnitTestSuite.fail((String)"Unique constraint violation is expected");
        }
        catch (PersistenceException e) {
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            ucEntity = new UniqueConstraintsEntity2(Integer.valueOf(2));
            ucEntity.setColumns(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(2));
            em.persist((Object)ucEntity);
            em.flush();
            DDLGenerationJUnitTestSuite.fail((String)"Unique constraint violation is expected");
        }
        catch (PersistenceException e) {
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            ucEntity = new UniqueConstraintsEntity2(Integer.valueOf(2));
            ucEntity.setColumns(Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(1));
            em.persist((Object)ucEntity);
            em.flush();
            DDLGenerationJUnitTestSuite.fail((String)"Unique constraint violation is expected");
        }
        catch (PersistenceException e) {
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            ucEntity = new UniqueConstraintsEntity2(Integer.valueOf(2));
            ucEntity.setColumns(Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(2));
            em.persist((Object)ucEntity);
            em.flush();
        }
        catch (PersistenceException e) {
            DDLGenerationJUnitTestSuite.fail((String)("Unique constraint violation is not expected, thrown:" + (Object)((Object)e)));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testDDLSubclassEmbeddedIdPkColumnsInJoinedStrategy() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            int seq = (int)System.currentTimeMillis();
            String code = "B1215";
            CKeyEntityB2 b = new CKeyEntityB2(new CKeyEntityBPK((long)seq, code));
            b.setUnq1(String.valueOf(seq));
            b.setUnq2(String.valueOf(seq));
            em.persist((Object)b);
            em.flush();
            String query = "SELECT b FROM CKeyEntityB2 b WHERE b.key.seq = :seq AND b.key.code = :code";
            Object result = em.createQuery(query).setParameter("seq", (Object)seq).setParameter("code", (Object)code).getSingleResult();
            DDLGenerationJUnitTestSuite.assertNotNull((Object)result);
            this.rollbackTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testBug241308() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            ThreadInfo threadInfo1 = new ThreadInfo();
            threadInfo1.setId(0L);
            threadInfo1.setName("main");
            MachineState machineState1 = new MachineState();
            machineState1.setId(0L);
            machineState1.setThread(threadInfo1);
            em.persist((Object)machineState1);
            ThreadInfo threadInfo2 = new ThreadInfo();
            threadInfo2.setId(0L);
            threadInfo2.setName("main");
            MachineState machineState2 = new MachineState();
            machineState2.setId(1L);
            machineState2.setThread(threadInfo2);
            em.persist((Object)machineState2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testDDLUnidirectionalOneToMany() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        try {
            long seq = System.currentTimeMillis();
            CKeyEntityB b = new CKeyEntityB(new CKeyEntityBPK(seq, "B1210"));
            ArrayList<Comment> comments = new ArrayList<Comment>(2);
            comments.add(new Comment("comment 1"));
            comments.add(new Comment("comment 2"));
            b.setComments(comments);
            b.setUnq1("u0003");
            b.setUnq2("u0004");
            em.persist((Object)b);
            this.commitTransaction(em);
            this.beginTransaction(em);
            CKeyEntityB b0 = (CKeyEntityB)em.find(CKeyEntityB.class, (Object)b.getKey());
            em.remove(b0.getComments().get(0));
            em.remove(b0.getComments().get(1));
            em.remove((Object)b0);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testCascadeMergeOnManagedEntityWithOrderedList() {
        EntityManagerFactory factory = DDLGenerationJUnitTestSuite.getEntityManagerFactory((String)DDL_PU);
        this.cleanupEquipmentAndPorts(factory);
        this.createEquipment(factory);
        this.addPorts(factory);
        this.verifyPorts(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDirectCollectionMapping() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.beginTransaction(em);
            MapHolder holder = new MapHolder();
            holder.setId(1);
            EntityMapKey key = new EntityMapKey();
            key.setId(1);
            holder.getDCMap().put(key, "test1");
            em.persist((Object)holder);
            em.persist((Object)key);
            try {
                em.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                DDLGenerationJUnitTestSuite.fail((String)("Caught Exception while trying to flush a new ddl-generated DirectCollectionMapping." + e));
            }
            DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
            em.refresh((Object)holder);
            DDLGenerationJUnitTestSuite.assertTrue((holder.getDCMap().get(key) != null ? 1 : 0) != 0);
            holder.getDCMap().remove(key);
            em.remove((Object)holder);
            em.remove((Object)key);
            em.flush();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAggregateCollectionMapping() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.beginTransaction(em);
            MapHolder holder = new MapHolder();
            holder.setId(2);
            EntityMapKey key = new EntityMapKey();
            key.setId(2);
            AggregateMapValue value = new AggregateMapValue();
            value.setDescription("test2");
            holder.getACMap().put(key, value);
            em.persist((Object)holder);
            em.persist((Object)key);
            em.flush();
            DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
            em.refresh((Object)holder);
            DDLGenerationJUnitTestSuite.assertTrue((holder.getACMap().get(key) != null ? 1 : 0) != 0);
            holder.getACMap().remove(key);
            em.remove((Object)holder);
            em.remove((Object)key);
            em.flush();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneToManyMapping() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.beginTransaction(em);
            MapHolder holder = new MapHolder();
            holder.setId(3);
            AggregateMapKey key = new AggregateMapKey();
            key.setDescription("test3");
            EntityMapValueWithBackPointer value = new EntityMapValueWithBackPointer();
            value.setHolder(holder);
            value.setId(3);
            holder.getOTMMap().put(key, value);
            em.persist((Object)holder);
            em.persist((Object)value);
            em.flush();
            DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
            em.refresh((Object)holder);
            holder.getOTMMap().get(key);
            DDLGenerationJUnitTestSuite.assertTrue((holder.getOTMMap().get(key) != null ? 1 : 0) != 0);
            holder.getOTMMap().remove(key);
            value.setHolder(null);
            em.remove((Object)holder);
            em.remove((Object)value);
            em.flush();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnidirectionalOneToManyMapping() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.beginTransaction(em);
            MapHolder holder = new MapHolder();
            holder.setId(4);
            EntityMapValue value = new EntityMapValue();
            value.setId(4);
            holder.getUOTMMap().put(4, value);
            em.persist((Object)holder);
            em.persist((Object)value);
            em.flush();
            DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
            em.refresh((Object)holder);
            DDLGenerationJUnitTestSuite.assertTrue((holder.getUOTMMap().get(4) != null ? 1 : 0) != 0);
            holder.getUOTMMap().remove(4);
            em.remove((Object)holder);
            em.remove((Object)value);
            em.flush();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManyToManyMapping() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.beginTransaction(em);
            MapHolder holder = new MapHolder();
            holder.setId(5);
            EntityMapKey key = new EntityMapKey();
            key.setId(5);
            MMEntityMapValue value = new MMEntityMapValue();
            value.getHolders().add(holder);
            value.setId(5);
            holder.getMTMMap().put(key, value);
            em.persist((Object)holder);
            em.persist((Object)key);
            em.persist((Object)value);
            em.flush();
            DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
            em.refresh((Object)holder);
            DDLGenerationJUnitTestSuite.assertTrue((holder.getMTMMap().get(key) != null ? 1 : 0) != 0);
            holder.getMTMMap().remove(key);
            value.getHolders().remove(0);
            em.remove((Object)holder);
            em.remove((Object)key);
            em.remove((Object)value);
            try {
                em.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                DDLGenerationJUnitTestSuite.fail((String)("Caught Exception while trying to remove a new ddl-generated OneToManyMapping." + e));
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testManyToManyWithMultipleJoinColumns() {
        String prefix = "testManyToManyWithMultipleJoinColumns";
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        this.beginTransaction(em);
        CKeyEntityC c1 = new CKeyEntityC(new CKeyEntityCPK(prefix + "_1"));
        c1.setTempRole(prefix + "_1_Role");
        em.persist((Object)c1);
        em.flush();
        CKeyEntityCPK c1KeyPK = c1.getKey();
        ArrayList<CKeyEntityB> bs1 = new ArrayList<CKeyEntityB>();
        CKeyEntityBPK b1KeyPK = new CKeyEntityBPK((long)c1KeyPK.seq, c1KeyPK.role);
        CKeyEntityB b1 = new CKeyEntityB(b1KeyPK);
        b1.setUnq1(prefix + "_1_1");
        b1.setUnq2(prefix + "_1_2");
        bs1.add(b1);
        c1.setBs(bs1);
        em.persist((Object)b1);
        CKeyEntityC c2 = new CKeyEntityC(new CKeyEntityCPK(prefix + "_2"));
        c2.setTempRole(prefix + "_2_Role");
        CKeyEntityCPK c2KeyPK = c2.getKey();
        c2KeyPK.seq = c1KeyPK.seq;
        ArrayList<CKeyEntityB> bs2 = new ArrayList<CKeyEntityB>();
        CKeyEntityBPK b2KeyPK = new CKeyEntityBPK((long)c2KeyPK.seq, c2KeyPK.role);
        CKeyEntityB b2 = new CKeyEntityB(b2KeyPK);
        b2.setUnq1(prefix + "_2_1");
        b2.setUnq2(prefix + "_2_2");
        bs2.add(b2);
        c2.setBs(bs2);
        em.persist((Object)c2);
        em.persist((Object)b2);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
        em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        List clist = em.createQuery("SELECT c from CKeyEntityC c LEFT OUTER JOIN c.bs bs WHERE c.key = :key").setParameter("key", (Object)c1KeyPK).getResultList();
        String errorMsg = "";
        int nSize = clist.size();
        if (nSize != 1) {
            errorMsg = nSize == 2 ? (clist.get(0) != clist.get(1) ? "Read 2 cs, but they are not identical - test problem." : "Read 2 identical cs instead of one - likely the second on clause was incomplete") : "Read " + nSize + " cs, 1 or 2 were expected - test problem.";
        }
        this.beginTransaction(em);
        c1 = (CKeyEntityC)em.find(CKeyEntityC.class, (Object)c1KeyPK);
        c1.getBs().clear();
        em.remove((Object)c1);
        c2 = (CKeyEntityC)em.find(CKeyEntityC.class, (Object)c2KeyPK);
        c2.getBs().clear();
        em.remove((Object)c2);
        b1 = (CKeyEntityB)em.find(CKeyEntityB.class, (Object)b1KeyPK);
        em.remove((Object)b1);
        b2 = (CKeyEntityB)em.find(CKeyEntityB.class, (Object)b2KeyPK);
        em.remove((Object)b2);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        if (errorMsg.length() > 0) {
            DDLGenerationJUnitTestSuite.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmbeddedManyToMany() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.beginTransaction(em);
            Inventor inventor = new Inventor();
            inventor.setId(1);
            Patent patent = new Patent();
            patent.setId(1);
            PatentCollection patents = new PatentCollection();
            patents.getPatents().add(patent);
            inventor.setPatentCollection(patents);
            em.persist((Object)inventor);
            em.persist((Object)patent);
            em.flush();
            em.clear();
            DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
            inventor = (Inventor)em.find(Inventor.class, (Object)1);
            DDLGenerationJUnitTestSuite.assertTrue((String)"Embeddable is null", (inventor.getPatentCollection() != null ? 1 : 0) != 0);
            DDLGenerationJUnitTestSuite.assertFalse((String)"Collection is empty", (boolean)inventor.getPatentCollection().getPatents().isEmpty());
            DDLGenerationJUnitTestSuite.assertTrue((String)"Target is incorrect", (((Patent)inventor.getPatentCollection().getPatents().get(0)).getId() == 1 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmbeddedOneToOne() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.beginTransaction(em);
            PatentInvestigator investigator = new PatentInvestigator();
            investigator.setId(1);
            Patent lastPatent = new Patent();
            lastPatent.setId(1);
            investigator.setLastCompleted(new PatentInvestigation("Last", lastPatent));
            em.persist((Object)investigator);
            em.persist((Object)lastPatent);
            em.flush();
            em.clear();
            PatentInvestigator investigatorRead = (PatentInvestigator)em.find(PatentInvestigator.class, (Object)investigator.getId());
            DDLGenerationJUnitTestSuite.assertTrue((String)"investigatorRead.getLast() == null", (investigatorRead.getLast() != null ? 1 : 0) != 0);
            DDLGenerationJUnitTestSuite.assertTrue((String)"investigatorRead.getLast.getPatent() == null", (investigatorRead.getLast().getPatent() != null ? 1 : 0) != 0);
            DDLGenerationJUnitTestSuite.assertTrue((String)"investigatorRead.getLast.getPatent().getId() is incorrect", (investigatorRead.getLast().getPatent().getId() == lastPatent.getId() ? 1 : 0) != 0);
            DDLGenerationJUnitTestSuite.assertTrue((String)"investigatorRead.getCurrent() != null", (investigatorRead.getCurrent() == null ? 1 : 0) != 0);
            DDLGenerationJUnitTestSuite.assertTrue((String)"investigatorRead.getNext() != null", (investigatorRead.getNext() == null ? 1 : 0) != 0);
            Patent currentPatent = new Patent();
            currentPatent.setId(2);
            em.persist((Object)currentPatent);
            em.flush();
            em.createNativeQuery("UPDATE " + ((ServerSession)em.unwrap(ServerSession.class)).getDescriptor(PatentInvestigator.class).getDefaultTable().getName() + " SET CURRENT_DESRIPTION = 'Current', CURRENT_PATENT = " + currentPatent.getId() + " WHERE ID = " + investigator.getId()).executeUpdate();
            em.refresh((Object)investigatorRead);
            DDLGenerationJUnitTestSuite.assertTrue((String)"after refresh investigatorRead.getLast() == null", (investigatorRead.getLast() != null ? 1 : 0) != 0);
            DDLGenerationJUnitTestSuite.assertTrue((String)"after refresh investigatorRead.getLast.getPatent() == null", (investigatorRead.getLast().getPatent() != null ? 1 : 0) != 0);
            DDLGenerationJUnitTestSuite.assertTrue((String)"after refresh investigatorRead.getLast.getPatent().getId() is incorrect", (investigatorRead.getLast().getPatent().getId() == lastPatent.getId() ? 1 : 0) != 0);
            DDLGenerationJUnitTestSuite.assertTrue((String)"after refresh investigatorRead.getCurrent() == null", (investigatorRead.getCurrent() != null ? 1 : 0) != 0);
            DDLGenerationJUnitTestSuite.assertTrue((String)"after refresh investigatorRead.getCurrent.getPatent() == null", (investigatorRead.getCurrent().getPatent() != null ? 1 : 0) != 0);
            DDLGenerationJUnitTestSuite.assertTrue((String)"after refresh investigatorRead.getCurrent.getPatent().getId() is incorrect", (investigatorRead.getCurrent().getPatent().getId() == currentPatent.getId() ? 1 : 0) != 0);
            DDLGenerationJUnitTestSuite.assertTrue((String)"after refresh investigatorRead.getNext() != null", (investigatorRead.getNext() == null ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssociationOverrideToEmbeddedManyToMany() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.beginTransaction(em);
            Employee employee = new Employee();
            PhoneNumber phoneNumber = new PhoneNumber();
            employee.addPhoneNumber(phoneNumber);
            em.persist((Object)employee);
            this.commitTransaction(em);
            DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
            em.clear();
            DDLGenerationJUnitTestSuite.assertNotNull((String)"Unable to read back the phone number", (Object)em.find(PhoneNumber.class, (Object)phoneNumber.getNumber()));
        }
        catch (Exception e) {
            DDLGenerationJUnitTestSuite.fail((String)("An error occurred: " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteObjectWithEmbeddedManyToMany() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.beginTransaction(em);
            Employee employee = new Employee();
            employee.addPhoneNumber(new PhoneNumber());
            employee.addComment(new Comment());
            employee.addUpdate("Update record 1");
            em.persist((Object)employee);
            this.commitTransaction(em);
            this.beginTransaction(em);
            Employee emp = (Employee)em.find(Employee.class, (Object)employee.getId());
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            DDLGenerationJUnitTestSuite.fail((String)("An error occurred: " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    protected void cleanupEquipmentAndPorts(EntityManagerFactory factory) {
        try (EntityManager em = null;){
            em = factory.createEntityManager();
            this.beginTransaction(em);
            em.createQuery("DELETE FROM PortDAO").executeUpdate();
            em.createQuery("DELETE FROM EquipmentDAO").executeUpdate();
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createEquipment(EntityManagerFactory factory) {
        try (EntityManager em = null;){
            em = factory.createEntityManager();
            this.beginTransaction(em);
            EquipmentDAO eq = new EquipmentDAO();
            eq.setId("eq");
            PortDAO port = new PortDAO();
            port.setId("p1");
            port.setPortOrder(0);
            eq.addPort((Port)port);
            em.persist((Object)eq);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPorts(EntityManagerFactory factory) {
        try (EntityManager em = null;){
            em = factory.createEntityManager();
            this.beginTransaction(em);
            Query query = em.createNamedQuery("Equipment.findEquipmentById");
            query.setParameter("id", (Object)"eq");
            Equipment eq = (Equipment)query.getResultList().get(0);
            this.commitTransaction(em);
            em = factory.createEntityManager();
            this.beginTransaction(em);
            eq = (Equipment)em.merge((Object)eq);
            PortDAO port = new PortDAO();
            port.setId("p2");
            port.setPortOrder(1);
            eq.addPort((Port)port);
            port = new PortDAO();
            port.setId("p3");
            port.setPortOrder(2);
            eq.addPort((Port)port);
            eq = (Equipment)em.merge((Object)eq);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyPorts(EntityManagerFactory factory) {
        try (EntityManager em = null;){
            em = factory.createEntityManager();
            this.beginTransaction(em);
            Query query = em.createNamedQuery("Equipment.findEquipmentById");
            query.setParameter("id", (Object)"eq");
            Equipment eq = (Equipment)query.getResultList().get(0);
            this.commitTransaction(em);
            for (Port port : eq.getPorts()) {
                if (port != null) continue;
                DDLGenerationJUnitTestSuite.fail((String)"A null PORT was found in the collection of ports.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDDLFile(String fileName) {
        ArrayList<String> array = new ArrayList<String>();
        InputStream fileStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
        if (fileStream == null) {
            File file = new File(fileName);
            try {
                fileStream = new FileInputStream(file);
            }
            catch (FileNotFoundException exception) {
                DDLGenerationJUnitTestSuite.warning((String)("cannot load file " + fileName + " due to error: " + exception));
                throw ValidationException.fatalErrorOccurred((Exception)exception);
            }
        }
        InputStreamReader reader = null;
        BufferedReader buffReader = null;
        try {
            try {
                reader = new InputStreamReader(fileStream, "UTF-8");
            }
            catch (UnsupportedEncodingException exception) {
                throw ValidationException.fatalErrorOccurred((Exception)exception);
            }
            buffReader = new BufferedReader(reader);
            boolean go = true;
            while (go) {
                String line = buffReader.readLine();
                if (line == null) {
                    go = false;
                    continue;
                }
                array.add(line);
            }
        }
        catch (Exception e) {
            try {
                if (buffReader != null) {
                    buffReader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException exception) {
                throw ValidationException.fileError((IOException)exception);
            }
        }
        finally {
            try {
                if (buffReader != null) {
                    buffReader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException exception) {
                throw ValidationException.fileError((IOException)exception);
            }
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTPCMappedKeyMapQuery() {
        if (!DDLGenerationJUnitTestSuite.isJPA10()) {
            EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_TPC_PU);
            try {
                this.beginTransaction(em);
                ProgrammingLanguage java = new ProgrammingLanguage();
                java.setName("Java");
                DesignPattern designPattern = new DesignPattern();
                designPattern.setName("Singleton");
                CodeExample codeExample = new CodeExample();
                codeExample.setContent("...");
                designPattern.getCodeExamples().put(java, codeExample);
                em.persist((Object)java);
                em.persist((Object)designPattern);
                this.commitTransaction(em);
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                DDLGenerationJUnitTestSuite.fail((String)("Error persisting the PropertyRecord : " + e));
            }
            finally {
                this.closeEntityManager(em);
            }
            DDLGenerationJUnitTestSuite.clearCache((String)DDL_TPC_PU);
            em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_TPC_PU);
            TypedQuery query = em.createQuery("SELECT x FROM DesignPattern x", DesignPattern.class);
            List resultList = query.getResultList();
            DDLGenerationJUnitTestSuite.assertEquals((String)"Unexpected number of design patterns returned", (int)1, (int)resultList.size());
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLAZYLOBWithEmbeddedId() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        LobtestPK pk = new LobtestPK();
        try {
            this.beginTransaction(em);
            Lobtest lobtest = new Lobtest();
            Byte b1 = new Byte("1");
            Byte b2 = new Byte("2");
            lobtest.setContentdata(new byte[]{b1, b2});
            lobtest.setUuid("123456789");
            pk.setDocid("blah");
            pk.setVersionid(new BigInteger(new Long(System.currentTimeMillis()).toString()));
            lobtest.setLobtestPK(pk);
            em.persist((Object)lobtest);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            DDLGenerationJUnitTestSuite.fail((String)("Error persisting the lobtest : " + e));
        }
        finally {
            this.closeEntityManager(em);
        }
        DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
        em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        Lobtest refreshedLobtest = (Lobtest)em.find(Lobtest.class, (Object)pk);
        DDLGenerationJUnitTestSuite.assertNotNull((String)"The query returned nothing: ", (Object)refreshedLobtest);
        DDLGenerationJUnitTestSuite.assertNotNull((String)"Doc id from Lobtest was null", (Object)refreshedLobtest.getLobtestPK().getDocid());
        DDLGenerationJUnitTestSuite.assertNotNull((String)"Version id from Lobtest was null", (Object)refreshedLobtest.getLobtestPK().getVersionid());
        this.closeEntityManager(em);
    }

    public void testCreateMafiaFamily707() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.beginTransaction(em);
            em.setProperty("tenant.id", (Object)"707");
            em.setProperty("eclipselink.tenant-id", (Object)"707");
            MafiaFamily family = new MafiaFamily();
            family.setName("Gonzo");
            family.setRevenue(Double.valueOf(1.0E7));
            family.addTag("firstTag");
            family.addTag("secondTag");
            family.addTag("thirdTag");
            Boss boss = new Boss();
            boss.setFirstName("707");
            boss.setLastName("Boss");
            boss.setGender(Mafioso.Gender.Male);
            Underboss underboss = new Underboss();
            underboss.setFirstName("Under");
            underboss.setLastName("Boss");
            underboss.setGender(Mafioso.Gender.Male);
            Capo capo1 = new Capo();
            capo1.setFirstName("Capo");
            capo1.setLastName("Giggaloo");
            capo1.setGender(Mafioso.Gender.Female);
            Capo capo2 = new Capo();
            capo2.setFirstName("Capo");
            capo2.setLastName("CrazyGlue");
            capo2.setGender(Mafioso.Gender.Male);
            Soldier soldier1 = new Soldier();
            soldier1.setFirstName("Soldier");
            soldier1.setLastName("One");
            soldier1.setGender(Mafioso.Gender.Female);
            Soldier soldier2 = new Soldier();
            soldier2.setFirstName("Soldier");
            soldier2.setLastName("Two");
            soldier2.setGender(Mafioso.Gender.Male);
            Soldier soldier3 = new Soldier();
            soldier3.setFirstName("Soldier");
            soldier3.setLastName("Three");
            soldier3.setGender(Mafioso.Gender.Male);
            Soldier soldier4 = new Soldier();
            soldier4.setFirstName("Soldier");
            soldier4.setLastName("Four");
            soldier4.setGender(Mafioso.Gender.Male);
            Soldier soldier5 = new Soldier();
            soldier5.setFirstName("Soldier");
            soldier5.setLastName("Four");
            soldier5.setGender(Mafioso.Gender.Female);
            Contract contract1 = new Contract();
            contract1.setDescription("Whack 007 family boss");
            Contract contract2 = new Contract();
            contract2.setDescription("Acquire fully-automatic guns");
            Contract contract3 = new Contract();
            contract3.setDescription("Steal some money");
            contract1.addSoldier(soldier1);
            contract1.addSoldier(soldier5);
            contract2.addSoldier(soldier1);
            contract2.addSoldier(soldier3);
            contract2.addSoldier(soldier5);
            contract3.addSoldier(soldier2);
            contract3.addSoldier(soldier3);
            contract3.addSoldier(soldier4);
            contract3.addSoldier(soldier5);
            boss.setUnderboss(underboss);
            capo1.setUnderboss(underboss);
            capo2.setUnderboss(underboss);
            capo1.addSoldier(soldier1);
            capo1.addSoldier(soldier2);
            capo2.addSoldier(soldier3);
            capo2.addSoldier(soldier4);
            capo2.addSoldier(soldier5);
            underboss.addCapo(capo1);
            underboss.addCapo(capo2);
            family.addMafioso((Mafioso)boss);
            family.addMafioso((Mafioso)underboss);
            family.addMafioso((Mafioso)capo1);
            family.addMafioso((Mafioso)capo2);
            family.addMafioso((Mafioso)soldier1);
            family.addMafioso((Mafioso)soldier2);
            family.addMafioso((Mafioso)soldier3);
            family.addMafioso((Mafioso)soldier4);
            family.addMafioso((Mafioso)soldier5);
            em.persist((Object)family);
            family707 = family.getId();
            family707Mafiosos = new ArrayList<Integer>();
            family707Mafiosos.add(boss.getId());
            family707Mafiosos.add(underboss.getId());
            family707Mafiosos.add(capo1.getId());
            family707Mafiosos.add(capo2.getId());
            family707Mafiosos.add(soldier1.getId());
            family707Mafiosos.add(soldier2.getId());
            family707Mafiosos.add(soldier3.getId());
            family707Mafiosos.add(soldier4.getId());
            family707Mafiosos.add(soldier5.getId());
            family707Contracts = new ArrayList<Integer>();
            family707Contracts.add(contract1.getId());
            family707Contracts.add(contract2.getId());
            family707Contracts.add(contract3.getId());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testCreateMafiaFamily007() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.beginTransaction(em);
            em.setProperty("tenant.id", (Object)"007");
            em.setProperty("eclipselink.tenant-id", (Object)"007");
            MafiaFamily family = new MafiaFamily();
            family.setName("Bond");
            family.setRevenue(Double.valueOf(9.8765432103E8));
            family.addTag("tag1");
            family.addTag("tag2");
            family.addTag("tag3");
            family.addTag("tag4");
            family.addTag("tag5");
            Boss boss = new Boss();
            boss.setFirstName("007");
            boss.setLastName("Boss");
            boss.setGender(Mafioso.Gender.Female);
            Underboss underboss = new Underboss();
            underboss.setFirstName("Second");
            underboss.setLastName("InCommand");
            underboss.setGender(Mafioso.Gender.Female);
            Capo capo1 = new Capo();
            capo1.setFirstName("Capo");
            capo1.setLastName("Lubey");
            capo1.setGender(Mafioso.Gender.Male);
            Capo capo2 = new Capo();
            capo2.setFirstName("Capo");
            capo2.setLastName("Greasy");
            capo2.setGender(Mafioso.Gender.Female);
            Soldier soldier1 = new Soldier();
            soldier1.setFirstName("First");
            soldier1.setLastName("Grunt");
            soldier1.setGender(Mafioso.Gender.Male);
            Soldier soldier2 = new Soldier();
            soldier2.setFirstName("Second");
            soldier2.setLastName("Grunt");
            soldier2.setGender(Mafioso.Gender.Female);
            Soldier soldier3 = new Soldier();
            soldier3.setFirstName("Third");
            soldier3.setLastName("Grunt");
            soldier3.setGender(Mafioso.Gender.Female);
            Soldier soldier4 = new Soldier();
            soldier4.setFirstName("Fourth");
            soldier4.setLastName("Grunt");
            soldier4.setGender(Mafioso.Gender.Female);
            Soldier soldier5 = new Soldier();
            soldier5.setFirstName("Fifth");
            soldier5.setLastName("Grunt");
            soldier5.setGender(Mafioso.Gender.Male);
            Soldier soldier6 = new Soldier();
            soldier6.setFirstName("Sixth");
            soldier6.setLastName("Grunt");
            soldier6.setGender(Mafioso.Gender.Male);
            Soldier soldier7 = new Soldier();
            soldier7.setFirstName("Seventh");
            soldier7.setLastName("Grunt");
            soldier7.setGender(Mafioso.Gender.Male);
            Contract contract1 = new Contract();
            contract1.setDescription("Whack 707 family boss");
            Contract contract2 = new Contract();
            contract2.setDescription("Acquire semi-automatic guns");
            Contract contract3 = new Contract();
            contract3.setDescription("Set up new financing deals");
            contract1.addSoldier(soldier1);
            contract1.addSoldier(soldier5);
            contract2.addSoldier(soldier1);
            contract2.addSoldier(soldier3);
            contract2.addSoldier(soldier7);
            contract3.addSoldier(soldier2);
            contract3.addSoldier(soldier3);
            contract3.addSoldier(soldier4);
            contract3.addSoldier(soldier5);
            boss.setUnderboss(underboss);
            capo1.setUnderboss(underboss);
            capo2.setUnderboss(underboss);
            capo1.addSoldier(soldier1);
            capo1.addSoldier(soldier2);
            capo2.addSoldier(soldier3);
            capo2.addSoldier(soldier4);
            capo2.addSoldier(soldier5);
            capo2.addSoldier(soldier6);
            capo2.addSoldier(soldier7);
            underboss.addCapo(capo1);
            underboss.addCapo(capo2);
            family.addMafioso((Mafioso)boss);
            family.addMafioso((Mafioso)underboss);
            family.addMafioso((Mafioso)capo1);
            family.addMafioso((Mafioso)capo2);
            family.addMafioso((Mafioso)soldier1);
            family.addMafioso((Mafioso)soldier2);
            family.addMafioso((Mafioso)soldier3);
            family.addMafioso((Mafioso)soldier4);
            family.addMafioso((Mafioso)soldier5);
            family.addMafioso((Mafioso)soldier6);
            family.addMafioso((Mafioso)soldier7);
            em.persist((Object)family);
            family007 = family.getId();
            family007Mafiosos = new ArrayList<Integer>();
            family007Mafiosos.add(boss.getId());
            family007Mafiosos.add(underboss.getId());
            family007Mafiosos.add(capo1.getId());
            family007Mafiosos.add(capo2.getId());
            family007Mafiosos.add(soldier1.getId());
            family007Mafiosos.add(soldier2.getId());
            family007Mafiosos.add(soldier3.getId());
            family007Mafiosos.add(soldier4.getId());
            family007Mafiosos.add(soldier5.getId());
            family007Mafiosos.add(soldier6.getId());
            family007Mafiosos.add(soldier7.getId());
            family007Contracts = new ArrayList<Integer>();
            family007Contracts.add(contract1.getId());
            family007Contracts.add(contract2.getId());
            family007Contracts.add(contract3.getId());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testValidateMafiaFamily707() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.validateMafiaFamily707(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testValidateMafiaFamily007() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        try {
            this.validateMafiaFamily007(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    protected void validateMafiaFamily707(EntityManager em) {
        DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
        em.clear();
        this.beginTransaction(em);
        em.setProperty("tenant.id", (Object)"707");
        em.setProperty("eclipselink.tenant-id", (Object)"707");
        MafiaFamily family = (MafiaFamily)em.find(MafiaFamily.class, (Object)family707);
        DDLGenerationJUnitTestSuite.assertNotNull((String)("The Mafia Family with id: " + family707 + ", was not found"), (Object)family);
        DDLGenerationJUnitTestSuite.assertTrue((String)("The Mafia Family had an incorrect number of tags [" + family.getTags().size() + "], expected [3]"), (family.getTags().size() == 3 ? 1 : 0) != 0);
        DDLGenerationJUnitTestSuite.assertNull((String)("The Mafia Family with id: " + family007 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family007));
        DDLGenerationJUnitTestSuite.assertFalse((String)"No mafiosos part of 707 family", (boolean)family.getMafiosos().isEmpty());
        for (Integer id : family007Mafiosos) {
            DDLGenerationJUnitTestSuite.assertNull((String)"Found family 007 mafioso.", (Object)em.find(Mafioso.class, (Object)id));
        }
        Boss otherBoss = (Boss)em.find(Boss.class, (Object)family007Mafiosos.get(0));
        DDLGenerationJUnitTestSuite.assertNull((String)"Found family 007 boss.", (Object)otherBoss);
        for (Integer id : family007Contracts) {
            DDLGenerationJUnitTestSuite.assertNull((String)"Found family 007 contract.", (Object)em.find(Contract.class, (Object)id));
        }
        em.createNamedQuery("UpdateAllContractDescriptions").executeUpdate();
        this.commitTransaction(em);
        this.beginTransaction(em);
        em.setProperty("tenant.id", (Object)"707");
        em.setProperty("eclipselink.tenant-id", (Object)"707");
        List contracts = em.createNamedQuery("FindAllContracts").getResultList();
        DDLGenerationJUnitTestSuite.assertTrue((String)("Incorrect number of contracts were returned [" + contracts.size() + "], expected[3]"), (contracts.size() == 3 ? 1 : 0) != 0);
        for (Contract contract : contracts) {
            DDLGenerationJUnitTestSuite.assertTrue((String)"Contract description was not voided.", (boolean)contract.getDescription().equals("voided"));
        }
        List soldiers = em.createQuery("SELECT s from Soldier s").getResultList();
        DDLGenerationJUnitTestSuite.assertTrue((String)("Incorrect number of soldiers were returned [" + soldiers.size() + "], expected [5]"), (soldiers.size() == 5 ? 1 : 0) != 0);
        if (DDLGenerationJUnitTestSuite.getServerSession((String)DDL_PU).getPlatform().isSymfoware()) {
            DDLGenerationJUnitTestSuite.getServerSession((String)DDL_PU).logMessage("Test DDLGenerationJUnitTestSuite partially skipped for this platform, which uses UpdateAll internally to check tenant-id when updating an entity using JOINED inheritance strategy. Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            this.commitTransaction(em);
            return;
        }
        Query query = em.createNamedQuery("UpdateBossName");
        query.setParameter("name", (Object)"Compromised");
        query.setParameter("id", (Object)family007Mafiosos.get(0));
        query.executeUpdate();
        this.commitTransaction(em);
    }

    protected void validateMafiaFamily007(EntityManager em) {
        DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
        em.clear();
        this.beginTransaction(em);
        em.setProperty("tenant.id", (Object)"007");
        em.setProperty("eclipselink.tenant-id", (Object)"007");
        MafiaFamily family = (MafiaFamily)em.find(MafiaFamily.class, (Object)family007);
        DDLGenerationJUnitTestSuite.assertNotNull((String)("The Mafia Family with id: " + family007 + ", was not found"), (Object)family);
        DDLGenerationJUnitTestSuite.assertTrue((String)("The Mafia Family had an incorrect number of tags [" + family.getTags().size() + "], expected [5]"), (family.getTags().size() == 5 ? 1 : 0) != 0);
        DDLGenerationJUnitTestSuite.assertNull((String)("The Mafia Family with id: " + family707 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family707));
        DDLGenerationJUnitTestSuite.assertFalse((String)"No mafiosos part of 007 family", (boolean)family.getMafiosos().isEmpty());
        for (Integer id : family707Mafiosos) {
            DDLGenerationJUnitTestSuite.assertNull((String)"Found family 707 mafioso.", (Object)em.find(Mafioso.class, (Object)id));
        }
        Boss otherBoss = (Boss)em.find(Boss.class, (Object)family707Mafiosos.get(0));
        DDLGenerationJUnitTestSuite.assertNull((String)"Found family 707 boss.", (Object)otherBoss);
        for (Integer id : family707Contracts) {
            DDLGenerationJUnitTestSuite.assertNull((String)"Found family 707 contract.", (Object)em.find(Contract.class, (Object)id));
        }
        List contracts = em.createNamedQuery("FindAllContracts").getResultList();
        DDLGenerationJUnitTestSuite.assertTrue((String)("Incorrect number of contracts were returned [" + contracts.size() + "], expected[3]"), (contracts.size() == 3 ? 1 : 0) != 0);
        for (Contract contract : contracts) {
            DDLGenerationJUnitTestSuite.assertFalse((String)"Contract description was voided.", (boolean)contract.getDescription().equals("voided"));
        }
        List families = em.createNamedQuery("findJPQLMafiaFamilies").getResultList();
        DDLGenerationJUnitTestSuite.assertTrue((String)("Incorrect number of families were returned [" + families.size() + "], expected [1]"), (families.size() == 1 ? 1 : 0) != 0);
        Boss boss = (Boss)em.find(Boss.class, (Object)family007Mafiosos.get(0));
        DDLGenerationJUnitTestSuite.assertFalse((String)"The Boss name has been compromised", (boolean)boss.getFirstName().equals("Compromised"));
        this.commitTransaction(em);
    }

    public void testLazyBlob() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_TPC_PU);
        this.beginTransaction(em);
        LuxuryCar car = new LuxuryCar();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            pw.print("TestString1");
            pw.close();
            baos.close();
            car.setPic(baos.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            DDLGenerationJUnitTestSuite.fail((String)"we failed!!!");
        }
        em.persist((Object)car);
        em.flush();
        em.refresh((Object)car);
        this.commitTransaction(em);
        em.clear();
        car = (LuxuryCar)em.find(LuxuryCar.class, (Object)car.getRegNumber());
        byte[] pic = car.getPic();
        DDLGenerationJUnitTestSuite.assertTrue((String)"Blob was null after flush, refresh, commit.", (pic != null ? 1 : 0) != 0);
    }

    public void testSimpleSelectFoo() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        em.createQuery("Select f from Foo f").getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testElementMapOnEmbedded() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
        MapHolder holder1 = new MapHolder();
        holder1.setId(1);
        MapHolderEmbeddable embeddable1 = new MapHolderEmbeddable();
        embeddable1.getStringMap().put("key 1 1", "value 1 1");
        embeddable1.getStringMap().put("key 1 2", "value 1 2");
        holder1.setMapHolderEmbedded(embeddable1);
        holder1.getStringMap().put("key 1 1", "value 1 1");
        holder1.getStringMap().put("key 1 2", "value 1 2");
        MapHolder holder2 = new MapHolder();
        holder2.setId(2);
        MapHolderEmbeddable embeddable2 = new MapHolderEmbeddable();
        embeddable2.getStringMap().put("key 2 1", "value 2 1");
        embeddable2.getStringMap().put("key 2 2", "value 2 2");
        embeddable2.getStringMap().put("key 2 3", "value 2 3");
        holder2.setMapHolderEmbedded(embeddable2);
        holder2.getStringMap().put("key 2 1", "value 2 1");
        holder2.getStringMap().put("key 2 2", "value 2 2");
        holder2.getStringMap().put("key 2 3", "value 2 3");
        this.beginTransaction(em);
        em.persist((Object)holder1);
        em.persist((Object)holder2);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        String errorMsg = "";
        try {
            DDLGenerationJUnitTestSuite.clearCache((String)DDL_PU);
            em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_PU);
            Query query = em.createQuery("SELECT mh FROM MapHolder mh WHERE mh.id = 1 OR mh.id = 2");
            List mapHolders = query.getResultList();
            if (mapHolders.size() == 2) {
                for (MapHolder mh : mapHolders) {
                    if (mh.getMapHolderEmbedded().getStringMap().size() != mh.getId() + 1) {
                        errorMsg = errorMsg + "Wrong getMapHolderEmbedded().getStringMap().size() " + mh.getMapHolderEmbedded().getStringMap().size() + "; expected " + Integer.toString(mh.getId() + 1) + "\n";
                    }
                    if (mh.getStringMap().size() == mh.getId() + 1) continue;
                    errorMsg = errorMsg + "Wrong getStringMap().size() " + mh.getStringMap().size() + "; expected " + Integer.toString(mh.getId() + 1) + "\n";
                }
            } else {
                errorMsg = errorMsg + "Wrong mapHolders size";
            }
        }
        finally {
            this.beginTransaction(em);
            em.remove(em.find(MapHolder.class, (Object)1));
            em.remove(em.find(MapHolder.class, (Object)2));
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        if (errorMsg.length() > 0) {
            DDLGenerationJUnitTestSuite.fail((String)("\n" + errorMsg));
        }
    }

    public void testTablePerTenant() {
        EntityManager em = DDLGenerationJUnitTestSuite.createEntityManager((String)DDL_TPT_PU);
        try {
            this.beginTransaction(em);
            Candidate candidate = new Candidate();
            candidate.setName("DDL");
            candidate.addHonor("Raised most money");
            candidate.addHonor("Highest win margin");
            candidate.setSalary(9999999);
            Supporter supporter1 = new Supporter();
            supporter1.setName("Supporter1");
            candidate.addSupporter(supporter1);
            Supporter supporter2 = new Supporter();
            supporter2.setName("Supporter2");
            candidate.addSupporter(supporter2);
            Party party = new Party();
            party.setName("Conservatives");
            party.addCandidate(candidate);
            Riding riding = new Riding();
            riding.setName("Ottawa");
            candidate.setRiding(riding);
            em.persist((Object)party);
            em.persist((Object)candidate);
            em.persist((Object)supporter2);
            em.persist((Object)supporter1);
            em.persist((Object)riding);
            Mason mason = new Mason();
            mason.setName("FromTenantDDL");
            mason.addAward((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2009, (int)1, (int)1)), "Best pointer");
            mason.addAward((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2010, (int)5, (int)9)), "Least screw-ups");
            mason.addHoursWorked((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2009, (int)1, (int)1)), Integer.valueOf(10));
            mason.addHoursWorked((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2010, (int)5, (int)9)), Integer.valueOf(11));
            mason.addUniSelf((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2010, (int)5, (int)9)), mason);
            Trowel trowel = new Trowel();
            trowel.setType("Pointing");
            mason.setTrowel(trowel);
            trowel.setMason(mason);
            em.persist((Object)mason);
            em.persist((Object)trowel);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testBug386939() {
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DDLGenerationJUnitTestSuite.suite());
    }

    static {
        family707Mafiosos = new ArrayList<Integer>();
        family707Contracts = new ArrayList<Integer>();
        family007Mafiosos = new ArrayList<Integer>();
        family007Contracts = new ArrayList<Integer>();
    }
}

