/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.wls;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.platform.server.ServerPlatformDetector;

public class WebLogicPlatformDetector
implements ServerPlatformDetector {
    @Override
    public String checkPlatform() {
        String platform = null;
        String serverNameAndVersion = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return WebLogicPlatformDetector.this.getServerNameAndVersionInternal();
            }
        }) : this.getServerNameAndVersionInternal();
        if (serverNameAndVersion != null && Helper.compareVersions(serverNameAndVersion, "9") >= 0) {
            platform = Helper.compareVersions(serverNameAndVersion, "10") >= 0 ? "WebLogic_10" : "WebLogic_9";
        }
        return platform;
    }

    private String getServerNameAndVersionInternal() {
        try {
            String loaderStr = WebLogicPlatformDetector.class.getClassLoader().getClass().getName();
            if (loaderStr.contains("weblogic")) {
                Class<?> versionCls = Class.forName("weblogic.version");
                Method method = versionCls.getMethod("getReleaseBuildVersion", new Class[0]);
                return (String)method.invoke(null, new Object[0]);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }
}

