/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalDiscriminatorClass;
import org.w3c.dom.Element;

/**
 * The external form of the discriminator class.
 *
 * @see VariableOneToOneMapping
 *
 * @version 2.5
 * @author Les Davis
 */
@SuppressWarnings("nls")
final class DiscriminatorClass extends AbstractExternalForm
                               implements ExternalDiscriminatorClass {

	/**
	 * The position of the element within the list of children with the same type owned by the parent.
	 */
	private int index;

	/**
	 * The attribute name used to store and retrieve the discriminator property.
	 */
	static final String DISCRIMINATOR = "discriminator";

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String DISCRIMINATOR_CLASS = "discriminator-class";

	/**
	 * The attribute name used to store and retrieve the value property.
	 */
	static final String VALUE = "value";

	/**
	 * Creates a new <code>DiscriminatorClass</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	DiscriminatorClass(VariableOneToOneMapping parent, int index) {
		super(parent);
		this.index = index;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Element addSelf(String elementName, List<String> elementNamesOrder) {
		return addChild(getParent(), elementName, index, elementNamesOrder);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(DISCRIMINATOR);
		names.add(VALUE);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final String getDiscriminator() {
		return getAttribute(DISCRIMINATOR);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final Element getElement() {
		return getChild(getParent(), DISCRIMINATOR_CLASS, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return DISCRIMINATOR_CLASS;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final int getIndex() {
		return index;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final String getValue() {
		return getAttribute(VALUE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final void removeSelf() {
		removeChild(getParent(), getElementName(), index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final void setDiscriminator(String discriminator) {
		setAttribute(DISCRIMINATOR, discriminator);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final void setValue(String value) {
		setAttribute(VALUE, value);
	}
}