/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalConverter;

/**
 * The external form of a converter, which is a child of an entity.
 *
 * @see BasicMapMapping
 * @see ConvertibleMapping
 * @see ElementCollectionMapping
 * @see EmbeddableEntity
 * @see ORMConfiguration
 *
 * @version 2.5
 * @author Les Davis
 */
@SuppressWarnings("nls")
final class Converter extends ClassConverter
                      implements ExternalConverter {

	/**
	 * The attribute name used to store and retrieve the class property.
	 */
	static final String CLASS = "class";

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String CONVERTER = "converter";

	/**
	 * Creates a new <code>Converter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	Converter(BasicMapMapping parent) {
		super(parent);
	}

	/**
	 * Creates a new <code>Converter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	Converter(ConvertibleMapping parent, int index) {
		super(parent, index);
	}

	/**
	 * Creates a new <code>Converter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	Converter(ElementCollectionMapping parent) {
		super(parent);
	}

	/**
	 * Creates a new <code>Converter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	Converter(EmbeddableEntity parent, int index) {
		super(parent, index);
	}

	/**
	 * Creates a new <code>Converter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	Converter(ORMConfiguration parent, int index) {
		super(parent, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = super.buildAttributeNamesOrder();
		names.add(CLASS);
		return names;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	String getConverterClassElementName() {
		return CLASS;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return CONVERTER;
	}
}