/*******************************************************************************
 * Copyright (c) 2009, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.persistence.tools.db.driver;

import org.eclipse.persistence.tools.utility.StringTools;

/**
 * Fold <em>regular</em> identifiers to lower case.
 *
 * @version 2.5
 */
class LowerCaseFoldingStrategy implements FoldingStrategy {

	// singleton
	private static final FoldingStrategy INSTANCE = new LowerCaseFoldingStrategy();

	/**
	 * Ensure single instance.
	 */
	private LowerCaseFoldingStrategy() {
		super();
	}

	/**
	 * Returns the singleton.
	 */
	static FoldingStrategy instance() {
		return INSTANCE;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String fold(String identifier) {
		return identifier.toLowerCase();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean nameIsFolded(String name) {
		return StringTools.isLowercase(name);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return this.getClass().getSimpleName();
	}
}