/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.TemporalType;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityIDGeneratedValue;
import org.eclipse.persistence.tools.mapping.orm.ExternalIDMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlField;
import org.eclipse.persistence.tools.mapping.orm.ExternalSequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalTableGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.ConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityIDGeneratedValue;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperClassEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlField;
import org.eclipse.persistence.tools.mapping.orm.dom.SequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.TableGenerator;

final class IdMapping
extends ConvertibleMapping
implements ExternalIDMapping {
    static final String ID = "id";
    static final String MUTABLE = "mutable";
    static final String TEMPORAL = "temporal";

    IdMapping(MappedSuperClassEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public ExternalEntityIDGeneratedValue addGeneratedValue() {
        EntityIDGeneratedValue generatedValue = this.buildGeneratedValue();
        generatedValue.addSelf();
        return generatedValue;
    }

    @Override
    public ExternalSequenceGenerator addSequenceGenerator() {
        SequenceGenerator sequenceGenerator = this.buildSequenceGenerator();
        sequenceGenerator.addSelf();
        return sequenceGenerator;
    }

    @Override
    public ExternalTableGenerator addTableGenerator() {
        TableGenerator tableGenerator = this.buildTableGenerator();
        tableGenerator.addSelf();
        return tableGenerator;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("access");
        names.add(MUTABLE);
        names.add("attribute-type");
        return names;
    }

    private EntityColumn buildColumn() {
        return new EntityColumn(this);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("column");
        names.add("field");
        names.add("generated-value");
        names.add(TEMPORAL);
        names.add("convert");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("table-generator");
        names.add("sequence-generator");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private EntityIDGeneratedValue buildGeneratedValue() {
        return new EntityIDGeneratedValue(this);
    }

    private ExternalNoSqlField buildNoSqlField() {
        return new NoSqlField(this);
    }

    private SequenceGenerator buildSequenceGenerator() {
        return new SequenceGenerator(this);
    }

    private TableGenerator buildTableGenerator() {
        return new TableGenerator(this);
    }

    @Override
    public EntityColumn getColumn() {
        if (this.hasChild("column")) {
            return this.buildColumn();
        }
        return null;
    }

    @Override
    protected String getElementName() {
        return ID;
    }

    @Override
    public ExternalEntityIDGeneratedValue getGeneratedValue() {
        if (this.hasChild("generated-value")) {
            return this.buildGeneratedValue();
        }
        return null;
    }

    @Override
    public String getNoSqlField() {
        ExternalNoSqlField field = this.buildNoSqlField();
        return field.getName();
    }

    @Override
    public ExternalSequenceGenerator getSequenceGenerator() {
        if (this.hasChild("sequence-generator")) {
            return this.buildSequenceGenerator();
        }
        return null;
    }

    @Override
    public ExternalTableGenerator getTableGenerator() {
        if (this.hasChild("table-generator")) {
            return this.buildTableGenerator();
        }
        return null;
    }

    @Override
    public TemporalType getTemporalType() {
        return this.getChildEnumNode(TEMPORAL, TemporalType.class);
    }

    @Override
    public final boolean isIdMapping() {
        return true;
    }

    @Override
    public Boolean isMutable() {
        return this.getBooleanAttribute(MUTABLE);
    }

    @Override
    public void removeGeneratedValue() {
        EntityIDGeneratedValue generatedValue = this.buildGeneratedValue();
        generatedValue.removeSelf();
    }

    @Override
    public void removeSequenceGenerator() {
        SequenceGenerator generator = this.buildSequenceGenerator();
        generator.removeSelf();
    }

    @Override
    public void removeTableGenerator() {
        TableGenerator generator = this.buildTableGenerator();
        generator.removeSelf();
    }

    @Override
    public void setAttributeType(String attributeType) {
        this.setAttribute("attribute-type", attributeType);
    }

    @Override
    public void setColumn(String columnName) {
        EntityColumn column = this.getColumn();
        if (column == null && columnName == null) {
            return;
        }
        if (column == null && columnName != null) {
            column = this.buildColumn();
            column.addSelf();
        }
        if (columnName != null) {
            column.setName(columnName);
        } else {
            ((AbstractExternalForm)column).removeSelf();
        }
    }

    @Override
    public void setMutable(Boolean mutable) {
        this.setAttribute(MUTABLE, mutable);
    }

    @Override
    public void setNoSqlField(String field) {
        ExternalNoSqlField noSqlField = this.buildNoSqlField();
        noSqlField.setName(field);
    }

    @Override
    public void setSequenceGenerator(String generatorName) {
        this.updateChildTextNode("sequence-generator", generatorName);
    }

    @Override
    public void setTableGenerator(String generatorName) {
        this.updateChildTextNode("table-generator", generatorName);
    }

    @Override
    public void setTemporalType(TemporalType type) {
        this.updateChildTextNode(TEMPORAL, (Enum<?>)type);
    }
}

