/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.gen.nosql.mongo.meta;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.tools.gen.nosql.mongo.meta.ColumnDescriptor;
import org.eclipse.persistence.tools.gen.nosql.mongo.meta.LeafColumnDescriptor;
import org.eclipse.persistence.tools.gen.nosql.mongo.meta.NestedColumnDescriptor;

public final class CollectionDescriptor {
    private Map<String, ColumnDescriptor> columnDescriptors;
    private String name;

    public CollectionDescriptor(String name) {
        this.name = name;
        this.columnDescriptors = new HashMap<String, ColumnDescriptor>();
    }

    public LeafColumnDescriptor addLeafColumn(String name) {
        LeafColumnDescriptor column = new LeafColumnDescriptor(name);
        this.columnDescriptors.put(name, column);
        return column;
    }

    public NestedColumnDescriptor addNestedColumn(String name) {
        NestedColumnDescriptor column = new NestedColumnDescriptor(name);
        this.columnDescriptors.put(name, column);
        return column;
    }

    public Iterable<? extends ColumnDescriptor> columns() {
        return this.columnDescriptors.values();
    }

    public ColumnDescriptor getColumn(String name) {
        return this.columnDescriptors.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void removeColumn(ColumnDescriptor columnDescriptor) {
        this.columnDescriptors.remove(columnDescriptor.getColumnName());
    }
}

