/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.jpa.xml.merge.advanced;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.EmployeeListener;
import org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.Project;

@Entity(name="AnnMergeEmplyee")
@EntityListeners(value={EmployeeListener.class})
@Table(name="CMP3_ANN_MERGE_EMPLOYEE")
@SecondaryTable(name="CMP3_ANN_MERGE_SALARY")
@PrimaryKeyJoinColumn(name="ANN_MERGE_EMP_ID", referencedColumnName="ANN_MERGE_EMP_ID")
@NamedQueries(value={@NamedQuery(name="ann_merge_findAllEmployeesByFirstName", query="SELECT OBJECT(employee) FROM Employee employee WHERE employee.firstName = :firstname"), @NamedQuery(name="ann_merge_constuctEmployees", query="SELECT new org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.Employee(employee.firstName, employee.lastName) FROM Employee employee")})
public class Employee
implements Serializable {
    private Integer id;
    private int version;
    private String firstName;
    private String lastName;
    private Address address;
    private Collection<PhoneNumber> phoneNumbers = new Vector<PhoneNumber>();
    private Collection<Project> projects = new Vector<Project>();
    private int salary;
    private EmploymentPeriod period;
    private Collection<Employee> managedEmployees = new Vector<Employee>();
    private Employee manager;

    public Employee() {
    }

    public Employee(String firstName, String lastName) {
        this();
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="ANN_MERGE_EMPLOYEE_TABLE_GENERATOR")
    @TableGenerator(name="ANN_MERGE_EMPLOYEE_TABLE_GENERATOR", table="CMP3_ANN_MERGE_EMPLOYEE_SEQ", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="ANN_MERGE_EMPLOYEE_SEQ")
    @Column(name="ANN_MERGE_EMP_ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Version
    @Column(name="ANN_MERGE_VERSION")
    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    @Column(name="ANN_MERGE_F_NAME")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String name) {
        this.firstName = name;
    }

    @Transient
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String name) {
        this.lastName = name;
    }

    @ManyToOne(cascade={CascadeType.PERSIST}, fetch=FetchType.LAZY)
    @JoinColumn(name="ANN_MERGE_ADDR_ID")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="owner")
    public Collection<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(Collection<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="manager")
    public Collection<Employee> getManagedEmployees() {
        return this.managedEmployees;
    }

    public void setManagedEmployees(Collection<Employee> managedEmployees) {
        this.managedEmployees = managedEmployees;
    }

    @ManyToOne(cascade={CascadeType.PERSIST}, fetch=FetchType.LAZY)
    public Employee getManager() {
        return this.manager;
    }

    public void setManager(Employee manager) {
        this.manager = manager;
    }

    @ManyToMany(cascade={CascadeType.PERSIST})
    @JoinTable(name="CMP3_EMP_PROJ", joinColumns={@JoinColumn(name="ANN_MERGE_EMPLOYEES_EMP_ID", referencedColumnName="ANN_MERGE_EMP_ID")})
    public Collection<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Collection<Project> projects) {
        this.projects = projects;
    }

    @Column(table="CMP3_ANN_MERGE_SALARY")
    public int getSalary() {
        return this.salary;
    }

    public void setSalary(int salary) {
        this.salary = salary;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="startDate", column=@Column(name="ANN_MERGE_START_DATE", nullable=false)), @AttributeOverride(name="endDate", column=@Column(name="ANN_MERGE_END_DATE", nullable=true))})
    public EmploymentPeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(EmploymentPeriod period) {
        this.period = period;
    }

    public void addManagedEmployee(Employee emp) {
        this.getManagedEmployees().add(emp);
        emp.setManager(this);
    }

    public void addPhoneNumber(PhoneNumber phone) {
        phone.setOwner(this);
        this.getPhoneNumbers().add(phone);
    }

    public void addProject(Project theProject) {
        this.getProjects().add(theProject);
    }

    public void removeManagedEmployee(Employee emp) {
        this.getManagedEmployees().remove(emp);
    }

    public void removePhoneNumber(PhoneNumber phone) {
        this.getPhoneNumbers().remove(phone);
    }

    public void removeProject(Project theProject) {
        this.getProjects().remove(theProject);
    }

    public String toString() {
        return "Employee: " + this.getId();
    }

    public String displayString() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("Employee ").append(this.getId()).append(": ").append(this.getLastName()).append(", ").append(this.getFirstName()).append(this.getSalary());
        return sbuff.toString();
    }

    public static void getAbsolutelyNothing() {
    }

    public String getYourStringBack(String str) {
        return str;
    }

    public String getAnEmptyString() {
        return "";
    }
}

