/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.MultiMethodReflectiveChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.SingleMethodReflectiveChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;

public abstract class ReflectiveChangeListener {
    protected Object target;
    protected static final Class StateChangeEvent_class = StateChangeEvent.class;
    protected static final Class[] STATE_CHANGE_EVENT_CLASS_ARRAY = new Class[]{StateChangeEvent_class};
    protected static final StateChangeEvent[] EMPTY_STATE_CHANGE_EVENT_ARRAY = new StateChangeEvent[0];
    protected static final Class PropertyChangeEvent_class = PropertyChangeEvent.class;
    protected static final Class[] PROPERTY_CHANGE_EVENT_CLASS_ARRAY = new Class[]{PropertyChangeEvent_class};
    protected static final PropertyChangeEvent[] EMPTY_PROPERTY_CHANGE_EVENT_ARRAY = new PropertyChangeEvent[0];
    protected static final Class CollectionChangeEvent_class = CollectionChangeEvent.class;
    protected static final Class[] COLLECTION_CHANGE_EVENT_CLASS_ARRAY = new Class[]{CollectionChangeEvent_class};
    protected static final CollectionChangeEvent[] EMPTY_COLLECTION_CHANGE_EVENT_ARRAY = new CollectionChangeEvent[0];
    protected static final Class ListChangeEvent_class = ListChangeEvent.class;
    protected static final Class[] LIST_CHANGE_EVENT_CLASS_ARRAY = new Class[]{ListChangeEvent_class};
    protected static final ListChangeEvent[] EMPTY_LIST_CHANGE_EVENT_ARRAY = new ListChangeEvent[0];
    protected static final Class TreeChangeEvent_class = TreeChangeEvent.class;
    protected static final Class[] TREE_CHANGE_EVENT_CLASS_ARRAY = new Class[]{TreeChangeEvent_class};
    protected static final TreeChangeEvent[] EMPTY_TREE_CHANGE_EVENT_ARRAY = new TreeChangeEvent[0];

    private static Method findChangeListenerMethod(Object target, String methodName, Class[] eventClassArray) {
        Method method;
        try {
            method = ClassTools.method(target, methodName, eventClassArray);
        }
        catch (NoSuchMethodException ex1) {
            try {
                method = ClassTools.method(target, methodName);
            }
            catch (NoSuchMethodException ex2) {
                throw new RuntimeException(ex2);
            }
        }
        return method;
    }

    private static void checkChangeListenerMethod(Method method, Class eventClass) {
        Class<?>[] parmTypes = method.getParameterTypes();
        int parmTypesLength = parmTypes.length;
        if (parmTypesLength == 0) {
            return;
        }
        if (parmTypesLength == 1 && parmTypes[0].isAssignableFrom(eventClass)) {
            return;
        }
        throw new IllegalArgumentException(method.toString());
    }

    public static StateChangeListener buildStateChangeListener(Object target, Method method) {
        ReflectiveChangeListener.checkChangeListenerMethod(method, StateChangeEvent_class);
        return new SingleMethodReflectiveChangeListener(target, method);
    }

    public static StateChangeListener buildStateChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildStateChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, STATE_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static PropertyChangeListener buildPropertyChangeListener(Object target, Method method) {
        ReflectiveChangeListener.checkChangeListenerMethod(method, PropertyChangeEvent_class);
        return new SingleMethodReflectiveChangeListener(target, method);
    }

    public static PropertyChangeListener buildPropertyChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildPropertyChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, PROPERTY_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object target, Method addMethod, Method removeMethod, Method changeMethod) {
        ReflectiveChangeListener.checkChangeListenerMethod(addMethod, CollectionChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(removeMethod, CollectionChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(changeMethod, CollectionChangeEvent_class);
        return new MultiMethodReflectiveChangeListener(target, addMethod, removeMethod, changeMethod);
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object target, Method method) {
        return ReflectiveChangeListener.buildCollectionChangeListener(target, method, method, method);
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object target, String addMethodName, String removeMethodName, String changeMethodName) {
        return ReflectiveChangeListener.buildCollectionChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, addMethodName, COLLECTION_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, removeMethodName, COLLECTION_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, changeMethodName, COLLECTION_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildCollectionChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, COLLECTION_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static ListChangeListener buildListChangeListener(Object target, Method addMethod, Method removeMethod, Method replaceMethod, Method changeMethod) {
        ReflectiveChangeListener.checkChangeListenerMethod(addMethod, ListChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(removeMethod, ListChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(replaceMethod, ListChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(changeMethod, ListChangeEvent_class);
        return new MultiMethodReflectiveChangeListener(target, addMethod, removeMethod, replaceMethod, changeMethod);
    }

    public static ListChangeListener buildListChangeListener(Object target, Method method) {
        return ReflectiveChangeListener.buildListChangeListener(target, method, method, method, method);
    }

    public static ListChangeListener buildListChangeListener(Object target, String addMethodName, String removeMethodName, String replaceMethodName, String changeMethodName) {
        return ReflectiveChangeListener.buildListChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, addMethodName, LIST_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, removeMethodName, LIST_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, replaceMethodName, LIST_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, changeMethodName, LIST_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static ListChangeListener buildListChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildListChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, LIST_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static TreeChangeListener buildTreeChangeListener(Object target, Method addMethod, Method removeMethod, Method changeMethod) {
        ReflectiveChangeListener.checkChangeListenerMethod(addMethod, TreeChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(removeMethod, TreeChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(changeMethod, TreeChangeEvent_class);
        return new MultiMethodReflectiveChangeListener(target, addMethod, removeMethod, changeMethod);
    }

    public static TreeChangeListener buildTreeChangeListener(Object target, Method method) {
        return ReflectiveChangeListener.buildTreeChangeListener(target, method, method, method);
    }

    public static TreeChangeListener buildTreeChangeListener(Object target, String addMethodName, String removeMethodName, String changeMethodName) {
        return ReflectiveChangeListener.buildTreeChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, addMethodName, TREE_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, removeMethodName, TREE_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, changeMethodName, TREE_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static TreeChangeListener buildTreeChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildTreeChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, TREE_CHANGE_EVENT_CLASS_ARRAY));
    }

    protected ReflectiveChangeListener(Object target) {
        this.target = target;
    }
}

