/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.tools.workbench.framework.OpenException;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.UnsupportedFileException;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.PreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.SCPluginIconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.scplugin.SCPluginResourceBundle;
import org.eclipse.persistence.tools.workbench.scplugin.SCProblemsResourceBundle;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsProperties;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsPropertiesManager;
import org.eclipse.persistence.tools.workbench.scplugin.ui.AddNewSessionsAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.preferences.SCPreferencesNode;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class SCPlugin
implements Plugin {
    private SCSessionsPropertiesManager propertiesManager;
    private Map propertiesPageCache;
    private static final String SC_PREFERENCES_NODE = "sc";
    public static final String DATA_SOURCE_TYPE_PREFERENCE = "data source type";
    public static final String DEFAULT_CLASSPATH_PREFERENCE = "default classpath";
    public static final String NEW_NAME_BROKER_PREFERENCE = "new name.broker";
    public static final String NEW_NAME_POOL_PREFERENCE = "new name.pool";
    public static final String NEW_NAME_SESSION_PREFERENCE = "new name.session";
    public static final String DATABASE_PLATFORM_PREFERENCE = "platform.database";
    public static final String EIS_PLATFORM_PREFERENCE = "platform.eis";
    public static final String SERVER_PLATFORM_PREFERENCE = "platform.server";
    public static final String NEW_NAME_SESSIONS_CONFIGURATION_PREFERENCE = "new name.sessions configuration";
    public static final String DATABASE_PLATFORM_PREFERENCE_DEFAULT = "Oracle11";
    public static final String EIS_PLATFORM_PREFERENCE_DEFAULT = "AQPlatform";
    public static final String SERVER_PLATFORM_PREFERENCE_DEFAULT = "WebLogic_10_Platform";
    public static final String DATA_SOURCE_TYPE_PREFERENCE_EIS_CHOICE = "eis";
    public static final String DATA_SOURCE_TYPE_PREFERENCE_RELATIONAL_CHOICE = "relational";
    public static final String DATA_SOURCE_TYPE_PREFERENCE_XML_CHOICE = "xml";

    public SCPlugin() {
        this.initialize();
    }

    private void initialize() {
        this.propertiesPageCache = new HashMap();
    }

    @Override
    public JMenuItem[] buildNewMenuItems(WorkbenchContext context) {
        return new JMenuItem[]{this.buildNewConfigurationMenuItem(context)};
    }

    public JMenuItem[] buildMigrateMenuItems(WorkbenchContext context) {
        return new JMenuItem[0];
    }

    @Override
    public ApplicationNode open(File file, WorkbenchContext context) throws UnsupportedFileException, OpenException {
        if (!FileTools.extension((File)file).equalsIgnoreCase(".xml")) {
            throw new UnsupportedFileException();
        }
        WorkbenchContext scContext = this.wrap(context);
        try {
            SCSessionsProperties properties = this.getSessionsProperties(scContext.getApplicationContext(), file);
            TopLinkSessionsAdapter topLinkSessions = new TopLinkSessionsAdapter(properties, scContext.getApplicationContext().getPreferences(), false);
            return new ProjectNode(topLinkSessions, scContext.getApplicationContext().getNodeManager().getRootNode(), this, scContext.getApplicationContext());
        }
        catch (Throwable t) {
            throw new OpenException(t);
        }
    }

    @Override
    public ComponentContainerDescription buildToolBarDescription(WorkbenchContext context) {
        return new ToolBarButtonGroupDescription();
    }

    @Override
    public ComponentContainerDescription buildMenuDescription(WorkbenchContext context) {
        return new MenuGroupDescription();
    }

    @Override
    public PreferencesNode[] buildPreferencesNodes(PreferencesContext context) {
        return new PreferencesNode[]{new SCPreferencesNode((PreferencesContext)this.wrap(context))};
    }

    public File nextUntitledFile(ApplicationContext context) {
        return this.getPropertiesManager(context).nextUntitledSessionsFile();
    }

    public void showWarning(WorkbenchContext context, String message, Throwable exception) {
        SessionLoaderException loaderException;
        Vector exceptions;
        StringBuffer exceptionBuffer = new StringBuffer();
        String exceptionMessage = exception.getLocalizedMessage();
        if (exceptionMessage != null) {
            exceptionBuffer.append(exception.getLocalizedMessage());
        }
        if (exceptionBuffer.toString().startsWith(StringTools.CR)) {
            exceptionBuffer.replace(0, StringTools.CR.length(), "");
        }
        if (exception instanceof SessionLoaderException && (exceptions = (loaderException = (SessionLoaderException)exception).getExceptionList()) != null) {
            for (Throwable topLinkException : loaderException.getExceptionList()) {
                exceptionBuffer.append(StringTools.CR);
                exceptionBuffer.append("***");
                exceptionBuffer.append(topLinkException.getLocalizedMessage());
            }
        }
        if (exceptionBuffer.length() == 0) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            exception.printStackTrace(printWriter);
            exceptionBuffer.append(writer.toString());
        }
        JOptionPane.showMessageDialog(context.getCurrentWindow(), this.buildErrorPaneArea(message, exceptionBuffer.toString()), context.getApplicationContext().getApplication().getShortProductName(), 0);
    }

    private Component buildErrorPaneArea(String message, String exception) {
        JPanel pane = new JPanel(new BorderLayout(0, 1));
        LabelArea label = new LabelArea(message);
        pane.add((Component)label, "First");
        JTextArea textArea = new JTextArea(exception);
        textArea.setFont(label.getFont());
        textArea.setTabSize(2);
        pane.add((Component)new JScrollPane(textArea), "Center");
        pane.setPreferredSize(new Dimension(350, Math.min(pane.getPreferredSize().height + 50, 150)));
        return pane;
    }

    private JMenuItem buildNewConfigurationMenuItem(WorkbenchContext context) {
        return new JMenuItem(new AddNewSessionsAction(this.wrap(context), this));
    }

    private WorkbenchContext wrap(WorkbenchContext context) {
        return context.buildExpandedApplicationContextWorkbenchContext(this.wrap(context.getApplicationContext()));
    }

    private ApplicationContext wrap(ApplicationContext context) {
        ApplicationContext expandedContext = context.buildExpandedResourceRepositoryContext(SCPluginResourceBundle.class, new SCPluginIconResourceFileNameMap());
        expandedContext = expandedContext.buildExpandedResourceRepositoryContext(SCProblemsResourceBundle.class);
        return expandedContext.buildRedirectedPreferencesContext(SC_PREFERENCES_NODE);
    }

    public Component getPropertiesPage(Object key) {
        return (Component)this.propertiesPageCache.remove(key);
    }

    public void releasePropertiesPage(Object key, Component propertiesPage) {
        this.propertiesPageCache.put(key, propertiesPage);
    }

    private SCSessionsPropertiesManager getPropertiesManager(ApplicationContext context) {
        if (this.propertiesManager == null) {
            this.propertiesManager = this.loadSessionsProperties(context);
        }
        return this.propertiesManager;
    }

    public SCSessionsProperties getSessionsProperties(ApplicationContext context, File path) {
        return this.getPropertiesManager(context).getSessionsProperties(path);
    }

    private SCSessionsPropertiesManager loadSessionsProperties(ApplicationContext context) {
        Preferences preferences = context.getPreferences();
        return new SCSessionsPropertiesManager(preferences);
    }
}

