/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CheckBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementListIterator;

final class SchemaNamespacesPanel
extends AbstractPropertiesPage {
    SchemaNamespacesPanel(PropertyValueModel schemaNodeHolder, WorkbenchContextHolder contextHolder) {
        super(schemaNodeHolder, contextHolder);
    }

    @Override
    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.buildBuiltInNamespacesPanel(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(10, 5, 0, 5);
        this.add((Component)this.buildTargetNamespacePanel(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)this.buildImportedNamespacesPanel(), constraints);
    }

    private JPanel buildBuiltInNamespacesPanel() {
        return this.buildNamespacePanel(this.buildBuiltInNamespacesTableLabel(), this.buildBuiltInNamespacesTable());
    }

    private JLabel buildBuiltInNamespacesTableLabel() {
        return this.buildLabel("BUILT_IN_NAMESPACES_TABLE_LABEL");
    }

    private JTable buildBuiltInNamespacesTable() {
        JTable table = SwingComponentFactory.buildTable(this.buildBuiltInNamespacesTableModel());
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }

    private TableModelAdapter buildBuiltInNamespacesTableModel() {
        return new TableModelAdapter(this.buildBuiltInNamespacesAdapter(), this.buildColumnAdapter());
    }

    private ListValueModel buildBuiltInNamespacesAdapter() {
        return new ListAspectAdapter(this.getSelectionHolder()){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWXmlSchema)this.subject).builtInNamespaces();
            }
        };
    }

    private JPanel buildTargetNamespacePanel() {
        return this.buildNamespacePanel(this.buildTargetNamespaceTableLabel(), this.buildTargetNamespaceTable());
    }

    private JLabel buildTargetNamespaceTableLabel() {
        return this.buildLabel("TARGET_NAMESPACE_TABLE_LABEL");
    }

    private JTable buildTargetNamespaceTable() {
        JTable table = SwingComponentFactory.buildTable(this.buildTargetNamespaceTableModel());
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }

    private TableModelAdapter buildTargetNamespaceTableModel() {
        return new TableModelAdapter(this.buildTargetNamespaceAdapter(), this.buildColumnAdapter()){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                if (columnIndex == 1 && "".equals(SchemaNamespacesPanel.this.schema().targetNamespace().getNamespaceUrl())) {
                    return false;
                }
                return super.isCellEditable(rowIndex, columnIndex);
            }
        };
    }

    private ListValueModel buildTargetNamespaceAdapter() {
        return new ListAspectAdapter(this.getSelectionHolder()){

            @Override
            protected ListIterator getValueFromSubject() {
                return new SingleElementListIterator((Object)((MWXmlSchema)this.subject).targetNamespace());
            }

            @Override
            protected int sizeFromSubject() {
                return 1;
            }
        };
    }

    private JPanel buildImportedNamespacesPanel() {
        return this.buildNamespacePanel(this.buildImportedNamespacesTableLabel(), this.buildImportedNamespacesTable());
    }

    private JLabel buildImportedNamespacesTableLabel() {
        return this.buildLabel("IMPORTED_NAMESPACES_TABLE_LABEL");
    }

    private JTable buildImportedNamespacesTable() {
        JTable table = SwingComponentFactory.buildTable(this.buildImportedNamespacesTableModel());
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }

    private TableModelAdapter buildImportedNamespacesTableModel() {
        return new TableModelAdapter(this.buildSortedImportedNamespacesAdapter(), this.buildColumnAdapter());
    }

    private ListValueModel buildSortedImportedNamespacesAdapter() {
        return new SortedListValueModelAdapter(this.buildUpdatingImportedNamespacesAdapter(), MWNamespace.COMPARATOR);
    }

    private ListValueModel buildUpdatingImportedNamespacesAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildImportedNamespacesAdapter(), "namespaceUrl");
    }

    private CollectionValueModel buildImportedNamespacesAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "namespaces"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWXmlSchema)this.subject).importedNamespaces();
            }
        };
    }

    private JPanel buildNamespacePanel(JLabel label, JTable table) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        label.setLabelFor(table);
        JComponent tablePanel = this.buildTablePanel(table);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)tablePanel, constraints);
        return panel;
    }

    private ColumnAdapter buildColumnAdapter() {
        return new NamespaceColumnAdapter(this.resourceRepository());
    }

    private JComponent buildTablePanel(JTable table) {
        TableColumn urlColumn = table.getColumnModel().getColumn(0);
        urlColumn.setPreferredWidth(200);
        TableColumn prefixColumn = table.getColumnModel().getColumn(1);
        prefixColumn.setPreferredWidth(50);
        TableColumn declaredColumn = table.getColumnModel().getColumn(2);
        declaredColumn.setPreferredWidth(50);
        CheckBoxTableCellRenderer declaredRenderer = this.buildDeclaredRenderer();
        declaredColumn.setCellRenderer(declaredRenderer);
        declaredColumn.setCellEditor(this.buildDeclaredEditor(declaredRenderer));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)table.getTableHeader(), "First");
        panel.add((Component)table, "Center");
        return new JScrollPane(panel, 21, 31);
    }

    private CheckBoxTableCellRenderer buildDeclaredRenderer() {
        return new CheckBoxTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                MWNamespace namespace = (MWNamespace)((TableModelAdapter)table.getModel()).getModel().getItem(row);
                if (!namespace.getNamespaceUrl().equals("")) {
                    return super.getTableCellRendererComponent(table, value, selected, hasFocus, row, column);
                }
                return null;
            }
        };
    }

    private TableCellEditor buildDeclaredEditor(CheckBoxTableCellRenderer declaredRenderer) {
        return new TableCellEditorAdapter(declaredRenderer){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
                MWNamespace namespace = (MWNamespace)((TableModelAdapter)table.getModel()).getModel().getItem(row);
                if (!namespace.getNamespaceUrl().equals("")) {
                    return super.getTableCellEditorComponent(table, value, selected, row, column);
                }
                return null;
            }
        };
    }

    private MWXmlSchema schema() {
        return (MWXmlSchema)this.selection();
    }

    private static class NamespaceColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        private static final int COLUMN_COUNT = 3;
        private static final int URL_COLUMN = 0;
        private static final int PREFIX_COLUMN = 1;
        private static final int DECLARED_COLUMN = 2;

        NamespaceColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return this.resourceRepository.getString("URL_COLUMN_LABEL");
                }
                case 1: {
                    return this.resourceRepository.getString("PREFIX_COLUMN_LABEL");
                }
                case 2: {
                    return this.resourceRepository.getString("DECLARED_COLUMN_LABEL");
                }
            }
            return "";
        }

        @Override
        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return null;
        }

        @Override
        public boolean isColumnEditable(int index) {
            switch (index) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public PropertyValueModel[] cellModels(Object subject) {
            MWNamespace namespace = (MWNamespace)subject;
            PropertyValueModel[] cellModels = new PropertyValueModel[]{this.buildUrlAdapter(namespace), this.buildPrefixAdapter(namespace), this.buildDeclaredAdapter(namespace)};
            return cellModels;
        }

        private PropertyValueModel buildUrlAdapter(MWNamespace namespace) {
            return new PropertyAspectAdapter("namespaceUrl", (Model)namespace){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWNamespace)this.subject).getNamespaceUrlForDisplay();
                }
            };
        }

        private PropertyValueModel buildPrefixAdapter(MWNamespace namespace) {
            return new PropertyAspectAdapter("namespacePrefix", (Model)namespace){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWNamespace)this.subject).getNamespacePrefix();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWNamespace)this.subject).setNamespacePrefixFromUser((String)value);
                }
            };
        }

        private PropertyValueModel buildDeclaredAdapter(MWNamespace namespace) {
            return new PropertyAspectAdapter("declared", (Model)namespace){

                @Override
                protected Object getValueFromSubject() {
                    return new Boolean(((MWNamespace)this.subject).isDeclared());
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWNamespace)this.subject).setDeclared(((Boolean)value).booleanValue());
                }
            };
        }
    }
}

