/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JTabbedPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWAbstractEisReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryGeneralPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml.EisQueryOptionsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml.InteractionPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;

final class EisQueryPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private JTabbedPane queryPropertiesPane;
    private QueryGeneralPanel queryGeneralPanel;

    EisQueryPanel(PropertyValueModel queryHolder, ObjectListSelectionModel querySelectionModel, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.queryHolder = queryHolder;
        this.initializeLayout(querySelectionModel);
    }

    private void initializeLayout(ObjectListSelectionModel querySelectionModel) {
        GridBagConstraints constraints = new GridBagConstraints();
        this.queryPropertiesPane = new JTabbedPane();
        this.queryGeneralPanel = new QueryGeneralPanel(this.queryHolder, querySelectionModel, this.getWorkbenchContextHolder());
        InteractionPanel queryCallPanel = new InteractionPanel(this.getApplicationContext(), this.buildInteractionHolder(), this.buildComponentEnablerBooleanHolder(), "descriptor.eis.query");
        EisQueryOptionsPanel queryOptionsPanel = new EisQueryOptionsPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("GENERAL_TAB"), this.queryGeneralPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("CALL_TAB"), queryCallPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("OPTIONS_TAB"), queryOptionsPanel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.queryPropertiesPane, constraints);
    }

    private PropertyValueModel buildInteractionHolder() {
        return new PropertyAspectAdapter(this.queryHolder){

            @Override
            protected Object getValueFromSubject() {
                return ((MWAbstractEisReadQuery)this.subject).getEisInteraction();
            }
        };
    }

    protected PropertyValueModel buildComponentEnablerBooleanHolder() {
        return new PropertyAspectAdapter(this.queryHolder){

            @Override
            protected Object getValueFromSubject() {
                return true;
            }
        };
    }

    protected QueryGeneralPanel getQueryGeneralPanel() {
        return this.queryGeneralPanel;
    }

    protected JTabbedPane getQueryTabbedPane() {
        return this.queryPropertiesPane;
    }
}

