/*******************************************************************************
 * Copyright (c) 2008, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.gen.internal;

import org.eclipse.persistence.tools.gen.db.Column;
import org.eclipse.persistence.tools.gen.db.ForeignKey;
import org.eclipse.persistence.tools.gen.db.Table;

/**
 * Singleton that delegates to the db object passed in.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.
 *
 * @version 2.5
 */
public final class GenericEntityGeneratorDatabaseAnnotationNameBuilder implements EntityGeneratorDatabaseAnnotationNameBuilder {

	/**
	 * The singleton instance of this builder.
	 */
	private static final EntityGeneratorDatabaseAnnotationNameBuilder INSTANCE = new GenericEntityGeneratorDatabaseAnnotationNameBuilder();

	/**
	 * Creates a new <code>GenericEntityGeneratorDatabaseAnnotationNameBuilder</code>.
	 */
	private GenericEntityGeneratorDatabaseAnnotationNameBuilder() {
		super();
	}

	/**
	 * Returns the singleton instance of this builder.
	 *
	 * @return The singleton instance
	 */
	public static EntityGeneratorDatabaseAnnotationNameBuilder instance() {
		return INSTANCE;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String buildColumnAnnotationName(String attributeName, Column column) {
		return column.getIdentifier(attributeName);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String buildJoinColumnAnnotationName(Column column) {
		return column.getIdentifier();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String buildJoinColumnAnnotationName(String attributeName, ForeignKey foreignKey) {
		return foreignKey.getJoinColumnAnnotationIdentifier(attributeName);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String buildJoinTableAnnotationName(Table table) {
		return table.getIdentifier();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String buildTableAnnotationName(String entityName, Table table) {
		return table.getIdentifier(entityName);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return this.getClass().getSimpleName();
	}
}