/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterator;

import java.util.Iterator;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.Stack;

/**
 * A <code>StackIterator</code> provides an {@link Iterator}
 * for a {@link Stack} of objects of type <code>E</code>. The stack's elements
 * are {@link Stack#pop() pop}ped" as the iterator returns them with
 * calls to {@link #next()}.
 *
 * @param <E> the type of elements returned by the iterator
 *
 * @see Stack
 * @see org.eclipse.jpt.common.utility.internal.iterable.StackIterable
 */
public class StackIterator<E>
	implements Iterator<E>
{
	private final Stack<E> stack;


	/**
	 * Construct an iterator for the specified stack.
	 */
	public StackIterator(Stack<E> stack) {
		super();
		this.stack = stack;
	}

	@Override
	public boolean hasNext() {
		return ! this.stack.isEmpty();
	}

	@Override
	public E next() {
		return this.stack.pop();
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this, this.stack);
	}
}