/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.command;

import org.eclipse.persistence.tools.utility.ExceptionHandler;

/**
 * @see AbstractSafeCommandExecutor
 */
public class SafeCommandExecutor
	extends AbstractSafeCommandExecutor<CommandExecutor>
{
	/**
	 * <strong>NB:</strong> The default exception handler simply
	 * <em>ignores</em> any and all exceptions.
	 */
	public SafeCommandExecutor() {
		this(CommandExecutor.Default.instance());
	}

	/**
	 * <strong>NB:</strong> The default exception handler simply
	 * <em>ignores</em> any and all exceptions.
	 */
	public SafeCommandExecutor(CommandExecutor commandExecutor) {
		super(commandExecutor);
	}

	public SafeCommandExecutor(ExceptionHandler exceptionHandler) {
		this(CommandExecutor.Default.instance(), exceptionHandler);
	}

	public SafeCommandExecutor(CommandExecutor commandExecutor, ExceptionHandler exceptionHandler) {
		super(commandExecutor, exceptionHandler);
	}
}