/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMRepository;
import org.eclipse.persistence.tools.mapping.orm.ORMDocumentType;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/**
 * Defines the concrete implementation of {@link ExternalORMRepository}. This ORM repository knows
 * how to build an ORM meta data from the scope of a Project.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 * @author John Bracken
 */
@SuppressWarnings("nls")
public final class ORMRepository implements ExternalORMRepository {

	/**
	 * Creates a new <code>ORMRepository</code>.
	 */
	public ORMRepository() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ExternalORMConfiguration buildORMConfiguration(ORMDocumentType docType) {

		// Create the external form
		ORMConfiguration ormConfiguration = new ORMConfiguration(XMLTools.newDocument());
		ormConfiguration.addSelf();
		ormConfiguration.setDocumentType(docType);

		return ormConfiguration;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ORMConfiguration getORMConfiguration(String ormXML) {
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			dbf.setValidating(false);
			dbf.setNamespaceAware(false);
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = db.parse(new InputSource(
				new ByteArrayInputStream(ormXML.getBytes("utf-8"))
			));
			return  new ORMConfiguration(doc);
		}
		catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		return null;
	}
}