/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * This interface represents the basis for all convertible mapping types defined by the EclipseLink
 * JPA spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalConvertibleMapping extends ExternalNonTransientMapping {

	/**
	 * Returns the converter string for this mapping.
	 */
	String getConvert();

	/**
	 * Returns the value object type converter for this mapping.
	 */
	ExternalObjectTypeConverter getObjectTypeConverter();

	/**
	 * Returns the value struct converter for this mapping.
	 */
	ExternalStructConverter getStructConverter();

	/**
	 * Returns the value type converter for this mapping.
	 */
	ExternalTypeConverter getTypeConverter();

	/**
	 * Returns the value converter for this mapping.
	 */
	ExternalConverter getValueConverter();

	/**
	 * Removes the value converter from mapping.
	 */
	void removeValueConverter();

	/**
	 * Removes the value object type converter from mapping.
	 */
	void removeValueObjectTypeConverter();

	/**
	 * Removes the value struct converter from mapping.
	 */
	void removeValueStructConverter();

	/**
	 * Removes the value type converter from mapping.
	 */
	void removeValueTypeConverter();

	/**
	 * Sets the mapping to use this converter for its value converter.
	 */
	void setAsValueConverter();

	/**
	 * Sets the mapping to use this object type converter for its value converter.
	 */
	void setAsValueObjectTypeConverter();

	/**
	 * Sets the mapping to use this struct converter for its value converter.
	 */
	void setAsValueStructConverter();

	/**
	 * Sets the mapping to use this type converter for its value converter.
	 */
	void setAsValueTypeConverter();

	/**
	 * Sets the value converter string.
	 */
	void setConvert(String value);
}