/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.iterable;

import java.util.ListIterator;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterable.ArrayListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

public class ArrayListIterableTests
extends TestCase {
    public ArrayListIterableTests(String name) {
        super(name);
    }

    public void testIterator() {
        int i = 1;
        ListIterable<String> iterable = this.buildIterable();
        for (String string : iterable) {
            ArrayListIterableTests.assertEquals((int)i++, (int)Integer.parseInt(string));
        }
        ListIterator stream = iterable.iterator();
        while (stream.hasNext()) {
            stream.next();
        }
        while (stream.hasPrevious()) {
            ArrayListIterableTests.assertEquals((int)(--i), (int)Integer.parseInt((String)stream.previous()));
        }
    }

    public void testSubIterator() {
        int i = 3;
        for (String string : this.buildIterable(2)) {
            ArrayListIterableTests.assertEquals((int)i++, (int)Integer.parseInt(string));
        }
    }

    public void testIllegalArgumentException() {
        this.triggerIllegalArgumentException(-1, 1);
        this.triggerIllegalArgumentException(8, 1);
        this.triggerIllegalArgumentException(0, -1);
        this.triggerIllegalArgumentException(0, 9);
    }

    private void triggerIllegalArgumentException(int start, int end) {
        boolean exCaught = false;
        try {
            ListIterable<String> iterable = this.buildIterable(start, end);
            ArrayListIterableTests.fail((String)("bogus iterable: " + iterable));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ArrayListIterableTests.assertTrue((boolean)exCaught);
    }

    private ListIterable<String> buildIterable() {
        return this.buildIterable(0);
    }

    private ListIterable<String> buildIterable(int start) {
        return this.buildIterable(this.buildArray(), start);
    }

    private ListIterable<String> buildIterable(String[] array, int start) {
        return start == 0 ? new ArrayListIterable((Object[])array) : new ArrayListIterable((Object[])array, start);
    }

    private ListIterable<String> buildIterable(int start, int end) {
        return this.buildIterable(this.buildArray(), start, end);
    }

    private ListIterable<String> buildIterable(String[] array, int start, int end) {
        return new ArrayListIterable((Object[])array, start, end);
    }

    private String[] buildArray() {
        return new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
    }
}

